DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.22248100565334E-11   0.00000000000000E+00   1.97004169621567E-13   1.66478653340532E-22
      1.22247884334523E-08   1.22249854376221E-08  -7.89593879202779E-19  -2.50634423491836E-01  -2.50634423491831E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48782128750844E-12   0.00000000000000E+00  -4.48782128750844E-12
      3.69848470502364E-18  -2.50634423491826E-01  -2.46784373370030E-01   0.00000000000000E+00  -1.99541789872879E-13
     -9.83531228664235E-23  -1.22202980745446E-08  -1.22204976163346E-08  -2.90889082582087E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.24273277020760E-11   0.00000000000000E+00   2.04427106008574E-13   1.68705730269613E-22
      1.24272869206110E-08   1.24274913477172E-08  -7.88042275315781E-19  -2.51349385892236E-01  -2.51349385892232E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74581126117700E-12   0.00000000000000E+00  -4.74581126117700E-12
      3.69528128242235E-18  -2.51349385892031E-01  -2.47435620879607E-01   0.00000000000000E+00  -2.10079541358521E-13
     -9.83784494940895E-23  -1.24225354569145E-08  -1.24227455364560E-08  -2.90723900710657E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.26296616581442E-11   0.00000000000000E+00   3.87984122749532E-14   1.70156976925975E-22
      1.26295624593699E-08   1.26296012577823E-08  -7.86445318605200E-19  -2.52123214179586E-01  -2.52123214179582E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58741381280444E-12   0.00000000000000E+00  -4.58741381280444E-12
      3.69110100158543E-18  -2.52123214179450E-01  -2.48145673396830E-01   0.00000000000000E+00  -4.56073644905049E-14
     -9.84147762120109E-23  -1.26249682366049E-08  -1.26250138439695E-08  -2.90465568298023E-18
      3.31643750000000E-09
      0.00000000000000E+00  -1.28223519168056E-11   0.00000000000000E+00   4.12064447686571E-14   1.70761867693855E-22
      1.28223332809888E-08   1.28223744874338E-08  -7.84873672108113E-19  -2.52920928691175E-01  -2.52920928691171E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04893211429611E-12   0.00000000000000E+00  -4.04893211429611E-12
      3.68612005591008E-18  -2.52920928691209E-01  -2.48882486566458E-01   0.00000000000000E+00  -4.83429245051033E-14
     -9.84612107301875E-23  -1.28182772123949E-08  -1.28183255553195E-08  -2.90124638380196E-18
      4.97719062500000E-09
      0.00000000000000E+00  -1.29970406069743E-11   0.00000000000000E+00   4.12554921354974E-14   1.70644479832601E-22
      1.29970415736615E-08   1.29970828291538E-08  -7.83404424978035E-19  -2.53694847297804E-01  -2.53694847297800E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.23858909853332E-12   0.00000000000000E+00  -3.23858909853332E-12
      3.68074155894410E-18  -2.53694847298680E-01  -2.49601108706948E-01   0.00000000000000E+00  -4.76392272182475E-14
     -9.85141037654953E-23  -1.29937966008279E-08  -1.29938442400552E-08  -2.89733713396606E-18
      6.97719062500000E-09
      0.00000000000000E+00  -1.31351750917344E-11   0.00000000000000E+00   2.80388573919295E-14   1.70138745877251E-22
      1.31351596322909E-08   1.31351876711484E-08  -7.82213913564044E-19  -2.54337765695302E-01  -2.54337765695299E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39854136239704E-12   0.00000000000000E+00  -2.39854136239704E-12
      3.67594447621930E-18  -2.54337765696697E-01  -2.50200248909591E-01   0.00000000000000E+00  -3.31146171536551E-14
     -9.85631196591311E-23  -1.31327560151688E-08  -1.31327891297860E-08  -2.89373056265526E-18
      8.97719062500000E-09
      0.00000000000000E+00  -1.32283975000001E-11   0.00000000000000E+00   2.31555197646388E-15   1.69614273526729E-22
      1.32283978852192E-08   1.32284002007714E-08  -7.81397129911867E-19  -2.54785260091893E-01  -2.54785260091891E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74215349098722E-12   0.00000000000000E+00  -1.74215349098722E-12
      3.67246016923733E-18  -2.54785260092958E-01  -2.50618162199519E-01   0.00000000000000E+00  -6.12819834257006E-15
     -9.85996515411526E-23  -1.32266519190820E-08  -1.32266580472804E-08  -2.89106303932546E-18
      1.09771906250000E-08
      0.00000000000000E+00  -1.32924132818337E-11   0.00000000000000E+00   5.38152302446541E-15   1.69173897402749E-22
      1.32924171296115E-08   1.32924225111347E-08  -7.80830177505578E-19  -2.55098453555926E-01  -2.55098453555925E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25172203662415E-12   0.00000000000000E+00  -1.25172203662415E-12
      3.66995672516408E-18  -2.55098453556331E-01  -2.50911032148800E-01   0.00000000000000E+00  -8.21535754786317E-15
     -9.86263676755273E-23  -1.32911625737404E-08  -1.32911707890981E-08  -2.88912654765850E-18
      1.29771906250000E-08
      0.00000000000000E+00  -1.33367742899050E-11   0.00000000000000E+00   2.81814053666222E-14   1.68833070237644E-22
      1.33368459677851E-08   1.33368741491907E-08  -7.80433914335506E-19  -2.55318391402432E-01  -2.55318391402431E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93691102245723E-13   0.00000000000000E+00  -8.93691102245723E-13
      3.66816934295959E-18  -2.55318391400055E-01  -2.51116860050774E-01   0.00000000000000E+00  -3.03439753264998E-14
     -9.86456760806570E-23  -1.33359501141130E-08  -1.33359804580884E-08  -2.88773542862408E-18
      1.49771906250000E-08
      0.00000000000000E+00  -1.33679096558183E-11   0.00000000000000E+00   3.13503113161681E-15   1.68579623050702E-22
      1.33678979739663E-08   1.33679011089976E-08  -7.80155892428407E-19  -2.55473131272522E-01  -2.55473131272522E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35614103902292E-13   0.00000000000000E+00  -6.35614103902292E-13
      3.66689811475178E-18  -2.55473131267956E-01  -2.51261735836199E-01   0.00000000000000E+00  -4.62751715043954E-15
     -9.86595674878366E-23  -1.33672608673764E-08  -1.33672654948937E-08  -2.88674222232338E-18
      1.69771906250000E-08
      0.00000000000000E+00  -1.33896768585365E-11   0.00000000000000E+00   1.41782879135872E-14   1.68394768573703E-22
      1.33896664704296E-08   1.33896806487177E-08  -7.79960314254071E-19  -2.55582154077517E-01  -2.55582154077517E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51000312358742E-13   0.00000000000000E+00  -4.51000312358742E-13
      3.66599611412707E-18  -2.55582154071324E-01  -2.51363842394443E-01   0.00000000000000E+00  -1.53092653057239E-14
     -9.86694736713751E-23  -1.33892143391399E-08  -1.33892296484053E-08  -2.88603579987300E-18
      1.89771906250000E-08
      0.00000000000000E+00  -1.34050149296502E-11   0.00000000000000E+00   9.21330122407828E-16   1.68261746670627E-22
      1.34049783222957E-08   1.34049792436260E-08  -7.79822563190465E-19  -2.55659016343921E-01  -2.55659016343921E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19514588996143E-13   0.00000000000000E+00  -3.19514588996143E-13
      3.66535708494907E-18  -2.55659016335648E-01  -2.51435839316351E-01   0.00000000000000E+00  -1.68212082050163E-15
     -9.86765494849944E-23  -1.34046580469161E-08  -1.34046597290370E-08  -2.88553452175861E-18
      2.09771906250000E-08
      0.00000000000000E+00  -1.34157607639034E-11   0.00000000000000E+00   3.40910877134411E-15   1.68166536988531E-22
      1.34157557154584E-08   1.34157591245674E-08  -7.79725436872210E-19  -2.55713239565768E-01  -2.55713239565768E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26146911718674E-13   0.00000000000000E+00  -2.26146911718674E-13
      3.66490479112563E-18  -2.55713239557044E-01  -2.51486637749447E-01   0.00000000000000E+00  -3.96704022611096E-15
     -9.86815674098564E-23  -1.34155290106154E-08  -1.34155329776557E-08  -2.88517935425343E-18
      2.29771906250000E-08
      0.00000000000000E+00  -1.34233838770917E-11   0.00000000000000E+00   3.19444407331521E-16   1.68098762546988E-22
      1.34233533816942E-08   1.34233537011388E-08  -7.79656923339290E-19  -2.55751502375263E-01  -2.55751502375263E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59957439918393E-13   0.00000000000000E+00  -1.59957439918393E-13
      3.66458487624580E-18  -2.55751502367931E-01  -2.51522486099574E-01   0.00000000000000E+00  -7.03330221832120E-16
     -9.86851336444867E-23  -1.34231930403685E-08  -1.34231937436989E-08  -2.88492795290651E-18
      2.49771906250000E-08
      0.00000000000000E+00  -1.34287108718497E-11   0.00000000000000E+00   8.93596918450103E-16   1.68050607417979E-22
      1.34287107415381E-08   1.34287116351352E-08  -7.79608572209051E-19  -2.55778510408073E-01  -2.55778510408073E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13093583169833E-13   0.00000000000000E+00  -1.13093583169833E-13
      3.66435868907946E-18  -2.55778510405492E-01  -2.51547791559770E-01   0.00000000000000E+00  -1.17016465727489E-15
     -9.86876582851963E-23  -1.34285973713872E-08  -1.34285985415520E-08  -2.88475011687041E-18
      2.69771906250000E-08
      0.00000000000000E+00  -1.34325683508124E-11   0.00000000000000E+00   7.17533430998623E-16   1.68016480496373E-22
      1.34324908497852E-08   1.34324915673188E-08  -7.79574442975740E-19  -2.55797576977924E-01  -2.55797576977924E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.99357138188584E-14   0.00000000000000E+00  -7.99357138188584E-14
      3.66419881765182E-18  -2.55797576984609E-01  -2.51565656787023E-01   0.00000000000000E+00  -9.18053646387632E-16
     -9.86894477326120E-23  -1.34324107135513E-08  -1.34324116316050E-08  -2.88462437467608E-18
      2.89771906250000E-08
      0.00000000000000E+00  -1.34351400034542E-11   0.00000000000000E+00   2.53460385931436E-16   1.67992291495271E-22
      1.34351587191399E-08   1.34351589726004E-08  -7.79550348603365E-19  -2.55811038621497E-01  -2.55811038621497E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64883392272187E-14   0.00000000000000E+00  -5.64883392272187E-14
      3.66408584097337E-18  -2.55811038641596E-01  -2.51578270556963E-01   0.00000000000000E+00  -3.92025534941350E-16
     -9.86907133771285E-23  -1.34351020922356E-08  -1.34351024842612E-08  -2.88453549237000E-18
      3.09771906250000E-08
      0.00000000000000E+00  -1.34369768981984E-11   0.00000000000000E+00   2.01162560434693E-16   1.67975182324727E-22
      1.34370418209401E-08   1.34370420221028E-08  -7.79533336529565E-19  -2.55820543993710E-01  -2.55820543993710E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99131147512338E-14   0.00000000000000E+00  -3.99131147512338E-14
      3.66400601474386E-18  -2.55820544030795E-01  -2.51587177461271E-01   0.00000000000000E+00  -2.99656095348293E-16
     -9.86916091480324E-23  -1.34370018093319E-08  -1.34370021089881E-08  -2.88447267821430E-18
      3.29771906250000E-08
      0.00000000000000E+00  -1.34383545692565E-11   0.00000000000000E+00   9.32088611398267E-16   1.67963089713286E-22
      1.34383711016001E-08   1.34383720336889E-08  -7.79521323129005E-19  -2.55827256584720E-01  -2.55827256584720E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81987953607472E-14   0.00000000000000E+00  -2.81987953607472E-14
      3.66394961715314E-18  -2.55827256641371E-01  -2.51593467597301E-01   0.00000000000000E+00  -1.01231939809695E-15
     -9.86922424570603E-23  -1.34383428225740E-08  -1.34383438348935E-08  -2.88442829402414E-18
      3.49771906250000E-08
      0.00000000000000E+00  -1.34393648613658E-11   0.00000000000000E+00   6.14234112619892E-17   1.67954520549146E-22
      1.34393100517043E-08   1.34393101131279E-08  -7.79512840510936E-19  -2.55831996497839E-01  -2.55831996497839E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99210138843085E-14   0.00000000000000E+00  -1.99210138843085E-14
      3.66390977512538E-18  -2.55831996566016E-01  -2.51597909102632E-01   0.00000000000000E+00  -1.11631476965587E-16
     -9.86926902213737E-23  -1.34392900804824E-08  -1.34392901921140E-08  -2.88439693461444E-18
      3.69771906250000E-08
      0.00000000000000E+00  -1.34399159297890E-11   0.00000000000000E+00   2.39567976907728E-16   1.67948472793741E-22
      1.34399727794497E-08   1.34399730190178E-08  -7.79506849942020E-19  -2.55835344033628E-01  -2.55835344033628E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40727478402262E-14   0.00000000000000E+00  -1.40727478402262E-14
      3.66388162962969E-18  -2.55835344097801E-01  -2.51601046002080E-01   0.00000000000000E+00  -2.76695908998181E-16
     -9.86930067225565E-23  -1.34399586695740E-08  -1.34399589462700E-08  -2.88437477968767E-18
      3.89771906250000E-08
      0.00000000000000E+00  -1.34403751534750E-11   0.00000000000000E+00   2.10971869205345E-17   1.67944194324622E-22
      1.34404408854696E-08   1.34404409065670E-08  -7.79502619379999E-19  -2.55837708104110E-01  -2.55837708104110E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94081039307075E-15   0.00000000000000E+00  -9.94081039307075E-15
      3.66386174800891E-18  -2.55837708143140E-01  -2.51603261271121E-01   0.00000000000000E+00  -4.57001249074675E-17
     -9.86932304088693E-23  -1.34404309200564E-08  -1.34404309657566E-08  -2.88435912862891E-18
      4.09771906250000E-08
      0.00000000000000E+00  -1.34407425324239E-11   0.00000000000000E+00   6.36663326017715E-17   1.67941173547606E-22
      1.34407713980719E-08   1.34407714617384E-08  -7.79499631474213E-19  -2.55839377795048E-01  -2.55839377795048E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02201889623300E-15   0.00000000000000E+00  -7.02201889623300E-15
      3.66384770397112E-18  -2.55839377779167E-01  -2.51604825860974E-01   0.00000000000000E+00  -8.14622569611991E-17
     -9.86933884719047E-23  -1.34407643582571E-08  -1.34407644397195E-08  -2.88434807249690E-18
      4.29771906250000E-08
      0.00000000000000E+00  -1.34410180666355E-11   0.00000000000000E+00   8.15188967584381E-18   1.67939038173626E-22
      1.34410048461929E-08   1.34410048543450E-08  -7.79497521225756E-19  -2.55840557042468E-01  -2.55840557042468E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.96013386346927E-15   0.00000000000000E+00  -4.96013386346927E-15
      3.66383778370339E-18  -2.55840556938051E-01  -2.51605930823527E-01   0.00000000000000E+00  -2.03181236093544E-17
     -9.86935001542522E-23  -1.34409998738929E-08  -1.34409998942111E-08  -2.88434026247763E-18
      4.49771906250000E-08
      0.00000000000000E+00  -1.34412017561099E-11   0.00000000000000E+00   1.78849313226832E-17   1.67937530170512E-22
      1.34411697050327E-08   1.34411697229178E-08  -7.79496030760496E-19  -2.55841389949932E-01  -2.55841389949932E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.50369676218747E-15   0.00000000000000E+00  -3.50369676218747E-15
      3.66383077630987E-18  -2.55841389728054E-01  -2.51606711216623E-01   0.00000000000000E+00  -2.65769217915657E-17
     -9.86935790550752E-23  -1.34411661926440E-08  -1.34411662192211E-08  -2.88433474554937E-18
      4.69771906250000E-08
      0.00000000000000E+00  -1.34412936008471E-11   0.00000000000000E+00   3.47725376834956E-18   1.67936464547293E-22
      1.34412861458579E-08   1.34412861493353E-08  -7.79494978064109E-19  -2.55841978225495E-01  -2.55841978225495E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47487325634739E-15   0.00000000000000E+00  -2.47487325634739E-15
      3.66382582656335E-18  -2.55841977874604E-01  -2.51607262354901E-01   0.00000000000000E+00  -9.51780310189091E-18
     -9.86936347942691E-23  -1.34412836649441E-08  -1.34412836744620E-08  -2.88433084849924E-18
      4.89771906250000E-08
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00   5.47422817327580E-18   1.67935711860058E-22
      1.34413683765342E-08   1.34413683820086E-08  -7.79494234576074E-19  -2.55842393712931E-01  -2.55842393712931E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74809452912363E-15   0.00000000000000E+00  -1.74809452912363E-15
      3.66382233037429E-18  -2.55842393254093E-01  -2.51607651599009E-01   0.00000000000000E+00  -9.76551671560181E-18
     -9.86936741688456E-23  -1.34413666241484E-08  -1.34413666339140E-08  -2.88432809579822E-18
      5.09771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.59328645774664E-18   1.67935179988170E-22
      1.34414264444679E-08   1.34414264460614E-08  -7.79493709545002E-19  -2.55842687126634E-01  -2.55842687126634E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23460229479794E-15   0.00000000000000E+00  -1.23460229479794E-15
      3.66381986116971E-18  -2.55842686630481E-01  -2.51607926519586E-01   0.00000000000000E+00  -4.59728426964400E-18
     -9.86937019872183E-23  -1.34414252068617E-08  -1.34414252114591E-08  -2.88432615162470E-18
      5.29771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.87265032431571E-18   1.67934804171700E-22
      1.34414674354309E-08   1.34414674373038E-08  -7.79493338883332E-19  -2.55842894281430E-01  -2.55842894281430E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71723869979250E-16   0.00000000000000E+00  -8.71723869979250E-16
      3.66381811772196E-18  -2.55842893879960E-01  -2.51608120740724E-01   0.00000000000000E+00  -4.00448304401767E-18
     -9.86937216473810E-23  -1.34414665615753E-08  -1.34414665655799E-08  -2.88432477883863E-18
      5.49771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.57091385961197E-19   1.67934538514354E-22
      1.34414963577952E-08   1.34414963585524E-08  -7.79493077336970E-19  -2.55843040466009E-01  -2.55843040466009E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15198201738641E-16   0.00000000000000E+00  -6.15198201738641E-16
      3.66381688732556E-18  -2.55843040354021E-01  -2.51608258022109E-01   0.00000000000000E+00  -2.25592270621992E-18
     -9.86937355534410E-23  -1.34414957410982E-08  -1.34414957433542E-08  -2.88432380998859E-18
      5.69771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.14091227334054E-19   1.67934350712309E-22
      1.34415167499891E-08   1.34415167507033E-08  -7.79492892918828E-19  -2.55843143552996E-01  -2.55843143552996E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.33815162278505E-16   0.00000000000000E+00  -4.33815162278505E-16
      3.66381601969523E-18  -2.55843143969770E-01  -2.51608355156248E-01   0.00000000000000E+00  -1.78646712105161E-18
     -9.86937454031904E-23  -1.34415163151016E-08  -1.34415163168882E-08  -2.88432312677641E-18
      5.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.67818514075039E-19   1.67934217965361E-22
      1.34415311192306E-08   1.34415311195986E-08  -7.79492762982120E-19  -2.55843216192268E-01  -2.55843216192268E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.05599365912556E-16   0.00000000000000E+00  -3.05599365912556E-16
      3.66381540849650E-18  -2.55843217376760E-01  -2.51608423995879E-01   0.00000000000000E+00  -1.12280853978349E-18
     -9.86937523944716E-23  -1.34415308128763E-08  -1.34415308139992E-08  -2.88432264551438E-18
      6.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.09155997567544E-19   1.67934124268231E-22
      1.34415412477887E-08   1.34415412480980E-08  -7.79492671432117E-19  -2.55843267368655E-01  -2.55843267368655E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15128295471170E-16   0.00000000000000E+00  -2.15128295471170E-16
      3.66381497823991E-18  -2.55843269482835E-01  -2.51608472882496E-01   0.00000000000000E+00  -8.43964069482288E-19
     -9.86937573668908E-23  -1.34415410321257E-08  -1.34415410329697E-08  -2.88432230680780E-18
      6.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.80958391269193E-19   1.67934058391934E-22
      1.34415484106025E-08   1.34415484107836E-08  -7.79492606764233E-19  -2.55843303498843E-01  -2.55843303498843E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51611449401755E-16   0.00000000000000E+00  -1.51611449401755E-16
      3.66381467501702E-18  -2.55843306521964E-01  -2.51608507645004E-01   0.00000000000000E+00  -5.63272450481980E-19
     -9.86937609033907E-23  -1.34415482586088E-08  -1.34415482591722E-08  -2.88432206825278E-18
      6.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.40761875172478E-19   1.67934012481801E-22
      1.34415535258747E-08   1.34415535260156E-08  -7.79492560691496E-19  -2.55843329200115E-01  -2.55843329200115E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07512493746349E-16   0.00000000000000E+00  -1.07512493746349E-16
      3.66381445999203E-18  -2.55843332806726E-01  -2.51608532304329E-01   0.00000000000000E+00  -4.10988756691308E-19
     -9.86937634007627E-23  -1.34415534180920E-08  -1.34415534185031E-08  -2.88432189930053E-18
      6.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   9.36925028270042E-20   1.67933981009276E-22
      1.34415572574657E-08   1.34415572575595E-08  -7.79492527212179E-19  -2.55843347814926E-01  -2.55843347814926E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.75302399762443E-17   0.00000000000000E+00  -7.75302399762443E-17
      3.66381430493155E-18  -2.55843351264455E-01  -2.51608549576989E-01   0.00000000000000E+00  -2.78228144448132E-19
     -9.86937651222519E-23  -1.34415571797510E-08  -1.34415571800293E-08  -2.88432177771937E-18
      6.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   7.45297067188381E-20   1.67933960001756E-22
      1.34415600803544E-08   1.34415600804291E-08  -7.79492502005932E-19  -2.55843361753560E-01  -2.55843361753560E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.78312038251595E-17   0.00000000000000E+00  -5.78312038251595E-17
      3.66381418926914E-18  -2.55843363834616E-01  -2.51608561251601E-01   0.00000000000000E+00  -1.89680225077157E-19
     -9.86937662377312E-23  -1.34415600224081E-08  -1.34415600225979E-08  -2.88432168726321E-18
      7.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   5.65483542340615E-20   1.67933946449986E-22
      1.34415623185327E-08   1.34415623185895E-08  -7.79492482081664E-19  -2.55843372697482E-01  -2.55843372697482E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.54552094650979E-17   0.00000000000000E+00  -4.54552094650979E-17
      3.66381409835872E-18  -2.55843371783293E-01  -2.51608568491245E-01   0.00000000000000E+00  -1.17425620320388E-19
     -9.86937668586065E-23  -1.34415622730167E-08  -1.34415622731343E-08  -2.88432161627706E-18
      7.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.72796912567580E-20   1.67933937863381E-22
      1.34415641630353E-08   1.34415641630828E-08  -7.79492465608521E-19  -2.55843381700444E-01  -2.55843381700444E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.78629419686171E-17   0.00000000000000E+00  -3.78629419686171E-17
      3.66381402263283E-18  -2.55843375975832E-01  -2.51608572100280E-01   0.00000000000000E+00  -5.79876671312868E-20
     -9.86937670699710E-23  -1.34415641251618E-08  -1.34415641252199E-08  -2.88432155702432E-18
      7.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.78153402489550E-20   1.67933931956232E-22
      1.34415656782354E-08   1.34415656782733E-08  -7.79492451862783E-19  -2.55843389222967E-01  -2.55843389222967E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.26204916992050E-17   0.00000000000000E+00  -3.26204916992050E-17
      3.66381395739185E-18  -2.55843377131114E-01  -2.51608572776543E-01   0.00000000000000E+00  -1.40182126521372E-20
     -9.86937669621826E-23  -1.34415656456387E-08  -1.34415656456528E-08  -2.88432150552907E-18
      7.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   2.84991269091003E-20   1.67933926481721E-22
      1.34415668057678E-08   1.34415668057964E-08  -7.79492441210641E-19  -2.55843395141965E-01  -2.55843395141965E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72466547066566E-17   0.00000000000000E+00  -2.72466547066566E-17
      3.66381390289854E-18  -2.55843376063002E-01  -2.51608571351505E-01   0.00000000000000E+00   1.72900433676849E-20
     -9.86937666600213E-23  -1.34415667785670E-08  -1.34415667785498E-08  -2.88432146168790E-18
      7.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.42961993870523E-20   1.67933919241388E-22
      1.34415673770290E-08   1.34415673770434E-08  -7.79492435032857E-19  -2.55843398784757E-01  -2.55843398784757E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.92622119207249E-17   0.00000000000000E+00  -1.92622119207249E-17
      3.66381386437412E-18  -2.55843373892657E-01  -2.51608568998669E-01   0.00000000000000E+00   2.86984726597960E-20
     -9.86937663456489E-23  -1.34415673578098E-08  -1.34415673577812E-08  -2.88432142934126E-18
      8.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -5.96574164008760E-21   1.67933908302026E-22
      1.34415671460956E-08   1.34415671460898E-08  -7.79492435485444E-19  -2.55843399043451E-01  -2.55843399043451E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48181468517204E-18   0.00000000000000E+00  -6.48181468517204E-18
      3.66381385141049E-18  -2.55843372193208E-01  -2.51608567367955E-01   0.00000000000000E+00   1.14011138517186E-20
     -9.86937662678985E-23  -1.34415671396193E-08  -1.34415671396080E-08  -2.88432141592504E-18
      8.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -3.16685414591529E-20   1.67933892432566E-22
      1.34415658538270E-08   1.34415658537955E-08  -7.79492444995192E-19  -2.55843394624536E-01  -2.55843394624536E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24357500122644E-17   0.00000000000000E+00   1.24357500122644E-17
      3.66381387628199E-18  -2.55843373007779E-01  -2.51608568583713E-01   0.00000000000000E+00  -3.42545496379033E-20
     -9.86937667290096E-23  -1.34415658661969E-08  -1.34415658662312E-08  -2.88432143128680E-18
      8.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -6.17148840112679E-20   1.67933871732118E-22
      1.34415633295521E-08   1.34415633294906E-08  -7.79492465419996E-19  -2.55843384473993E-01  -2.55843384473993E-01
      0.00000000000000E+00   0.00000000000000E+00   3.72154403771122E-17   0.00000000000000E+00   3.72154403771122E-17
      3.66381395071287E-18  -2.55843378670893E-01  -2.51608575034323E-01   0.00000000000000E+00  -1.18462583996025E-19
     -9.86937680392535E-23  -1.34415633665875E-08  -1.34415633667060E-08  -2.88432148529288E-18
      8.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -9.15216458905284E-20   1.67933848350979E-22
      1.34415596277043E-08   1.34415596276130E-08  -7.79492496875387E-19  -2.55843368382938E-01  -2.55843368382938E-01
      0.00000000000000E+00   0.00000000000000E+00   6.50935972838180E-17   0.00000000000000E+00   6.50935972838180E-17
      3.66381408090007E-18  -2.55843391369274E-01  -2.51608588890233E-01   0.00000000000000E+00  -2.31725718733078E-19
     -9.86937704331259E-23  -1.34415596924747E-08  -1.34415596927066E-08  -2.88432158402468E-18
      8.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.07156570869409E-19   1.67933827118314E-22
      1.34415551829232E-08   1.34415551828163E-08  -7.79492536344355E-19  -2.55843347720118E-01  -2.55843347720118E-01
      0.00000000000000E+00   0.00000000000000E+00   9.00736059642886E-17   0.00000000000000E+00   9.00736059642886E-17
      3.66381426104728E-18  -2.55843412411221E-01  -2.51608611324693E-01   0.00000000000000E+00  -3.59956244513195E-19
     -9.86937739480344E-23  -1.34415552725298E-08  -1.34415552728899E-08  -2.88432172470292E-18
      9.09771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.05252727507260E-19   1.67933815793873E-22
      1.34415509487288E-08   1.34415509486237E-08  -7.79492576346859E-19  -2.55843326155056E-01  -2.55843326155056E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02654132611500E-16   0.00000000000000E+00   1.02654132611500E-16
      3.66381446635554E-18  -2.55843441241560E-01  -2.51608641485105E-01   0.00000000000000E+00  -4.63477041507529E-19
     -9.86937782783548E-23  -1.34415510508143E-08  -1.34415510512778E-08  -2.88432189000868E-18
      9.29771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -6.18685082595105E-20   1.67933824588787E-22
      1.34415484652434E-08   1.34415484651817E-08  -7.79492604123792E-19  -2.55843310141016E-01  -2.55843310141016E-01
      0.00000000000000E+00   0.00000000000000E+00   9.04576688795073E-17   0.00000000000000E+00   9.04576688795073E-17
      3.66381464727088E-18  -2.55843474343452E-01  -2.51608675373299E-01   0.00000000000000E+00  -4.96288620528011E-19
     -9.86937826352611E-23  -1.34415485551429E-08  -1.34415485556393E-08  -2.88432204314709E-18
      9.49771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.28682736835237E-20   1.67933864585474E-22
      1.34415497852861E-08   1.34415497853191E-08  -7.79492601950749E-19  -2.55843308838695E-01  -2.55843308838695E-01
      0.00000000000000E+00   0.00000000000000E+00   4.02020157184121E-17   0.00000000000000E+00   4.02020157184121E-17
      3.66381472767491E-18  -2.55843504302677E-01  -2.51608704932473E-01   0.00000000000000E+00  -4.01054388638286E-19
     -9.86937856607009E-23  -1.34415498251200E-08  -1.34415498255212E-08  -2.88432212572416E-18
      9.69771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   2.02666960633951E-19   1.67933944781476E-22
      1.34415571833636E-08   1.34415571835664E-08  -7.79492549270140E-19  -2.55843333114875E-01  -2.55843333114875E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86664800937316E-17   0.00000000000000E+00  -5.86664800937316E-17
      3.66381461034195E-18  -2.55843519449928E-01  -2.51608717780034E-01   0.00000000000000E+00  -1.28996818161232E-19
     -9.86937854623125E-23  -1.34415571247709E-08  -1.34415571249000E-08  -2.88432206107181E-18
      9.89771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.92017990893445E-19   1.67934067728856E-22
      1.34415725882671E-08   1.34415725886593E-08  -7.79492427236493E-19  -2.55843393287083E-01  -2.55843393287083E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08663815489463E-16   0.00000000000000E+00  -2.08663815489463E-16
      3.66381419301432E-18  -2.55843504604343E-01  -2.51608698128224E-01   0.00000000000000E+00   4.11606911404474E-19
     -9.86937798425709E-23  -1.34415723804070E-08  -1.34415723799955E-08  -2.88432176577783E-18
      1.00977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   6.84710589857657E-19   1.67934224169600E-22
      1.34415967259417E-08   1.34415967266266E-08  -7.79492225919701E-19  -2.55843495453149E-01  -2.55843495453149E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.97794840969177E-16   0.00000000000000E+00  -3.97794840969177E-16
      3.66381339742464E-18  -2.55843443457266E-01  -2.51608629435884E-01   0.00000000000000E+00   1.10374084440043E-18
     -9.86937667862065E-23  -1.34415963299354E-08  -1.34415963288318E-08  -2.88432117150494E-18
      1.02977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   7.89354306952241E-19   1.67934387670934E-22
      1.34416280431884E-08   1.34416280439779E-08  -7.79491953733649E-19  -2.55843636583427E-01  -2.55843636583427E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.93165471474780E-16   0.00000000000000E+00  -5.93165471474780E-16
      3.66381221109370E-18  -2.55843322989443E-01  -2.51608499162744E-01   0.00000000000000E+00   2.10693096060587E-18
     -9.86937452325591E-23  -1.34416274529193E-08  -1.34416274508124E-08  -2.88432025736004E-18
      1.04977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   8.98286700976930E-19   1.67934510973769E-22
      1.34416616005797E-08   1.34416616014782E-08  -7.79491647647496E-19  -2.55843799071240E-01  -2.55843799071240E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.36767834529554E-16   0.00000000000000E+00  -7.36767834529554E-16
      3.66381073755803E-18  -2.55843139945128E-01  -2.51608305591005E-01   0.00000000000000E+00   2.95456189458490E-18
     -9.86937160851676E-23  -1.34416608676648E-08  -1.34416608647104E-08  -2.88431908991053E-18
      1.06977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   6.64554722716208E-19   1.67934526417067E-22
      1.34416882679968E-08   1.34416882686615E-08  -7.79491381467005E-19  -2.55843946101707E-01  -2.55843946101707E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.46327613636788E-16   0.00000000000000E+00  -7.46327613636788E-16
      3.66380924490280E-18  -2.55842908741171E-01  -2.51608065988136E-01   0.00000000000000E+00   3.59725991026841E-18
     -9.86936833066587E-23  -1.34416875259311E-08  -1.34416875223339E-08  -2.88431786343579E-18
      1.08977190625000E-07
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00   2.35299311364816E-19   1.67934353179725E-22
      1.34416946905278E-08   1.34416946907633E-08  -7.79491268189177E-19  -2.55844019891029E-01  -2.55844019891029E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.24481014722023E-16   0.00000000000000E+00  -5.24481014722023E-16
      3.66380819594077E-18  -2.55842669300789E-01  -2.51607824454303E-01   0.00000000000000E+00   3.35672823016285E-18
     -9.86936548045477E-23  -1.34416941696389E-08  -1.34416941662823E-08  -2.88431692775159E-18
      1.10977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00  -5.61130855307075E-19   1.67933913809498E-22
      1.34416645793511E-08   1.34416645787901E-08  -7.79491451506678E-19  -2.55843945378581E-01  -2.55843945378581E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07662333893052E-17   0.00000000000000E+00   2.07662333893052E-17
      3.66380823747324E-18  -2.55842492254856E-01  -2.51607656723386E-01   0.00000000000000E+00   1.85294252789831E-18
     -9.86936426845058E-23  -1.34416646014092E-08  -1.34416645995563E-08  -2.88431678596656E-18
      1.12977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.77273238171469E-19   1.67933161314594E-22
      1.34415818466393E-08   1.34415818464622E-08  -7.79492081535236E-19  -2.55843642032101E-01  -2.55843642032101E-01
      0.00000000000000E+00   0.00000000000000E+00   9.42899755343570E-16   0.00000000000000E+00   9.42899755343570E-16
      3.66381012327275E-18  -2.55842478002969E-01  -2.51607668246798E-01   0.00000000000000E+00  -2.85723361788283E-18
     -9.86936623386433E-23  -1.34415827865046E-08  -1.34415827893619E-08  -2.88431804173751E-18
      1.14977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -2.87174745162155E-18   1.67932115561623E-22
      1.34414358827288E-08   1.34414358798572E-08  -7.79493271436353E-19  -2.55843045694118E-01  -2.55843045694118E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21275626637542E-15   0.00000000000000E+00   2.21275626637542E-15
      3.66381454878528E-18  -2.55842745609547E-01  -2.51607981440869E-01   0.00000000000000E+00  -6.55498390396297E-18
     -9.86937298454745E-23  -1.34414380860584E-08  -1.34414380926135E-08  -2.88432127734893E-18
      1.16977190625000E-07
      0.00000000000000E+00  -1.34412017561099E-11   0.00000000000000E+00   3.53430871683081E-19   1.67930904021683E-22
      1.34412287913198E-08   1.34412287916733E-08  -7.79495035281737E-19  -2.55842140588206E-01  -2.55842140588206E-01
      0.00000000000000E+00   0.00000000000000E+00   3.66966728879880E-15   0.00000000000000E+00   3.66966728879880E-15
      3.66382188811986E-18  -2.55843407940342E-01  -2.51608708559211E-01   0.00000000000000E+00  -1.77309266715402E-17
     -9.86938573229139E-23  -1.34412324436096E-08  -1.34412324613406E-08  -2.88432685283812E-18
      1.18977190625000E-07
      0.00000000000000E+00  -1.34409262218983E-11   0.00000000000000E+00  -5.58568256537580E-18   1.67929796665947E-22
      1.34409836713109E-08   1.34409836657254E-08  -7.79497213885009E-19  -2.55840998374543E-01  -2.55840998374543E-01
      0.00000000000000E+00   0.00000000000000E+00   4.98024461526492E-15   0.00000000000000E+00   4.98024461526492E-15
      3.66383184860909E-18  -2.55844531270938E-01  -2.51609908704911E-01   0.00000000000000E+00  -1.96599058868782E-17
     -9.86940462697505E-23  -1.34409886263100E-08  -1.34409886459700E-08  -2.88433463472408E-18
      1.20977190625000E-07
      0.00000000000000E+00  -1.34407425324239E-11   0.00000000000000E+00  -3.92574147249285E-18   1.67929220250976E-22
      1.34407519938301E-08   1.34407519899045E-08  -7.79499403700304E-19  -2.55839816800776E-01  -2.55839816800776E-01
      0.00000000000000E+00   0.00000000000000E+00   5.62330666156544E-15   0.00000000000000E+00   5.62330666156544E-15
      3.66384309522241E-18  -2.55846081382298E-01  -2.51611531606583E-01   0.00000000000000E+00  -2.68566422858539E-17
     -9.86942796272936E-23  -1.34407575863544E-08  -1.34407576132112E-08  -2.88434369152211E-18
      1.22977190625000E-07
      0.00000000000000E+00  -1.34406506876867E-11   0.00000000000000E+00  -2.57910971846029E-18   1.67929732191725E-22
      1.34406171539918E-08   1.34406171514128E-08  -7.79500913733783E-19  -2.55838945278239E-01  -2.55838945278239E-01
      0.00000000000000E+00   0.00000000000000E+00   4.92405701645710E-15   0.00000000000000E+00   4.92405701645710E-15
      3.66385294333645E-18  -2.55847863782826E-01  -2.51613356710664E-01   0.00000000000000E+00  -2.75330571663065E-17
     -9.86945141567420E-23  -1.34406220479367E-08  -1.34406220754699E-08  -2.88435202960266E-18
      1.24977190625000E-07
      0.00000000000000E+00  -1.34407425324239E-11   0.00000000000000E+00   1.54280699286221E-17   1.67931934783359E-22
      1.34406902962531E-08   1.34406903116814E-08  -7.79500783867702E-19  -2.55838880058596E-01  -2.55838880058596E-01
      0.00000000000000E+00   0.00000000000000E+00   2.16144998490977E-15   0.00000000000000E+00   2.16144998490977E-15
      3.66385726623641E-18  -2.55849473045951E-01  -2.51614943800371E-01   0.00000000000000E+00  -3.49951575078001E-17
     -9.86946758388425E-23  -1.34406924381361E-08  -1.34406924731313E-08  -2.88435648236871E-18
      1.26977190625000E-07
      0.00000000000000E+00  -1.34411099113727E-11   0.00000000000000E+00   2.67957467311666E-17   1.67936314281237E-22
      1.34410943797986E-08   1.34410944065945E-08  -7.79497902120508E-19  -2.55840209073972E-01  -2.55840209073972E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.23410210540825E-15   0.00000000000000E+00  -3.23410210540825E-15
      3.66385079803220E-18  -2.55850273812487E-01  -2.51615618956200E-01   0.00000000000000E+00  -2.22979103870784E-17
     -9.86946618365973E-23  -1.34410911501944E-08  -1.34410911724924E-08  -2.88435289591169E-18
      1.28977190625000E-07
      0.00000000000000E+00  -1.34419365140076E-11   0.00000000000000E+00   1.74172422334837E-16   1.67943004487735E-22
      1.34419332236120E-08   1.34419333977845E-08  -7.79491252371425E-19  -2.55843488947214E-01  -2.55843488947214E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13928631235343E-14   0.00000000000000E+00  -1.13928631235343E-14
      3.66382801230596E-18  -2.55849441844343E-01  -2.51614525271538E-01   0.00000000000000E+00  -1.30774885327853E-16
     -9.86943530373817E-23  -1.34419218741464E-08  -1.34419220049214E-08  -2.88433675993453E-18
      1.30977190625000E-07
      0.00000000000000E+00  -1.34433141850657E-11   0.00000000000000E+00   7.81575671162683E-17   1.67951494295354E-22
      1.34432450800561E-08   1.34432451582138E-08  -7.79480306830240E-19  -2.55849044971967E-01  -2.55849044971967E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16546090687753E-14   0.00000000000000E+00  -2.16546090687753E-14
      3.66378470308782E-18  -2.55846093910654E-01  -2.51610767255597E-01   0.00000000000000E+00   1.86512785696010E-17
     -9.86936406287169E-23  -1.34432235222559E-08  -1.34432235036047E-08  -2.88430439625758E-18
      1.32977190625000E-07
      0.00000000000000E+00  -1.34448755455982E-11   0.00000000000000E+00   3.47274703642996E-16   1.67960341580692E-22
      1.34449438492008E-08   1.34449441964757E-08  -7.79465536710706E-19  -2.55856705177176E-01  -2.55856705177176E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.22235712871620E-14   0.00000000000000E+00  -3.22235712871620E-14
      3.66372025594524E-18  -2.55839528768713E-01  -2.51603670226069E-01   0.00000000000000E+00  -1.95375024751427E-16
     -9.86924680409689E-23  -1.34449117775293E-08  -1.34449119729044E-08  -2.88425471923454E-18
      1.34977190625000E-07
      0.00000000000000E+00  -1.34467124403424E-11   0.00000000000000E+00   5.70598297088443E-17   1.67966971021678E-22
      1.34467598933798E-08   1.34467599504398E-08  -7.79448965317469E-19  -2.55865505050135E-01  -2.55865505050135E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99445005473783E-14   0.00000000000000E+00  -3.99445005473783E-14
      3.66364036694415E-18  -2.55829577956553E-01  -2.51593149679647E-01   0.00000000000000E+00   1.50439012223838E-16
     -9.86908857354712E-23  -1.34467201563782E-08  -1.34467200059393E-08  -2.88419140162668E-18
      1.36977190625000E-07
      0.00000000000000E+00  -1.34482738008749E-11   0.00000000000000E+00   4.84015634201712E-17   1.67967711259456E-22
      1.34481956847729E-08   1.34481957331746E-08  -7.79434613585514E-19  -2.55873438195918E-01  -2.55873438195918E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.03483557032628E-14   0.00000000000000E+00  -4.03483557032628E-14
      3.66355967023274E-18  -2.55817035923748E-01  -2.51580155408806E-01   0.00000000000000E+00   1.75202763708059E-16
     -9.86891104673407E-23  -1.34481555600216E-08  -1.34481553848189E-08  -2.88412505664723E-18
      1.38977190625000E-07
      0.00000000000000E+00  -1.34485493350865E-11   0.00000000000000E+00   1.42762895015941E-16   1.67958183847151E-22
      1.34485254096659E-08   1.34485255524290E-08  -7.79428622484137E-19  -2.55877363425075E-01  -2.55877363425075E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81597152973580E-14   0.00000000000000E+00  -2.81597152973580E-14
      3.66350335080215E-18  -2.55804083117842E-01  -2.51567094875704E-01   0.00000000000000E+00   5.05923256699550E-17
     -9.86875731000934E-23  -1.34484974433059E-08  -1.34484973927137E-08  -2.88407472831801E-18
      1.40977190625000E-07
      0.00000000000000E+00  -1.34468961298168E-11   0.00000000000000E+00   5.96801893668179E-17   1.67934208687665E-22
      1.34468657370196E-08   1.34468657966999E-08  -7.79438786387964E-19  -2.55873208215827E-01  -2.55873208215828E-01
      0.00000000000000E+00   0.00000000000000E+00   1.59184532208087E-15   0.00000000000000E+00   1.59184532208087E-15
      3.66350653449279E-18  -2.55794565004312E-01  -2.51558090283646E-01   0.00000000000000E+00   7.26098791194311E-18
     -9.86869317853249E-23  -1.34468673958062E-08  -1.34468673885453E-08  -2.88406774810483E-18
      1.42977190625000E-07
      0.00000000000000E+00  -1.34423038929564E-11   0.00000000000000E+00   1.23074195921450E-15   1.67893271854885E-22
      1.34423468862991E-08   1.34423481170412E-08  -7.79473228797575E-19  -2.55856613142876E-01  -2.55856613142876E-01
      0.00000000000000E+00   0.00000000000000E+00   5.17678618387380E-14   0.00000000000000E+00   5.17678618387380E-14
      3.66361007021647E-18  -2.55793935970659E-01  -2.51558869153552E-01   0.00000000000000E+00  -1.40579941450118E-15
     -9.86880216995114E-23  -1.34423984791036E-08  -1.34423998849031E-08  -2.88413684141890E-18
      1.44977190625000E-07
      0.00000000000000E+00  -1.34344052455566E-11   0.00000000000000E+00   4.70875000067661E-16   1.67836479804410E-22
      1.34344020881941E-08   1.34344025590693E-08  -7.79538046649415E-19  -2.55824118412007E-01  -2.55824118412007E-01
      0.00000000000000E+00   0.00000000000000E+00   1.20724871509312E-13   0.00000000000000E+00   1.20724871509312E-13
      3.66385151995949E-18  -2.55808645817861E-01  -2.51576060373843E-01   0.00000000000000E+00  -9.94494146136992E-16
     -9.86917121158684E-23  -1.34345222894466E-08  -1.34345232839408E-08  -2.88431347331007E-18
      1.46977190625000E-07
      0.00000000000000E+00  -1.34232001876172E-11   0.00000000000000E+00  -1.31028482384499E-16   1.67770789812431E-22
      1.34231585002148E-08   1.34231583691865E-08  -7.79633929719907E-19  -2.55774905848601E-01  -2.55774905848602E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99664266159620E-13   0.00000000000000E+00   1.99664266159620E-13
      3.66425084849181E-18  -2.55844783039931E-01  -2.51615715148306E-01   0.00000000000000E+00  -8.13330485439245E-16
     -9.86986564481953E-23  -1.34233572201221E-08  -1.34233580334527E-08  -2.88461691877190E-18
      1.48977190625000E-07
      0.00000000000000E+00  -1.34098827007222E-11   0.00000000000000E+00   5.61204744912759E-16   1.67710888946088E-22
      1.34098857988797E-08   1.34098863600846E-08  -7.79752126252344E-19  -2.55712921838600E-01  -2.55712921838600E-01
      0.00000000000000E+00   0.00000000000000E+00   2.70400761080165E-13   0.00000000000000E+00   2.70400761080165E-13
      3.66479165001397E-18  -2.55905877158221E-01  -2.51680968703869E-01   0.00000000000000E+00  -1.94764706703781E-15
     -9.87089211068236E-23  -1.34101548131986E-08  -1.34101567608457E-08  -2.88503952376163E-18
      1.50977190625000E-07
      0.00000000000000E+00  -1.33973918164619E-11   0.00000000000000E+00  -3.08825709091542E-16   1.67680003686921E-22
      1.33973920537560E-08   1.33973917449305E-08  -7.79870588713170E-19  -2.55648974535595E-01  -2.55648974535596E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04571309322654E-13   0.00000000000000E+00   3.04571309322654E-13
      3.66540079263261E-18  -2.55989976804298E-01  -2.51768993897174E-01   0.00000000000000E+00  -1.35256007536618E-15
     -9.87215721876904E-23  -1.33976949636796E-08  -1.33976963162398E-08  -2.88553020391944E-18
      1.51477190625000E-07
      0.00000000000000E+00  -1.33943609401341E-11   0.00000000000000E+00  -3.00641428474501E-16   1.67681208284002E-22
      1.33943681896149E-08   1.33943678889737E-08  -7.79899820238412E-19  -2.55633062799805E-01  -2.55633062799805E-01
      0.00000000000000E+00   0.00000000000000E+00   3.10336825780048E-13   0.00000000000000E+00   3.10336825780048E-13
      3.66555596104550E-18  -2.56012384322656E-01  -2.51792352306151E-01   0.00000000000000E+00  -1.42302097986021E-15
     -9.87243696654208E-23  -1.33946768027784E-08  -1.33946782257994E-08  -2.88565614080709E-18
      1.52152190625000E-07
      0.00000000000000E+00  -1.33905953059086E-11   0.00000000000000E+00  -2.76719795739923E-16   1.67671784288477E-22
      1.33906117754180E-08   1.33906114986984E-08  -7.79937398798465E-19  -2.55612309629706E-01  -2.55612309629707E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11763724660952E-13   0.00000000000000E+00   3.11763724660952E-13
      3.66576640155965E-18  -2.56044924122524E-01  -2.51826075164171E-01   0.00000000000000E+00  -1.50418215524118E-15
     -9.87297531610288E-23  -1.33909217582408E-08  -1.33909232624230E-08  -2.88582900276118E-18
      1.53063440625000E-07
      0.00000000000000E+00  -1.33865541374714E-11   0.00000000000000E+00  -1.39864471810928E-16   1.67690513167943E-22
      1.33865733764912E-08   1.33865732366269E-08  -7.79981062695961E-19  -2.55587450850767E-01  -2.55587450850767E-01
      0.00000000000000E+00   0.00000000000000E+00   2.98433340860307E-13   0.00000000000000E+00   2.98433340860307E-13
      3.66603834894151E-18  -2.56092074479139E-01  -2.51874502074756E-01   0.00000000000000E+00  -1.65155547488657E-15
     -9.87360665087945E-23  -1.33868700184122E-08  -1.33868716699677E-08  -2.88605728624555E-18
      1.54293628125000E-07
      0.00000000000000E+00  -1.33843498637785E-11   0.00000000000000E+00   7.67273092711609E-16   1.67737568120562E-22
      1.33843526320432E-08   1.33843533993165E-08  -7.80015692399211E-19  -2.55565487534889E-01  -2.55565487534890E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42636959008795E-13   0.00000000000000E+00   2.42636959008795E-13
      3.66633683789552E-18  -2.56157672690066E-01  -2.51940817552518E-01   0.00000000000000E+00  -2.39675226384691E-15
     -9.87560687331619E-23  -1.33845936395231E-08  -1.33845960362755E-08  -2.88632114549631E-18
      1.55954381250000E-07
      0.00000000000000E+00  -1.33913300638062E-11   0.00000000000000E+00   7.03493469542199E-16   1.67481642259667E-22
      1.33913013769665E-08   1.33913020804602E-08  -7.79982628115030E-19  -2.55575407781706E-01  -2.55575407781706E-01
      0.00000000000000E+00   0.00000000000000E+00   7.35666287069838E-14   0.00000000000000E+00   7.35666287069838E-14
      3.66645901390404E-18  -2.56233739325007E-01  -2.52014748199843E-01   0.00000000000000E+00  -1.66024786953353E-15
     -9.87702075565840E-23  -1.33913739868409E-08  -1.33913756470889E-08  -2.88647638578901E-18
      1.57954381250000E-07
      0.00000000000000E+00  -1.34215469823475E-11   0.00000000000000E+00   7.51259176712314E-16   1.68161257618595E-22
      1.34215801009080E-08   1.34215808521674E-08  -7.79758556827036E-19  -2.55681198965513E-01  -2.55681198965513E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.96479806211310E-13   0.00000000000000E+00  -2.96479806211310E-13
      3.66586605429162E-18  -2.56265284036670E-01  -2.52036869871158E-01   0.00000000000000E+00  -7.91325452366001E-18
     -9.87477657248069E-23  -1.34212843644478E-08  -1.34212843723612E-08  -2.88610749746458E-18
      1.59954381250000E-07
      0.00000000000000E+00  -1.34795928562627E-11   0.00000000000000E+00   1.44001899450515E-15   1.68605538798850E-22
      1.34795898005195E-08   1.34795912405387E-08  -7.79292687128307E-19  -2.55912815558295E-01  -2.55912815558294E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.31693920109233E-13   0.00000000000000E+00  -8.31693920109233E-13
      3.66420266645140E-18  -2.56184345995261E-01  -2.51937823853233E-01   0.00000000000000E+00   1.95018308332578E-15
     -9.87134202938689E-23  -1.34787614968016E-08  -1.34787595466186E-08  -2.88490997932309E-18
      1.61954381250000E-07
      0.00000000000000E+00  -1.35664779776610E-11   0.00000000000000E+00   6.96294561188970E-15   1.69046331904159E-22
      1.35664768855135E-08   1.35664838484593E-08  -7.78564294397554E-19  -2.56284492665129E-01  -2.56284492665127E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47753417922169E-12   0.00000000000000E+00  -1.47753417922169E-12
      3.66124759809295E-18  -2.55937228525089E-01  -2.51663535074073E-01   0.00000000000000E+00  -2.26486393008525E-16
     -9.86566638007997E-23  -1.35650060877936E-08  -1.35650063142801E-08  -2.88268330369540E-18
      1.63954381250000E-07
      0.00000000000000E+00  -1.36750384570403E-11   0.00000000000000E+00   4.01495200049651E-14   1.69564766382485E-22
      1.36749855020213E-08   1.36750256515414E-08  -7.77621359660298E-19  -2.56775991176508E-01  -2.56775991176506E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10647879981321E-12   0.00000000000000E+00  -2.10647879981321E-12
      3.65703464049333E-18  -2.55485193416081E-01  -2.51177511140208E-01   0.00000000000000E+00  -3.03949961394599E-14
     -9.85799457536093E-23  -1.36728887777454E-08  -1.36729191727416E-08  -2.87941328083303E-18
      1.65954381250000E-07
      0.00000000000000E+00  -1.37857113653753E-11   0.00000000000000E+00   4.38317529818881E-15   1.69965438577416E-22
      1.37857187963840E-08   1.37857231795595E-08  -7.76612747067610E-19  -2.57315244513510E-01  -2.57315244513508E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.50722148301226E-12   0.00000000000000E+00  -2.50722148301226E-12
      3.65202019752731E-18  -2.54827620062536E-01  -2.50485176157028E-01   0.00000000000000E+00   8.76548916486535E-15
     -9.84893179296076E-23  -1.37832247235655E-08  -1.37832159580764E-08  -2.87540745045969E-18
      1.67954381250000E-07
      0.00000000000000E+00  -1.38644223051622E-11   0.00000000000000E+00   3.08741449483330E-15   1.69884855120519E-22
      1.38643755779256E-08   1.38643786653403E-08  -7.75811524547712E-19  -2.57765025719593E-01  -2.57765025719591E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39232126289176E-12   0.00000000000000E+00  -2.39232126289176E-12
      3.64723555500152E-18  -2.54030090200384E-01  -2.49662828202120E-01   0.00000000000000E+00   9.71338113194209E-15
     -9.84261449948771E-23  -1.38619960574585E-08  -1.38619863440774E-08  -2.87142403045381E-18
      1.69954381250000E-07
      0.00000000000000E+00  -1.38624017209436E-11   0.00000000000000E+00   4.33190038724732E-14   1.68937508471588E-22
      1.38624281272511E-08   1.38624714462551E-08  -7.75617782608302E-19  -2.57919739361161E-01  -2.57919739361159E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43272778658529E-12   0.00000000000000E+00  -1.43272778658529E-12
      3.64437009942835E-18  -2.53250656334814E-01  -2.48883705288413E-01   0.00000000000000E+00  -3.30606332599702E-14
     -9.61459500966480E-23  -1.38610056578352E-08  -1.38610387184685E-08  -2.86875231682005E-18
      1.71954381250000E-07
      0.00000000000000E+00  -1.37233487888114E-11   0.00000000000000E+00   5.20755925160349E-13   1.67383689278517E-22
      1.37233346777554E-08   1.37238554336807E-08  -7.76525461832669E-19  -2.57520405629191E-01  -2.57520405629192E-01
      0.00000000000000E+00   0.00000000000000E+00   6.66648632719977E-13   0.00000000000000E+00   6.66648632719977E-13
      3.64570339669379E-18  -2.52753632856817E-01  -2.48429842862054E-01   0.00000000000000E+00  -5.23470900580935E-13
     -9.82751803362159E-23  -1.37239986114127E-08  -1.37245220823134E-08  -2.86917793486112E-18
      1.73954381250000E-07
      0.00000000000000E+00  -1.33972999717247E-11   0.00000000000000E+00   3.42922243419198E-13   1.64704277336685E-22
      1.33972363328646E-08   1.33975792551082E-08  -7.79042235696468E-19  -2.56294222410354E-01  -2.56294222410358E-01
      0.00000000000000E+00   0.00000000000000E+00   4.05127690132538E-12   0.00000000000000E+00   4.05127690132538E-12
      3.65380595049644E-18  -2.52894722612951E-01  -2.48672607168798E-01   0.00000000000000E+00  -3.60519540929059E-13
     -9.83511799817400E-23  -1.34012700124685E-08  -1.34016305320095E-08  -2.87476371479998E-18
      1.75954381250000E-07
      0.00000000000000E+00  -1.28632228248630E-11   0.00000000000000E+00  -1.32920728707015E-14   1.61025079700302E-22
      1.28632186913170E-08   1.28632053992442E-08  -7.83529508376877E-19  -2.54034360682946E-01  -2.54034360682954E-01
      0.00000000000000E+00   0.00000000000000E+00   8.54726702998863E-12   0.00000000000000E+00   8.54726702998863E-12
      3.67090048455642E-18  -2.54063407435591E-01  -2.50008124109023E-01   0.00000000000000E+00  -2.40539966688948E-14
     -9.86328032791145E-23  -1.28717286122775E-08  -1.28717526662742E-08  -2.88737097617954E-18
      1.77954381250000E-07
      0.00000000000000E+00  -1.21552835904673E-11   0.00000000000000E+00   5.40518185885557E-13   1.56635813365810E-22
      1.21553238229919E-08   1.21558643411780E-08  -7.89971424804383E-19  -2.50718655317500E-01  -2.50718655317514E-01
      0.00000000000000E+00   0.00000000000000E+00   1.34789321319418E-11   0.00000000000000E+00   1.34789321319418E-11
      3.69785834882030E-18  -2.56576218693015E-01  -2.52742411277807E-01   0.00000000000000E+00  -6.13567665818870E-13
     -9.91072426779846E-23  -1.21687297056440E-08  -1.21693432733099E-08  -2.90788692401592E-18
      1.79954381250000E-07
      0.00000000000000E+00  -1.13834204189753E-11   0.00000000000000E+00  -1.92449756495444E-14   1.52786394248732E-22
      1.13833563427032E-08   1.13833370977277E-08  -7.97675667329228E-19  -2.46666008748990E-01  -2.46666008749008E-01
      0.00000000000000E+00   0.00000000000000E+00   1.75294480799974E-11   0.00000000000000E+00   1.75294480799974E-11
      3.73291724498030E-18  -2.60531993194954E-01  -2.56940126946644E-01   0.00000000000000E+00  -7.21247570212123E-14
     -9.97755854460239E-23  -1.14007944210506E-08  -1.14008665458077E-08  -2.93524157765107E-18
      1.81954381250000E-07
      0.00000000000000E+00  -1.07323330769111E-11   0.00000000000000E+00  -1.62022020971216E-14   1.50811209544490E-22
      1.07323312744150E-08   1.07323150722130E-08  -8.04981661256798E-19  -2.42692953292629E-01  -2.42692953292648E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87518986913054E-11   0.00000000000000E+00   1.87518986913054E-11
      3.77042104236291E-18  -2.65671244807931E-01  -2.62284105769690E-01   0.00000000000000E+00  -9.07339366688385E-14
     -1.00550905818175E-22  -1.07509762369676E-08  -1.07510669709043E-08  -2.96543938110611E-18
      1.83954381250000E-07
      0.00000000000000E+00  -1.04503697336840E-11   0.00000000000000E+00  -7.03368648560299E-15   1.53102935533224E-22
      1.04503590422501E-08   1.04503520085638E-08  -8.09170497074435E-19  -2.40176180387524E-01  -2.40176180387539E-01
      0.00000000000000E+00   0.00000000000000E+00   1.48626857256038E-11   0.00000000000000E+00   1.48626857256038E-11
      3.80014641381411E-18  -2.71261582362237E-01  -2.67964507330810E-01   0.00000000000000E+00  -9.12506637958630E-14
     -1.01254389695570E-22  -1.04651234436255E-08  -1.04652146942894E-08  -2.99097591673968E-18
      1.85954381250000E-07
      0.00000000000000E+00  -1.08331785983650E-11   0.00000000000000E+00   9.55047760418932E-15   1.62270727649982E-22
      1.08331845518031E-08   1.08331941022809E-08  -8.06872005470313E-19  -2.40873663732014E-01  -2.40873663732018E-01
      0.00000000000000E+00   0.00000000000000E+00   3.89367959576012E-12   0.00000000000000E+00   3.89367959576012E-12
      3.80793377300564E-18  -2.76014367855734E-01  -2.72600137162877E-01   0.00000000000000E+00  -6.18399500896820E-14
     -1.01659681777063E-22  -1.08370259419265E-08  -1.08370877818767E-08  -3.00106176753532E-18
      1.87954381250000E-07
      0.00000000000000E+00  -1.22232486960009E-11   0.00000000000000E+00   3.45170314980812E-14   1.79239984307724E-22
      1.22232228004813E-08   1.22232573175130E-08  -7.95182608460416E-19  -2.46390084605603E-01  -2.46390084605589E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48208719769629E-11   0.00000000000000E+00  -1.48208719769629E-11
      3.77829202905171E-18  -2.78002870179259E-01  -2.74156592839128E-01   0.00000000000000E+00   2.77658603396778E-15
     -1.01473763344225E-22  -1.22084392221219E-08  -1.22084364455360E-08  -2.98310942059129E-18
      1.89954381250000E-07
      0.00000000000000E+00  -1.49880508201591E-11   0.00000000000000E+00   6.85668045852274E-14   2.01282918382725E-22
      1.49879949650694E-08   1.49880635318742E-08  -7.73128187737008E-19  -2.57421349248635E-01  -2.57421349248595E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.96077746759996E-11   0.00000000000000E+00  -3.96077746759996E-11
      3.69907647969971E-18  -2.74621238929520E-01  -2.69911702642035E-01   0.00000000000000E+00   9.54226882050469E-14
     -1.00388755972489E-22  -1.49485511798863E-08  -1.49484557571982E-08  -2.92594829196270E-18
      1.91954381250000E-07
      0.00000000000000E+00  -1.94037620956226E-11   0.00000000000000E+00   1.07591333988047E-13   2.21094862433914E-22
      1.94036252572676E-08   1.94037328486018E-08  -7.42324531463179E-19  -2.73297992320368E-01  -2.73297992320302E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62909785461197E-11   0.00000000000000E+00  -6.62909785461197E-11
      3.56649452260747E-18  -2.62768508589115E-01  -2.56676180301578E-01   0.00000000000000E+00   2.00600607020295E-13
     -9.82030986595664E-23  -1.93376424706626E-08  -1.93374418700557E-08  -2.82416999114429E-18
      1.93954381250000E-07
      0.00000000000000E+00  -2.54386042433175E-11   0.00000000000000E+00   1.50452742054514E-13   2.29441172158680E-22
      2.54384604557957E-08   2.54386109085380E-08  -7.06022981200004E-19  -2.92334960640894E-01  -2.92334960640803E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.02712915399903E-11   0.00000000000000E+00  -9.02712915399903E-11
      3.38595193952749E-18  -2.39450809440968E-01  -2.31464663561964E-01   0.00000000000000E+00   2.87510335148782E-13
     -9.46168106971267E-23  -2.53486271273330E-08  -2.53483396169980E-08  -2.67992895832749E-18
      1.95954381250000E-07
      0.00000000000000E+00  -3.25058730819623E-11   0.00000000000000E+00   1.75322118252729E-13   2.17470272483525E-22
      3.25056985285244E-08   3.25058738506429E-08  -6.67587937845521E-19  -3.12669607712491E-01  -3.12669607712381E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09718567994274E-10   0.00000000000000E+00  -1.09718567994274E-10
      3.16651480353894E-18  -2.02859537953854E-01  -1.92652838141182E-01   0.00000000000000E+00   3.32238389150454E-13
     -8.96955395065144E-23  -3.23964875210377E-08  -3.23961552826486E-08  -2.49892686569342E-18
      1.97954381250000E-07
      0.00000000000000E+00  -3.92954034352915E-11   0.00000000000000E+00   1.64803731171245E-13   1.78174795651751E-22
      3.92952272268235E-08   3.92953920305548E-08  -6.30071451814062E-19  -3.32648305004988E-01  -3.32648305004864E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24006966305982E-10   0.00000000000000E+00  -1.24006966305982E-10
      2.91850087092698E-18  -1.53764028553463E-01  -1.41422616897788E-01   0.00000000000000E+00   3.21988759102944E-13
     -8.42306104514981E-23  -3.91717070530078E-08  -3.91713850642488E-08  -2.28842941911292E-18
      1.99954381250000E-07
      0.00000000000000E+00  -4.31492086085193E-11   0.00000000000000E+00   9.58925978303386E-14   1.16546570619969E-22
      4.31490876310588E-08   4.31491835236567E-08  -5.97081010136248E-19  -3.50442107126593E-01  -3.50442107126465E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27836043000433E-10   0.00000000000000E+00  -1.27836043000433E-10
      2.66282878492611E-18  -9.81007319320037E-02  -8.45462403568108E-02   0.00000000000000E+00   2.98804375119712E-13
     -7.50423298302702E-23  -4.30216462850313E-08  -4.30213474806562E-08  -2.06574777478986E-18
      2.01954381250000E-07
      0.00000000000000E+00  -3.78957814849860E-11   0.00000000000000E+00  -1.29796258126860E-13   5.62586950230526E-23
      3.78959245194166E-08   3.78957947231585E-08  -5.72405136007381E-19  -3.63512737272636E-01  -3.63512737272532E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04099959845855E-10   0.00000000000000E+00  -1.04099959845855E-10
      2.45462886523440E-18  -5.37253428738088E-02  -4.18184715849774E-02   0.00000000000000E+00   3.58593397712445E-13
     -4.83792103448017E-23  -3.77920533567103E-08  -3.77916947633127E-08  -1.88222372922702E-18
      2.03954381250000E-07
      0.00000000000000E+00  -2.69986789495246E-11   0.00000000000000E+00  -2.69264341227301E-13   2.73553956149580E-23
      2.69989408733700E-08   2.69986716090288E-08  -5.61559840785118E-19  -3.68858673223027E-01  -3.68858673222978E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.89275765492268E-11   0.00000000000000E+00  -4.89275765492268E-11
      2.35677371213595E-18  -3.13831330736452E-02  -2.28921742626682E-02   0.00000000000000E+00   3.52286956312797E-13
     -2.95124580639790E-23  -2.69500963194358E-08  -2.69497440324795E-08  -1.79521387135083E-18
      2.05954381250000E-07
      0.00000000000000E+00  -1.97471695680415E-11   0.00000000000000E+00  -1.71939622627408E-13   1.79306307283281E-23
      1.97472715031724E-08   1.97470995635498E-08  -5.74416155094537E-19  -3.63618407370905E-01  -3.63618407370912E-01
      0.00000000000000E+00   0.00000000000000E+00   7.53163455509311E-12   0.00000000000000E+00   7.53163455509311E-12
      2.37183698124614E-18  -2.35195071478756E-02  -1.72954884401121E-02   0.00000000000000E+00   1.73462335118701E-13
     -2.54100682966512E-23  -1.97548046604400E-08  -1.97546311981049E-08  -1.79742082615160E-18
      2.07954381250000E-07
      0.00000000000000E+00  -1.55255262222975E-11   0.00000000000000E+00  -1.04449095402911E-13   1.62412123126812E-23
      1.55255908738682E-08   1.55254864247728E-08  -6.18350073627091E-19  -3.44934630853055E-01  -3.44934630853118E-01
      0.00000000000000E+00   0.00000000000000E+00   6.35838769920874E-11   0.00000000000000E+00   6.35838769920874E-11
      2.49900473523031E-18  -2.39338053962195E-02  -1.90222195456326E-02   0.00000000000000E+00   3.82859318799525E-14
     -3.20526851363610E-23  -1.55891085876968E-08  -1.55890703017649E-08  -1.88065466160322E-18
      2.09954381250000E-07
      0.00000000000000E+00  -1.10665560756093E-11   0.00000000000000E+00  -1.11141064093980E-13   1.61999255411556E-23
      1.10666596590596E-08   1.10665485179955E-08  -6.96767476916334E-19  -3.09731407265250E-01  -3.09731407265379E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28458457687994E-10   0.00000000000000E+00   1.28458457687994E-10
      2.75592165060630E-18  -3.29120400296233E-02  -2.93848863473408E-02   0.00000000000000E+00  -5.72796635153432E-14
     -5.28321957700431E-23  -1.11949496960199E-08  -1.11950069756835E-08  -2.05915417368997E-18
      2.11954381250000E-07
      0.00000000000000E+00  -4.97816844612236E-12   0.00000000000000E+00  -1.52228401294550E-13   3.12936992312444E-24
      4.97827714005068E-09   4.97812491164939E-09  -8.09160731421095E-19  -2.55506765685788E-01  -2.55506765685990E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01960530888857E-10   0.00000000000000E+00   2.01960530888857E-10
      3.15984271238401E-18  -5.34513138412230E-02  -5.18192619669094E-02   0.00000000000000E+00  -1.99530491833582E-13
     -7.78638674728488E-23  -5.17988591204634E-09  -5.18008544253825E-09  -2.35068198096292E-18
      2.13954381250000E-07
      0.00000000000000E+00  -1.09625878330904E-12   0.00000000000000E+00  -9.68142345638851E-15  -2.69673220787842E-23
      1.09628898254984E-09   1.09627930112636E-09  -9.55551312920387E-19  -1.82906374152572E-01  -1.82906374152825E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52336231237132E-10   0.00000000000000E+00   2.52336231237132E-10
      3.66451517485828E-18  -8.10547663010223E-02  -8.06299004174866E-02   0.00000000000000E+00  -6.28306460699575E-13
     -8.84873402131630E-23  -1.34798722590270E-09  -1.34861553236349E-09  -2.70896386193789E-18
      2.15954381250000E-07
      0.00000000000000E+00  -6.63119002638343E-14   0.00000000000000E+00  -3.03286951120089E-14  -4.29876001409902E-23
      6.63343805446020E-11   6.63040518494469E-11  -1.12500770096324E-18  -9.98214044309989E-02  -9.98214044312561E-02
      0.00000000000000E+00   0.00000000000000E+00   2.57185805486870E-10   0.00000000000000E+00   2.57185805486870E-10
      4.17888678583202E-18  -1.10098437721686E-01  -1.09996519875899E-01   0.00000000000000E+00  -1.02398367237333E-12
     -9.80669564024891E-23  -3.22465873663844E-10  -3.23489857336316E-10  -3.05387908486877E-18
      2.17954381250000E-07
      0.00000000000000E+00   3.19619685482193E-14   0.00000000000000E+00  -6.60794034493068E-15  -4.56793013376923E-23
     -3.19341965672908E-11  -3.19408045076814E-11  -1.24193843162913E-18  -4.24177099161936E-02  -4.24177099163802E-02
      0.00000000000000E+00   0.00000000000000E+00   1.86622742839038E-10   0.00000000000000E+00   1.86622742839038E-10
      4.55213227151009E-18  -1.38878265829295E-01  -1.38829532187256E-01   0.00000000000000E+00  -1.06054169961675E-12
     -1.05634753194963E-22  -1.53621396631635E-10  -1.54681938331357E-10  -3.31019383988096E-18
      2.19954381250000E-07
      0.00000000000000E+00   5.78621844407419E-15   0.00000000000000E+00  -6.32453257088051E-16  -4.59687202773328E-23
     -5.81275925615186E-12  -5.81339170945491E-12  -1.29038979594113E-18  -1.98667498196729E-02  -1.98667498197812E-02
      0.00000000000000E+00   0.00000000000000E+00   1.08307765837129E-10   0.00000000000000E+00   1.08307765837129E-10
      4.76874780318435E-18  -1.67166896133798E-01  -1.67134604888320E-01   0.00000000000000E+00  -6.85424244910287E-13
     -1.09686300970051E-22  -1.01808949882654E-10  -1.02494374127674E-10  -3.47835800724322E-18
      2.21954381250000E-07
      0.00000000000000E+00  -1.66238974345623E-14   0.00000000000000E+00   5.77898244489086E-16  -4.54588564512881E-23
      1.66043565098399E-11   1.66049344080389E-11  -1.30742663547617E-18  -1.24864398220199E-02  -1.24864398220889E-02
      0.00000000000000E+00   0.00000000000000E+00   6.89392208718159E-11   0.00000000000000E+00   6.89392208718159E-11
      4.90662624492798E-18  -1.94902688655239E-01  -1.94875737945669E-01   0.00000000000000E+00  -4.94185524122827E-13
     -1.12398463550433E-22  -8.50499697556202E-11  -8.55441552798554E-11  -3.59919960945181E-18
      2.23954381250000E-07
      0.00000000000000E+00  -3.19619685482193E-14   0.00000000000000E+00   6.84773004384243E-16  -4.40392097387868E-23
      3.19559488523750E-11   3.19566336253354E-11  -1.31249267249345E-18  -1.00005963709156E-02  -1.00005963709661E-02
      0.00000000000000E+00   0.00000000000000E+00   5.05058056091237E-11   0.00000000000000E+00   5.05058056091237E-11
      5.00763785614623E-18  -2.22071374244682E-01  -2.22045394673328E-01   0.00000000000000E+00  -4.49396509695158E-13
     -1.14770935307567E-22  -8.20130427246487E-11  -8.24624392344587E-11  -3.69514518365278E-18
      2.25954381250000E-07
      0.00000000000000E+00  -4.38099396479903E-14   0.00000000000000E+00   5.79892256194233E-16  -4.12275554904161E-23
      4.37703592482737E-11   4.37709391404887E-11  -1.31290085998101E-18  -8.99276914174235E-03  -8.99276914178306E-03
      0.00000000000000E+00   0.00000000000000E+00   4.07100019963339E-11   0.00000000000000E+00   4.07100019963339E-11
      5.08905786013890E-18  -2.48678950398178E-01  -2.48652335132136E-01   0.00000000000000E+00  -4.53514185607608E-13
     -1.17095655757587E-22  -8.40274269510977E-11  -8.44809411368224E-11  -3.77615700015789E-18
      2.27954381250000E-07
      0.00000000000000E+00  -5.37291712664031E-14   0.00000000000000E+00   4.70289784553659E-16  -3.64333099220499E-23
      5.37464296208547E-11   5.37468999106028E-11  -1.31138324630294E-18  -8.46834987328861E-03  -8.46834987332332E-03
      0.00000000000000E+00   0.00000000000000E+00   3.47083948970731E-11   0.00000000000000E+00   3.47083948970731E-11
      5.15847464993304E-18  -2.74737267187367E-01  -2.74709400064904E-01   0.00000000000000E+00  -4.68975038756745E-13
     -1.19436854334342E-22  -8.79863197687998E-11  -8.84552948076760E-11  -3.84709140363010E-18
      2.29954381250000E-07
      0.00000000000000E+00  -6.26381107755332E-14   0.00000000000000E+00   3.89647850823300E-16  -2.90687860236600E-23
      6.26230127400004E-11   6.26234023878222E-11  -1.30906671494345E-18  -8.13771525175904E-03  -8.13771525178969E-03
      0.00000000000000E+00   0.00000000000000E+00   3.06533699973763E-11   0.00000000000000E+00   3.06533699973763E-11
      5.21978138992779E-18  -3.00258125133386E-01  -3.00228739305341E-01   0.00000000000000E+00  -4.86350815541642E-13
     -1.21804823483567E-22  -9.27904215695352E-11  -9.32767723851987E-11  -3.91071467498435E-18
      2.31954381250000E-07
      0.00000000000000E+00  -7.08122923870031E-14   0.00000000000000E+00   3.35190530462056E-16  -1.86860236193494E-23
      7.07917978957162E-11   7.07921330862280E-11  -1.30646395812177E-18  -7.90574106280886E-03  -7.90574106283659E-03
      0.00000000000000E+00   0.00000000000000E+00   2.77303097799839E-11   0.00000000000000E+00   2.77303097799839E-11
      5.27524200948776E-18  -3.25251192798739E-01  -3.25220154660785E-01   0.00000000000000E+00  -5.04531068428220E-13
     -1.24202662901246E-22  -9.80179117976592E-11  -9.85224428662116E-11  -3.96877805136599E-18
      2.33954381250000E-07
      0.00000000000000E+00  -7.85272503124354E-14   0.00000000000000E+00   2.99242626314398E-16  -5.17086589282607E-24
      7.84963921855345E-11   7.84966914281556E-11  -1.30381706839636E-18  -7.73450076936493E-03  -7.73450076939043E-03
      0.00000000000000E+00   0.00000000000000E+00   2.55006077376283E-11   0.00000000000000E+00   2.55006077376283E-11
      5.32624322496302E-18  -3.49714890749338E-01  -3.49682128134500E-01   0.00000000000000E+00  -5.23984707588002E-13
     -1.26634480323297E-22  -1.03473314458069E-10  -1.03997299165784E-10  -4.02242615656667E-18
      2.35954381250000E-07
      0.00000000000000E+00  -8.58748292890375E-14   0.00000000000000E+00   2.75271337413457E-16   1.08358283759333E-23
      8.58905538357116E-11   8.58908291070598E-11  -1.30123732315871E-18  -7.60555788518115E-03  -7.60555788520485E-03
      0.00000000000000E+00   0.00000000000000E+00   2.37033554005182E-11   0.00000000000000E+00   2.37033554005182E-11
      5.37364993576406E-18  -3.73640013538788E-01  -3.73605488041287E-01   0.00000000000000E+00  -5.45351962740142E-13
     -1.29105935551933E-22  -1.09048832544709E-10  -1.09594184507578E-10  -4.07241261260534E-18
      2.37954381250000E-07
      0.00000000000000E+00  -9.31305635284321E-14   0.00000000000000E+00   2.59876921125339E-16   2.77657654930397E-23
      9.30992905009835E-11   9.30995503779324E-11  -1.29876249784104E-18  -7.50920310186197E-03  -7.50920310188422E-03
      0.00000000000000E+00   0.00000000000000E+00   2.22523469156742E-11   0.00000000000000E+00   2.22523469156742E-11
      5.41815462959540E-18  -3.97116465630140E-01  -3.97080126623694E-01   0.00000000000000E+00  -5.72350359018808E-13
     -1.31637074305666E-22  -1.14779546934455E-10  -1.15351897293606E-10  -4.11939213175436E-18
      2.39954381250000E-07
      0.00000000000000E+00  -1.00202608293412E-13   0.00000000000000E+00   2.50340092520439E-16   4.46443441533664E-23
      1.00213493032440E-10   1.00213743372577E-10  -1.29639542809185E-18  -7.44113849127641E-03  -7.44113849129744E-03
      0.00000000000000E+00   0.00000000000000E+00   2.10385539128257E-11   0.00000000000000E+00   2.10385539128257E-11
      5.46023173742106E-18  -4.20227293661315E-01  -4.20189096241004E-01   0.00000000000000E+00  -6.05509099459924E-13
     -1.34246153789448E-22  -1.20646788185809E-10  -1.21252297285403E-10  -4.16383630932921E-18
      2.41954381250000E-07
      0.00000000000000E+00  -1.07274653058391E-13   0.00000000000000E+00   2.44571934952982E-16   6.06084424415705E-23
      1.07282315533374E-10   1.07282560105369E-10  -1.29412008302360E-18  -7.40561741972297E-03  -7.40561741974285E-03
      0.00000000000000E+00   0.00000000000000E+00   1.98828078482866E-11   0.00000000000000E+00   1.98828078482866E-11
      5.49999735311763E-18  -4.42911940909673E-01  -4.42871881138517E-01   0.00000000000000E+00  -6.39914747004695E-13
     -1.36925994490860E-22  -1.26525453206515E-10  -1.27165367953656E-10  -4.20587727009403E-18
      2.43954381250000E-07
      0.00000000000000E+00  -1.14346697823371E-13   0.00000000000000E+00   2.39813301430056E-16   7.49862660280138E-23
      1.14306134889554E-10   1.14306374702931E-10  -1.29193253230451E-18  -7.39836914219313E-03  -7.39836914221192E-03
      0.00000000000000E+00   0.00000000000000E+00   1.87900360142416E-11   0.00000000000000E+00   1.87900360142416E-11
      5.53757742514611E-18  -4.65145254019537E-01  -4.65103326293505E-01   0.00000000000000E+00  -6.76614820741152E-13
     -1.39670674127307E-22  -1.32419795896291E-10  -1.33096410717172E-10  -4.24564489284161E-18
      2.45954381250000E-07
      0.00000000000000E+00  -1.21418742588350E-13   0.00000000000000E+00   2.40459815433774E-16   8.74762902683410E-23
      1.21392353264932E-10   1.21392593724834E-10  -1.28977824663662E-18  -7.43846747739221E-03  -7.43846747740993E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77206968843153E-11   0.00000000000000E+00   1.77206968843153E-11
      5.57301881891475E-18  -4.86927202700122E-01  -4.86883380041693E-01   0.00000000000000E+00  -7.14794793460750E-13
     -1.42467909833589E-22  -1.38398495815546E-10  -1.39113290609150E-10  -4.28324057227812E-18
      2.47954381250000E-07
      0.00000000000000E+00  -1.28674476827745E-13   0.00000000000000E+00   2.47466616395962E-16   9.80857722530057E-23
      1.28673868932981E-10   1.28674116399696E-10  -1.28758260670525E-18  -7.55286720030032E-03  -7.55286720031698E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66590908983301E-11   0.00000000000000E+00   1.66590908983301E-11
      5.60633700071140E-18  -5.08264911966706E-01  -5.08219130484737E-01   0.00000000000000E+00  -7.53154667222295E-13
     -1.45298721191063E-22  -1.44580052630659E-10  -1.45333207298027E-10  -4.31875439400616E-18
      2.49954381250000E-07
      0.00000000000000E+00  -1.36573124227592E-13   0.00000000000000E+00   2.73810438237598E-16   1.07208254733731E-22
      1.36595077376773E-10   1.36595351187318E-10  -1.28513905717862E-18  -7.82901965807902E-03  -7.82901965809452E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54982572640293E-11   0.00000000000000E+00   1.54982572640293E-11
      5.63733351523946E-18  -5.29166661525038E-01  -5.29118751038708E-01   0.00000000000000E+00  -7.87523589060106E-13
     -1.48130032741153E-22  -1.51306084862138E-10  -1.52093608451346E-10  -4.35219445806084E-18
      2.51954381250000E-07
      0.00000000000000E+00  -1.47043424269250E-13   0.00000000000000E+00   3.87803432690903E-16   1.16195718950162E-22
      1.47053465870581E-10   1.47053853674130E-10  -1.28163726852483E-18  -8.63042923395374E-03  -8.63042923396748E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37423406928019E-11   0.00000000000000E+00   1.37423406928019E-11
      5.66481819662506E-18  -5.49638283945818E-01  -5.49587632758684E-01   0.00000000000000E+00  -8.02973308146058E-13
     -1.50883988873444E-22  -1.59993221058635E-10  -1.60796194366932E-10  -4.38318092810023E-18
      2.53954381250000E-07
      0.00000000000000E+00  -1.73311019110603E-13   0.00000000000000E+00   1.02765290352797E-15   1.32844797302438E-22
      1.73383157575834E-10   1.73384185228870E-10  -1.27196699556805E-18  -1.22838339596403E-02  -1.22838339596481E-02
      0.00000000000000E+00   0.00000000000000E+00   7.83661490067638E-12   0.00000000000000E+00   7.83661490067638E-12
      5.68049142642642E-18  -5.69666540367213E-01  -5.69609456247832E-01   0.00000000000000E+00  -7.00617446209238E-13
     -1.53181869272412E-22  -1.80520182683184E-10  -1.81220800129547E-10  -4.40852443085836E-18
      2.55954381250000E-07
      0.00000000000000E+00  -3.21823959175174E-13   0.00000000000000E+00   5.35194870573240E-15   2.03014232293748E-22
      3.21834300318528E-10   3.21839652267437E-10  -1.22743598241319E-18  -3.14412220133177E-02  -3.14412220132958E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.18922222080910E-11   0.00000000000000E+00  -2.18922222080910E-11
      5.63670698201024E-18  -5.89070440326388E-01  -5.88975959026522E-01   0.00000000000000E+00   3.06673721199666E-14
     -1.53080727244137E-22  -2.99978097431312E-10  -2.99947430059345E-10  -4.40927099959704E-18
      2.57954381250000E-07
      0.00000000000000E+00  -7.08031079132824E-13   0.00000000000000E+00   1.16741817560680E-14   2.92653724827923E-22
      7.08060620902857E-10   7.08072295084905E-10  -1.15608067000721E-18  -6.06682881869049E-02  -6.06682881868580E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.69482469055626E-11   0.00000000000000E+00  -4.69482469055626E-11
      5.54281048819911E-18  -6.07393015711494E-01  -6.07184765319699E-01   0.00000000000000E+00   4.73923960651281E-13
     -1.51525473548157E-22  -6.61597972139842E-10  -6.61124048179343E-10  -4.38672981819191E-18
      2.59954381250000E-07
      0.00000000000000E+00  -1.46933210584601E-12   0.00000000000000E+00   2.06021216311557E-14   3.48819332497465E-22
      1.46928313751543E-09   1.46930373963741E-09  -1.08188976918431E-18  -9.03222832403034E-02  -9.03222832402461E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.73224516196936E-11   0.00000000000000E+00  -5.73224516196936E-11
      5.42816558495972E-18  -6.23901000643230E-01  -6.23456230655200E-01   0.00000000000000E+00   4.34192558117013E-13
     -1.50043408696591E-22  -1.41241548057568E-09  -1.41198128801771E-09  -4.34627581577541E-18
      2.61954381250000E-07
      0.00000000000000E+00  -2.85958589295635E-12   0.00000000000000E+00   3.58409589264919E-14   3.87662619914126E-22
      2.85954765314734E-09   2.85958349410665E-09  -1.01208790434057E-18  -1.19557727755479E-01  -1.19557727755411E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.80692853463748E-11   0.00000000000000E+00  -6.80692853463748E-11
      5.29202701426697E-18  -6.37412095243096E-01  -6.36532770691902E-01   0.00000000000000E+00   3.50575010374147E-13
     -1.48786184136960E-22  -2.79186478377050E-09  -2.79151420876028E-09  -4.27993910992641E-18
      2.63954381250000E-07
      0.00000000000000E+00  -5.15193868891901E-12   0.00000000000000E+00   5.78770477180666E-14   4.18822523589000E-22
      5.15187216488428E-09   5.15193004193242E-09  -9.49438404987696E-19  -1.48254965494617E-01  -1.48254965494535E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.17362672188429E-11   0.00000000000000E+00  -8.17362672188429E-11
      5.12855447982929E-18  -6.46242836689895E-01  -6.44645721818808E-01   0.00000000000000E+00   2.63470037318701E-13
     -1.47774340131399E-22  -5.07045724475075E-09  -5.07019377471358E-09  -4.17911607484159E-18
      2.65954381250000E-07
      0.00000000000000E+00  -8.56167455774844E-12   0.00000000000000E+00   8.52689239204225E-14   4.41292566156519E-22
      8.56162565762260E-09   8.56171092654696E-09  -8.93645796132658E-19  -1.76375070204130E-01  -1.76375070204032E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.75661017196567E-11   0.00000000000000E+00  -9.75661017196567E-11
      4.93342227638998E-18  -6.48323427863211E-01  -6.45657202410513E-01   0.00000000000000E+00   2.32224660082258E-13
     -1.46816208450392E-22  -8.46437704948724E-09  -8.46414482482730E-09  -4.03977648025732E-18
      2.67954381250000E-07
      0.00000000000000E+00  -1.32490625658718E-11   0.00000000000000E+00   1.16673343000799E-13   4.52393833798747E-22
      1.32489406726643E-08   1.32490573460078E-08  -8.42874612381095E-19  -2.03914556675578E-01  -2.03914556675466E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12891370233083E-10   0.00000000000000E+00  -1.12891370233083E-10
      4.70763953592381E-18  -6.41307688394242E-01  -6.37169734734458E-01   0.00000000000000E+00   3.55120068504124E-13
     -1.45345886855433E-22  -1.31365210958431E-08  -1.31361659757747E-08  -3.86476492354271E-18
      2.69954381250000E-07
      0.00000000000000E+00  -1.94118444324968E-11   0.00000000000000E+00   1.53051275587653E-13   4.51187367260792E-22
      1.94117231692068E-08   1.94118762204828E-08  -7.95126895449899E-19  -2.30884456109920E-01  -2.30884456109795E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25392505573734E-10   0.00000000000000E+00  -1.25392505573734E-10
      4.45685452477634E-18  -6.22504132148669E-01  -6.16428718464329E-01   0.00000000000000E+00   7.05024964161159E-13
     -1.42445479336342E-22  -1.92871887398731E-08  -1.92864837149091E-08  -3.66172762932644E-18
      2.71954381250000E-07
      0.00000000000000E+00  -2.73386881666668E-11   0.00000000000000E+00   1.96686136227352E-13   4.37965067002298E-22
      2.73384839944899E-08   2.73386806806266E-08  -7.48876755066970E-19  -2.57299442070403E-01  -2.57299442070269E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34737718511806E-10   0.00000000000000E+00  -1.34737718511806E-10
      4.18737908775273E-18  -5.88707160437551E-01  -5.80137482827550E-01   0.00000000000000E+00   1.24265720705982E-12
     -1.37099728949683E-22  -2.72051856193217E-08  -2.72039429621148E-08  -3.43850233268576E-18
      2.73954381249999E-07
      0.00000000000000E+00  -3.72821667957025E-11   0.00000000000000E+00   2.46732599181771E-13   4.11222716914058E-22
      3.72818744273437E-08   3.72821211599433E-08  -7.03240723903449E-19  -2.83171369737020E-01  -2.83171369736877E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42846678904176E-10   0.00000000000000E+00  -1.42846678904176E-10
      3.90168572994437E-18  -5.36270191413469E-01  -5.24570348862692E-01   0.00000000000000E+00   1.76131765822498E-12
     -1.28766608072719E-22  -3.71410357986973E-08  -3.71392744810392E-08  -3.19844500604093E-18
      2.75954381249999E-07
      0.00000000000000E+00  -4.90605195846702E-11   0.00000000000000E+00   2.92532714286444E-13   3.61448705454991E-22
      4.90602256028184E-08   4.90605181355330E-08  -6.57997993901641E-19  -3.08506089851909E-01  -3.08506089851756E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52974320043697E-10   0.00000000000000E+00  -1.52974320043697E-10
      3.59573708985698E-18  -4.61934669791389E-01  -4.46526949502766E-01   0.00000000000000E+00   1.96657831391956E-12
     -1.18288487982222E-22  -4.89095103938031E-08  -4.89075438154893E-08  -2.93773909595534E-18
      2.77954381249999E-07
      0.00000000000000E+00  -6.17507987693713E-11   0.00000000000000E+00   3.15686077459255E-13   2.87634211577534E-22
      6.17505198583113E-08   6.17508355443890E-08  -6.13193161501260E-19  -3.33309667226409E-01  -3.33309667226244E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.65120632766430E-10   0.00000000000000E+00  -1.65120632766430E-10
      3.26549582432412E-18  -3.64243998515472E-01  -3.44841487050896E-01   0.00000000000000E+00   1.84406952162658E-12
     -1.06716755085119E-22  -6.15875589811442E-08  -6.15857149116227E-08  -2.65230266282286E-18
      2.79954381249999E-07
      0.00000000000000E+00  -7.29414370849480E-11   0.00000000000000E+00   2.78956087564265E-13   2.25681808375723E-22
      7.29411535189734E-08   7.29414324750611E-08  -5.68971946327050E-19  -3.57587480617893E-01  -3.57587480617713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79675920617740E-10   0.00000000000000E+00  -1.79675920617740E-10
      2.90614398308864E-18  -2.46588427124660E-01  -2.23664205408847E-01   0.00000000000000E+00   1.47304234477130E-12
     -9.28041550523231E-23  -7.27632295967881E-08  -7.27617565544434E-08  -2.33717203676159E-18
      2.81954381249999E-07
      0.00000000000000E+00  -7.68447465715307E-11   0.00000000000000E+00   9.77254575357677E-14   1.27282506869077E-22
      7.68445922690651E-08   7.68446899945228E-08  -5.25995815492273E-19  -3.81327485366220E-01  -3.81327485366014E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05528722911364E-10   0.00000000000000E+00  -2.05528722911364E-10
      2.49508653726591E-18  -1.23580432069146E-01  -9.94341441218183E-02   0.00000000000000E+00   8.88931021275084E-13
     -7.83118703042626E-23  -7.66400502026326E-08  -7.66391612716113E-08  -1.96909072177364E-18
      2.83954381249999E-07
      0.00000000000000E+00  -5.46046353014653E-11   0.00000000000000E+00  -5.52628442961668E-13   3.65919224522155E-23
      5.46052309932933E-08   5.46046783648503E-08  -4.76275969324638E-19  -4.04638302487407E-01  -4.04638302487226E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81179583541539E-10   0.00000000000000E+00  -1.81179583541539E-10
      2.13272737018283E-18  -4.62949530688659E-02  -2.91479079878201E-02   0.00000000000000E+00   9.02439926039373E-13
     -3.35277222649233E-23  -5.44244012212348E-08  -5.44234987813088E-08  -1.65645140085820E-18
      2.85954381249999E-07
      0.00000000000000E+00  -2.93407197483165E-11   0.00000000000000E+00  -6.25319538553894E-13   1.18361616765515E-23
      2.93413340869944E-08   2.93407087674558E-08  -4.18572668670812E-19  -4.27597753879906E-01  -4.27597753879785E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21311694363794E-10   0.00000000000000E+00  -1.21311694363794E-10
      1.89010398145525E-18  -1.97217334110857E-02  -1.05156454279597E-02   0.00000000000000E+00   7.29702326560019E-13
     -1.24273776252158E-23  -2.92201267754186E-08  -2.92193970730920E-08  -1.47153131278443E-18
      2.86454381249999E-07
      0.00000000000000E+00  -2.41787699830419E-11   0.00000000000000E+00  -5.09796792102286E-13   8.75575736207544E-24
      2.41793133698419E-08   2.41788035730498E-08  -4.04029353169875E-19  -4.33313467265998E-01  -4.33313467265887E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11000373868981E-10   0.00000000000000E+00  -1.11000373868981E-10
      1.83460379452076E-18  -1.56629643335665E-02  -8.07997405178843E-03   0.00000000000000E+00   5.79621227400140E-13
     -9.82613758412560E-24  -2.40683828204082E-08  -2.40678031991808E-08  -1.43057444135088E-18
      2.87129381249999E-07
      0.00000000000000E+00  -2.04302188786539E-11   0.00000000000000E+00  -2.73873637757318E-13   6.74147539593446E-24
      2.04304294462116E-08   2.04301555725738E-08  -3.84807969629174E-19  -4.40981718301380E-01  -4.40981718301277E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03358694659664E-10   0.00000000000000E+00  -1.03358694659664E-10
      1.76483667562548E-18  -1.27156304694156E-02  -6.31130805929427E-03   0.00000000000000E+00   3.30284768850765E-13
     -7.64218809023895E-24  -2.03271271626830E-08  -2.03267968779141E-08  -1.38002870599631E-18
      2.88040631249999E-07
      0.00000000000000E+00  -1.81499895880026E-11   0.00000000000000E+00  -1.23124921477749E-13   5.41513359757799E-24
      1.81501269807506E-08   1.81500038558291E-08  -3.59475944499265E-19  -4.51241254585125E-01  -4.51241254585025E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96784575841335E-11   0.00000000000000E+00  -9.96784575841335E-11
      1.67400468115194E-18  -1.08142333986143E-02  -5.12715142923879E-03   0.00000000000000E+00   1.70717180174312E-13
     -6.12615121527279E-24  -1.80504961154251E-08  -1.80503253982449E-08  -1.31452873665267E-18
      2.89270818749999E-07
      0.00000000000000E+00  -1.69985321176318E-11   0.00000000000000E+00  -4.76708434908850E-14   4.52337131450914E-24
      1.69985983012928E-08   1.69985506304493E-08  -3.26226347859358E-19  -4.64919639035232E-01  -4.64919639035132E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90611144512774E-11   0.00000000000000E+00  -9.90611144512774E-11
      1.55214093641791E-18  -9.66178110250317E-03  -4.33728727174152E-03   0.00000000000000E+00   8.91966806870119E-14
     -5.08449946112216E-24  -1.68995787126787E-08  -1.68994895159980E-08  -1.22591458855855E-18
      2.90931571874999E-07
      0.00000000000000E+00  -1.65017439340763E-11   0.00000000000000E+00  -1.44067920641668E-14   3.86420476438877E-24
      1.65017572669632E-08   1.65017428601711E-08  -2.82942616852621E-19  -4.83073620718342E-01  -4.83073620718242E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00386558353418E-10   0.00000000000000E+00  -1.00386558353418E-10
      1.38542364592448E-18  -8.92809366801947E-03  -3.76054308369257E-03   0.00000000000000E+00   5.10095862280238E-14
     -4.29001722567425E-24  -1.64014073114039E-08  -1.64013563018177E-08  -1.10248102907185E-18
      2.92931571874999E-07
      0.00000000000000E+00  -1.63041859043429E-11   0.00000000000000E+00  -4.55435457150986E-15   3.37014529009706E-24
      1.63041815774979E-08   1.63041770231433E-08  -2.33151283698819E-19  -5.04491236244248E-01  -5.04491236244145E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02666943871315E-10   0.00000000000000E+00  -1.02666943871315E-10
      1.18008975818184E-18  -8.43780731201254E-03  -3.33321858856269E-03   0.00000000000000E+00   3.67628824028983E-14
     -3.67596598802226E-24  -1.62015468421544E-08  -1.62015100792720E-08  -9.46938474483025E-19
      2.94931571874999E-07
      0.00000000000000E+00  -1.62185866092655E-11   0.00000000000000E+00  -1.82450446297016E-15   3.02904230231866E-24
      1.62185759352027E-08   1.62185741106982E-08  -1.85751401775297E-19  -5.25472558469802E-01  -5.25472558469697E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05009696060287E-10   0.00000000000000E+00  -1.05009696060287E-10
      9.70070366061270E-19  -8.11867478047632E-03  -3.04179206773636E-03   0.00000000000000E+00   3.03842384496813E-14
     -3.24310620485966E-24  -1.61135947988764E-08  -1.61135644146380E-08  -7.84318964285972E-19
      2.96931571874999E-07
      0.00000000000000E+00  -1.61728479301362E-11   0.00000000000000E+00  -8.68744774499619E-16   2.77766673258413E-24
      1.61728051782642E-08   1.61728043095194E-08  -1.40624236938903E-19  -5.46026177672445E-01  -5.46026177672339E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06786966685296E-10   0.00000000000000E+00  -1.06786966685296E-10
      7.56496432690678E-19  -7.89130581203974E-03  -2.82940159925237E-03   0.00000000000000E+00   2.65106850363310E-14
     -2.91810026514662E-24  -1.60660438535192E-08  -1.60660173428341E-08  -6.15872195751774E-19
      2.98931571874999E-07
      0.00000000000000E+00  -1.61445597510763E-11   0.00000000000000E+00  -4.57795373048763E-16   2.58380292870056E-24
      1.61446022697136E-08   1.61446018119182E-08  -9.76171079931274E-20  -5.66158298849026E-01  -5.66158298848918E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07989233473737E-10   0.00000000000000E+00  -1.07989233473737E-10
      5.40517965743203E-19  -7.72038872140498E-03  -2.66774716722687E-03   0.00000000000000E+00   2.37248010940840E-14
     -2.66559752666812E-24  -1.60366363032455E-08  -1.60366125784444E-08  -4.42900857750075E-19
      3.00931571874999E-07
      0.00000000000000E+00  -1.61256397352115E-11   0.00000000000000E+00  -2.49097706006319E-16   2.42942158878238E-24
      1.61256305077897E-08   1.61256302586920E-08  -5.65989184384841E-20  -5.85857985902965E-01  -5.85857985902857E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08576042964916E-10   0.00000000000000E+00  -1.08576042964916E-10
      3.23365879813371E-19  -7.58685316085976E-03  -2.54037212370344E-03   0.00000000000000E+00   2.15462498542156E-14
     -2.46428745030435E-24  -1.60170757619769E-08  -1.60170542157270E-08  -2.66766961374887E-19
      3.02931571874999E-07
      0.00000000000000E+00  -1.61109445772583E-11   0.00000000000000E+00  -1.59278127172174E-16   2.30414532929463E-24
      1.61109801989458E-08   1.61109800396677E-08  -1.77865483709744E-20  -6.04941124150475E-01  -6.04941124150367E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07623861278972E-10   0.00000000000000E+00  -1.07623861278972E-10
      1.08118157255428E-19  -7.47935599851921E-03  -2.43718935912479E-03   0.00000000000000E+00   1.95875079708153E-14
     -2.30149666203636E-24  -1.60033757658967E-08  -1.60033561783887E-08  -9.03316088844546E-20
      3.04931571874999E-07
      0.00000000000000E+00  -1.60889936850657E-11   0.00000000000000E+00  -3.61419742256358E-16   2.20973774662195E-24
      1.60889871156412E-08   1.60889867542214E-08   1.80793790449304E-20  -6.22942965145536E-01  -6.22942965145433E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03449682862598E-10   0.00000000000000E+00  -1.03449682862598E-10
     -9.87812084697679E-20  -7.40595455007309E-03  -2.36940099225299E-03   0.00000000000000E+00   1.76717543822267E-14
     -2.18051235519478E-24  -1.59855547431132E-08  -1.59855370713588E-08   8.07018294248372E-20
      3.06931571874999E-07
      0.00000000000000E+00  -1.60648385191801E-11   0.00000000000000E+00  -4.38468241058760E-16   2.14023815108561E-24
      1.60648662258859E-08   1.60648657874177E-08   4.97604708565540E-20  -6.39127332823913E-01  -6.39127332823819E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.44359709171337E-11   0.00000000000000E+00  -9.44359709171337E-11
     -2.87653150304035E-19  -7.36110562922760E-03  -2.32931093278108E-03   0.00000000000000E+00   1.52056416536376E-14
     -2.09298353382420E-24  -1.59704450221422E-08  -1.59704298165005E-08   2.37892679447481E-19
      3.08931571874999E-07
      0.00000000000000E+00  -1.60415099559294E-11   0.00000000000000E+00  -4.51930242489254E-16   2.08760766636963E-24
      1.60415386739113E-08   1.60415382219810E-08   7.51935502306252E-20  -6.52307777168574E-01  -6.52307777168496E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.78491825640675E-11   0.00000000000000E+00  -7.78491825640675E-11
     -4.43351515432170E-19  -7.32831022764370E-03  -2.29863857717984E-03   0.00000000000000E+00   1.18561385840174E-14
     -2.02795789909810E-24  -1.59637008955556E-08  -1.59636890394170E-08   3.68157965201545E-19
      3.09931571874999E-07
      0.00000000000000E+00  -1.60260800400785E-11   0.00000000000000E+00  -6.60622988069174E-16   2.06599582612316E-24
      1.60260973250154E-08   1.60260966643925E-08   8.57274134751325E-20  -6.57814014739151E-01  -6.57814014739085E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55146167375588E-11   0.00000000000000E+00  -6.55146167375588E-11
     -5.08866132169729E-19  -7.31459833765758E-03  -2.28590529276124E-03   0.00000000000000E+00   9.72992168832411E-15
     -2.00217082781556E-24  -1.59605917775766E-08  -1.59605820476549E-08   4.23138718694596E-19
      3.11281571874999E-07
      0.00000000000000E+00  -1.60000879794488E-11   0.00000000000000E+00  -8.82540769676673E-16   2.04573220293967E-24
      1.60001274275235E-08   1.60001265449827E-08   9.51440016108553E-20  -6.62758554586324E-01  -6.62758554586280E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.37523378237270E-11   0.00000000000000E+00  -4.37523378237270E-11
     -5.67931788231761E-19  -7.30102092305876E-03  -2.27365336079015E-03   0.00000000000000E+00   6.45792126919014E-15
     -1.97926509807431E-24  -1.59563806650803E-08  -1.59563742071590E-08   4.72787786620905E-19
      3.13104071874999E-07
      0.00000000000000E+00  -1.59549922134799E-11   0.00000000000000E+00  -1.21461454232865E-15   2.03751281280532E-24
      1.59549803977715E-08   1.59549791831569E-08   9.66395324208027E-20  -6.63543502657123E-01  -6.63543502657118E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.17705889880599E-12   0.00000000000000E+00  -5.17705889880599E-12
     -5.77366978074834E-19  -7.29319406708518E-03  -2.26789711824421E-03   0.00000000000000E+00   9.18597209212836E-16
     -1.97457348917720E-24  -1.59498030428553E-08  -1.59498021242581E-08   4.80727445654032E-19
      3.15104071874999E-07
      0.00000000000000E+00  -1.58901498290114E-11   0.00000000000000E+00  -1.67838872788063E-15   2.05848781209558E-24
      1.58901267267026E-08   1.58901250483138E-08   8.05212407504234E-20  -6.55081138609412E-01  -6.55081138609463E-01
      0.00000000000000E+00   0.00000000000000E+00   5.04560846946277E-11   0.00000000000000E+00   5.04560846946277E-11
     -4.76454808685579E-19  -7.30099825550270E-03  -2.27860702387221E-03   0.00000000000000E+00  -7.05971431043870E-15
     -2.01114415525599E-24  -1.59405740732941E-08  -1.59405811330085E-08   3.95933567935155E-19
      3.17104071874999E-07
      0.00000000000000E+00  -1.58062037392037E-11   0.00000000000000E+00  -2.28522092245827E-15   2.12331827003210E-24
      1.58062747250140E-08   1.58062724397931E-08   4.08790881160076E-20  -6.34548679401199E-01  -6.34548679401320E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21123665602944E-10   0.00000000000000E+00   1.21123665602944E-10
     -2.34207477479692E-19  -7.33269589867113E-03  -2.31446003591704E-03   0.00000000000000E+00  -1.78885775923864E-14
     -2.11070743976327E-24  -1.59273782168184E-08  -1.59273961053960E-08   1.93328389363685E-19
      3.19104071874999E-07
      0.00000000000000E+00  -1.56858871334619E-11   0.00000000000000E+00  -3.70807306561195E-15   2.27564715670099E-24
      1.56858810088103E-08   1.56858773007373E-08  -3.04352123951095E-20  -5.98651445798421E-01  -5.98651445798628E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06676671126367E-10   0.00000000000000E+00   2.06676671126367E-10
      1.79145864773043E-19  -7.43023547081190E-03  -2.42297948260157E-03   0.00000000000000E+00  -3.28938811686410E-14
     -2.34278546443472E-24  -1.58925210779825E-08  -1.58925539718636E-08  -1.48710652377934E-19
      3.21104071874999E-07
      0.00000000000000E+00  -1.54853900721378E-11   0.00000000000000E+00  -6.35634354460706E-15   2.65154813021318E-24
      1.54853349163244E-08   1.54853285599809E-08  -1.45689532080711E-19  -5.43653244167967E-01  -5.43653244168268E-01
      0.00000000000000E+00   0.00000000000000E+00   3.00842248350677E-10   0.00000000000000E+00   3.00842248350677E-10
      7.80830361474396E-19  -7.73222531108107E-03  -2.75849191501161E-03   0.00000000000000E+00  -5.64286065740846E-14
     -2.95063582555904E-24  -1.57861143797250E-08  -1.57861708083315E-08  -6.35140829393685E-19
      3.23104071874999E-07
      0.00000000000000E+00  -1.50564751493787E-11   0.00000000000000E+00  -1.19156582415314E-14   3.65168217507885E-24
      1.50565597240210E-08   1.50565478083628E-08  -3.22666216191228E-19  -4.66312926893890E-01  -4.66312926894268E-01
      0.00000000000000E+00   0.00000000000000E+00   3.78228767826355E-10   0.00000000000000E+00   3.78228767826355E-10
      1.53728789712710E-18  -8.71350598482461E-03  -3.85049672045411E-03   0.00000000000000E+00  -1.00605582563888E-13
     -5.07774821129666E-24  -1.54346759706066E-08  -1.54347765761891E-08  -1.21462168093588E-18
      3.25104071874999E-07
      0.00000000000000E+00  -1.26462855555788E-11   0.00000000000000E+00  -6.17015810091055E-14   6.02833672560430E-24
      1.26463426850178E-08   1.26462809834368E-08  -5.70655450755454E-19  -3.65434931887753E-01  -3.65434931888151E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98074693024867E-10   0.00000000000000E+00   3.98074693024867E-10
      2.33343728317684E-18  -1.43448748409756E-02  -1.02350332033643E-02   0.00000000000000E+00  -1.80825521364270E-13
     -2.12566383643272E-23  -1.30441748509403E-08  -1.30443556764617E-08  -1.76278183242139E-18
      3.27104071874999E-07
      0.00000000000000E+00  -2.91496826949248E-12   0.00000000000000E+00  -5.05161649789425E-14  -2.13396360764322E-23
      2.91516133115439E-09   2.91511081498939E-09  -8.37858138751432E-19  -2.44928067521998E-01  -2.44928067522406E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08570746977238E-10   0.00000000000000E+00   4.08570746977238E-10
      3.15057877713132E-18  -3.88543680891449E-02  -3.78072603967997E-02   0.00000000000000E+00  -5.49805137735884E-13
     -7.80500369282393E-23  -3.32313175682881E-09  -3.32368156196662E-09  -2.31272063837988E-18
      3.29104071874999E-07
      0.00000000000000E+00  -2.76452658994656E-14   0.00000000000000E+00  -7.82545679752475E-14  -4.37638440630506E-23
      2.77355659173309E-11   2.76573113493119E-11  -1.09424474327170E-18  -1.20408961431293E-01  -1.20408961431667E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73636756930588E-10   0.00000000000000E+00   3.73636756930588E-10
      3.89785229099249E-18  -6.85784856701655E-02  -6.84520538933962E-02   0.00000000000000E+00  -1.04272525775484E-12
     -9.29978845522592E-23  -4.00251343022051E-10  -4.01294068279899E-10  -2.80360754772079E-18
      3.31104071874999E-07
      0.00000000000000E+00   7.20062739707010E-14   0.00000000000000E+00  -8.06181801300612E-15  -4.60359553405190E-23
     -7.19510813016464E-11  -7.19591431197054E-11  -1.24527250296911E-18  -4.47839374420504E-02  -4.47839374422907E-02
      0.00000000000000E+00   0.00000000000000E+00   2.40261848335246E-10   0.00000000000000E+00   2.40261848335246E-10
      4.37837598766298E-18  -9.81575145763395E-02  -9.81044891668514E-02   0.00000000000000E+00  -1.12822085505878E-12
     -1.02285654648833E-22  -1.67174484360379E-10  -1.68302705215540E-10  -3.13310348469387E-18
      3.33104071874999E-07
      0.00000000000000E+00   2.52573027320699E-14   0.00000000000000E+00  -2.21573333085745E-16  -4.63947218337965E-23
     -2.52170205505381E-11  -2.52172421239175E-11  -1.29906422921485E-18  -1.92177615602243E-02  -1.92177615603523E-02
      0.00000000000000E+00   0.00000000000000E+00   1.28003884816020E-10   0.00000000000000E+00   1.28003884816020E-10
      4.63438375729502E-18  -1.27262382016149E-01  -1.27229998430668E-01   0.00000000000000E+00  -6.55108354681731E-13
     -1.06558377301617E-22  -1.02131534337314E-10  -1.02786642692102E-10  -3.33531952808017E-18
      3.35104071874999E-07
      0.00000000000000E+00  -2.75534211622580E-15   0.00000000000000E+00   8.83275493656689E-16  -4.62296456303256E-23
      2.75588864075248E-12   2.75677191619990E-12  -1.31599948072185E-18  -1.17878638206910E-02  -1.17878638207705E-02
      0.00000000000000E+00   0.00000000000000E+00   7.94754942576713E-11   0.00000000000000E+00   7.94754942576713E-11
      4.79333474581037E-18  -1.55808325145132E-01  -1.55782417614399E-01   0.00000000000000E+00  -4.50221981346431E-13
     -1.09191868414796E-22  -8.17820441924166E-11  -8.22322661738723E-11  -3.47733526508851E-18
      3.36104071874999E-07
      0.00000000000000E+00  -1.31337974206763E-14   0.00000000000000E+00   9.91715654072774E-16  -4.59785627136471E-23
      1.31599560670856E-11   1.31609477826937E-11  -1.31971302597479E-18  -1.01416436034783E-02  -1.01416436035431E-02
      0.00000000000000E+00   0.00000000000000E+00   6.48691742854927E-11   0.00000000000000E+00   6.48691742854927E-11
      4.85820392009585E-18  -1.69935022171868E-01  -1.69910438653067E-01   0.00000000000000E+00  -4.15805199079742E-13
     -1.05316753011213E-22  -7.76143168690015E-11  -7.80301220681866E-11  -3.53849089412107E-18
      3.37454071874999E-07
      0.00000000000000E+00  -2.35122527251268E-14   0.00000000000000E+00   8.52601982483373E-16  -4.53890086711854E-23
      2.35109886368345E-11   2.35118412387716E-11  -1.32098543949480E-18  -9.19591494091786E-03  -9.19591494097137E-03
      0.00000000000000E+00   0.00000000000000E+00   5.35199521334866E-11   0.00000000000000E+00   5.35199521334866E-11
      4.93045585547606E-18  -1.88738356536356E-01  -1.88714087664490E-01   0.00000000000000E+00  -4.11790639942887E-13
     -1.12449770504353E-22  -7.66200027322030E-11  -7.70317933722584E-11  -3.60947041598127E-18
      3.39276571874999E-07
      0.00000000000000E+00  -3.44417764528225E-14   0.00000000000000E+00   6.65587233960497E-16  -4.39234430214678E-23
      3.44151685771098E-11   3.44158341642998E-11  -1.31992475150488E-18  -8.59919018804295E-03  -8.59919018808718E-03
      0.00000000000000E+00   0.00000000000000E+00   4.42363764080553E-11   0.00000000000000E+00   4.42363764080553E-11
      5.01107665147974E-18  -2.13643136990264E-01  -2.13618357775538E-01   0.00000000000000E+00  -4.27920106858868E-13
     -1.14061831942312E-22  -7.82242904653818E-11  -7.86522105723547E-11  -3.69115189997486E-18
      3.41276571874999E-07
      0.00000000000000E+00  -4.44528528084430E-14   0.00000000000000E+00   5.17257947824166E-16  -4.09838515196335E-23
      4.44908535434122E-11   4.44913708013190E-11  -1.31737570806287E-18  -8.21959985999855E-03  -8.21959986003610E-03
      0.00000000000000E+00   0.00000000000000E+00   3.75533850099214E-11   0.00000000000000E+00   3.75533850099214E-11
      5.08618342149959E-18  -2.40410414080873E-01  -2.40384566257651E-01   0.00000000000000E+00  -4.48491586417884E-13
     -1.16301429253772E-22  -8.15962642247057E-11  -8.20447558112399E-11  -3.76880771343672E-18
      3.43276571874999E-07
      0.00000000000000E+00  -5.34536370547806E-14   0.00000000000000E+00   4.19545611601654E-16  -3.60407574659017E-23
      5.34549373955766E-11   5.34553569411522E-11  -1.31430579891472E-18  -7.96290638829395E-03  -7.96290638832687E-03
      0.00000000000000E+00   0.00000000000000E+00   3.29193860034110E-11   0.00000000000000E+00   3.29193860034110E-11
      5.15202219350641E-18  -2.66628732797473E-01  -2.66601521062179E-01   0.00000000000000E+00  -4.67421812738531E-13
     -1.18689847558770E-22  -8.59073211317057E-11  -8.63747429445630E-11  -3.83771639459169E-18
      3.45276571874999E-07
      0.00000000000000E+00  -6.17196634034580E-14   0.00000000000000E+00   3.55727340210532E-16  -2.85067741234414E-23
      6.16859900027846E-11   6.16863457300963E-11  -1.31112829065140E-18  -7.77458629358897E-03  -7.77458629361855E-03
      0.00000000000000E+00   0.00000000000000E+00   2.95848279360041E-11   0.00000000000000E+00   2.95848279360041E-11
      5.21119184937842E-18  -2.92307539562786E-01  -2.92278785496473E-01   0.00000000000000E+00  -4.84588726530048E-13
     -1.21044025781940E-22  -9.07865849394499E-11  -9.12711736661010E-11  -3.90006355872701E-18
      3.47276571874999E-07
      0.00000000000000E+00  -6.94346213288902E-14   0.00000000000000E+00   3.13543007547232E-16  -1.79202406325128E-23
      6.94200764065730E-11   6.94203899495626E-11  -1.30803555345195E-18  -7.62959096349895E-03  -7.62959096352604E-03
      0.00000000000000E+00   0.00000000000000E+00   2.70898693418399E-11   0.00000000000000E+00   2.70898693418399E-11
      5.26537158806210E-18  -3.17450183425201E-01  -3.17419779111880E-01   0.00000000000000E+00  -5.01494030197782E-13
     -1.23443356118054E-22  -9.60087652610815E-11  -9.65102592914027E-11  -3.95733603461014E-18
      3.49276571874999E-07
      0.00000000000000E+00  -7.67822003054924E-14   0.00000000000000E+00   2.85447965447953E-16  -4.21733927909206E-24
      7.68200823836228E-11   7.68203678315840E-11  -1.30510714011516E-18  -7.51394916247555E-03  -7.51394916250070E-03
      0.00000000000000E+00   0.00000000000000E+00   2.51443737235895E-11   0.00000000000000E+00   2.51443737235895E-11
      5.31566033550928E-18  -3.42063887732847E-01  -3.42031765348911E-01   0.00000000000000E+00  -5.19669892851029E-13
     -1.25878816341823E-22  -1.01445071662196E-10  -1.01964741555173E-10  -4.01055319539412E-18
      3.51276571874999E-07
      0.00000000000000E+00  -8.40379345448870E-14   0.00000000000000E+00   2.67100654142637E-16   1.18499186704493E-23
      8.40102721052793E-11   8.40105392059453E-11  -1.30235638578029E-18  -7.42413336920962E-03  -7.42413336923316E-03
      0.00000000000000E+00   0.00000000000000E+00   2.35406585139866E-11   0.00000000000000E+00   2.35406585139866E-11
      5.36274165253725E-18  -3.66148377867900E-01  -3.66114495873583E-01   0.00000000000000E+00  -5.39847934858800E-13
     -1.28346442730036E-22  -1.07011349784945E-10  -1.07551197719932E-10  -4.06038526675696E-18
      3.53276571874999E-07
      0.00000000000000E+00  -9.11099793098665E-14   0.00000000000000E+00   2.57738915717046E-16   2.88336559274968E-23
      9.11238940449102E-11   9.11241517838548E-11  -1.29973882187634E-18  -7.37424948947269E-03  -7.37424948949481E-03
      0.00000000000000E+00   0.00000000000000E+00   2.21274522746128E-11   0.00000000000000E+00   2.21274522746128E-11
      5.40699655708648E-18  -3.89706561510351E-01  -3.89670884047916E-01   0.00000000000000E+00  -5.62360985993334E-13
     -1.30819472720345E-22  -1.12689243072345E-10  -1.13251604058469E-10  -4.10725773521014E-18
      3.55276571874999E-07
      0.00000000000000E+00  -9.81820240748461E-14   0.00000000000000E+00   2.48532886268754E-16   4.56541652380389E-23
      9.81465282585012E-11   9.81467767914331E-11  -1.29727647446093E-18  -7.33768505757225E-03  -7.33768505759326E-03
      0.00000000000000E+00   0.00000000000000E+00   2.10118520529618E-11   0.00000000000000E+00   2.10118520529618E-11
      5.44902026119240E-18  -4.12894101402352E-01  -4.12856563421800E-01   0.00000000000000E+00  -5.93962355883799E-13
     -1.33413590008556E-22  -1.18564666488376E-10  -1.19158628844394E-10  -4.15174378673147E-18
      3.57276571874999E-07
      0.00000000000000E+00  -1.05070379365411E-13   0.00000000000000E+00   2.41586739651753E-16   6.14275349864319E-23
      1.05110922307323E-10   1.05111163894124E-10  -1.29495728288071E-18  -7.31116394461455E-03  -7.31116394463454E-03
      0.00000000000000E+00   0.00000000000000E+00   1.99888233582714E-11   0.00000000000000E+00   1.99888233582714E-11
      5.48899790790894E-18  -4.35706503066075E-01  -4.35667093803047E-01   0.00000000000000E+00  -6.29230989240411E-13
     -1.36061935656728E-22  -1.24470756263020E-10  -1.25099987252396E-10  -4.19404062502823E-18
      3.59276571874999E-07
      0.00000000000000E+00  -1.12050579393183E-13   0.00000000000000E+00   2.35713274633865E-16   7.55632052623275E-23
      1.12016869722334E-10   1.12017105435684E-10  -1.29276590897187E-18  -7.29574579887948E-03  -7.29574579889846E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89785654615739E-11   0.00000000000000E+00   1.89785654615739E-11
      5.52695503883209E-18  -4.58081976348535E-01  -4.58040710249090E-01   0.00000000000000E+00  -6.65726164343927E-13
     -1.38789701206313E-22  -1.30329944732776E-10  -1.30995670897259E-10  -4.23418912986022E-18
      3.61276571874999E-07
      0.00000000000000E+00  -1.18847089946540E-13   0.00000000000000E+00   2.31084480262056E-16   8.77213376836142E-23
      1.18874401369176E-10   1.18874632453743E-10  -1.29068225569932E-18  -7.29426747963703E-03  -7.29426747965503E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79978650671152E-11   0.00000000000000E+00   1.79978650671152E-11
      5.56295076896632E-18  -4.80007564104723E-01  -4.79964447169463E-01   0.00000000000000E+00  -7.04372498826247E-13
     -1.41570666051992E-22  -1.36168125021890E-10  -1.36872497520858E-10  -4.27226851326700E-18
      3.63276571874999E-07
      0.00000000000000E+00  -1.25735445237104E-13   0.00000000000000E+00   2.28111835141764E-16   9.78764810442140E-23
      1.25706362102772E-10   1.25706590214705E-10  -1.28868107013061E-18  -7.31210325901912E-03  -7.31210325903618E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70514661602766E-11   0.00000000000000E+00   1.70514661602766E-11
      5.59705370128688E-18  -5.01487392462420E-01  -5.01442422004910E-01   0.00000000000000E+00  -7.44635842061098E-13
     -1.44402936933747E-22  -1.42013420532776E-10  -1.42758056374982E-10  -4.30837263115626E-18
      3.65276571874999E-07
      0.00000000000000E+00  -1.32531955790461E-13   0.00000000000000E+00   2.27697502914478E-16   1.06227852876347E-22
      1.32561431305690E-10   1.32561659003299E-10  -1.28672743714972E-18  -7.35929141975883E-03  -7.35929141977496E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61375320289974E-11   0.00000000000000E+00   1.61375320289974E-11
      5.62932876534487E-18  -5.22529906308402E-01  -5.22483064890295E-01   0.00000000000000E+00  -7.85151416445856E-13
     -1.47276848243631E-22  -1.47914039615703E-10  -1.48699191032296E-10  -4.34260132819515E-18
      3.67276571874999E-07
      0.00000000000000E+00  -1.39971379504271E-13   0.00000000000000E+00   2.50404523561743E-16   1.13321885835255E-22
      1.39954952229419E-10   1.39955202634056E-10  -1.28459072613738E-18  -7.53718597043424E-03  -7.53718597044935E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50999996528179E-11   0.00000000000000E+00   1.50999996528179E-11
      5.65952876465050E-18  -5.43143763148174E-01  -5.43094920158077E-01   0.00000000000000E+00  -8.20225015199235E-13
     -1.50001184615799E-22  -1.54234977271525E-10  -1.55055202286874E-10  -4.37493803851313E-18
      3.69276571874999E-07
      0.00000000000000E+00  -1.48880319013401E-13   0.00000000000000E+00   3.14953006431783E-16   1.20052906362426E-22
      1.48880523040343E-10   1.48880837993470E-10  -1.28182511342507E-18  -8.04007269495875E-03  -8.04007269497252E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37686751373481E-11   0.00000000000000E+00   1.37686751373481E-11
      5.68706611492520E-18  -5.63336026606763E-01  -5.63284792066067E-01   0.00000000000000E+00  -8.43223510720828E-13
     -1.52866653125770E-22  -1.61806289619944E-10  -1.62649513130817E-10  -4.40524100150013E-18
      3.71276571874999E-07
      0.00000000000000E+00  -1.66422663820038E-13   0.00000000000000E+00   6.40920621137334E-16   1.30671209589991E-22
      1.66407512970884E-10   1.66408153891636E-10  -1.27568481768633E-18  -1.01180810723790E-02  -1.01180810723892E-02
      0.00000000000000E+00   0.00000000000000E+00   1.02470951899482E-11   0.00000000000000E+00   1.02470951899482E-11
      5.70756030530510E-18  -5.83103522366050E-01  -5.83047876838543E-01   0.00000000000000E+00  -7.98686705975664E-13
     -1.55519311141296E-22  -1.75856562375454E-10  -1.76655249081585E-10  -4.43187548761876E-18
      3.73276571874999E-07
      0.00000000000000E+00  -2.66900806325073E-13   0.00000000000000E+00   3.71504621129051E-15   1.81587257686268E-22
      2.66913822522139E-10   2.66917537568532E-10  -1.24346141058969E-18  -2.39732422475693E-02  -2.39732422475572E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.20073982113769E-11   0.00000000000000E+00  -1.20073982113769E-11
      5.68354550888234E-18  -6.02330859786970E-01  -6.02250565781895E-01   0.00000000000000E+00  -2.26345491221183E-13
     -1.56222739591595E-22  -2.54683793865777E-10  -2.54910139357155E-10  -4.44008409829266E-18
      3.75276571874999E-07
      0.00000000000000E+00  -5.96164189214056E-13   0.00000000000000E+00   1.03335143388824E-14   2.77785301426204E-22
      5.96194476545284E-10   5.96204810059901E-10  -1.17472541083077E-18  -5.26563158274401E-02  -5.26563158273959E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.41422486604162E-11   0.00000000000000E+00  -4.41422486604162E-11
      5.59526101156151E-18  -6.20605085808374E-01  -6.20431191853973E-01   0.00000000000000E+00   4.86706536467019E-13
     -1.54740789837419E-22  -5.52549267935796E-10  -5.52062561399484E-10  -4.42053560073074E-18
      3.77276571874999E-07
      0.00000000000000E+00  -1.25331328393391E-12   0.00000000000000E+00   1.81105495983241E-14   3.41218027214906E-22
      1.25330713038800E-09   1.25332524093794E-09  -1.10024538183993E-18  -8.24127141032355E-02  -8.24127141031801E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.54092984239466E-11   0.00000000000000E+00  -5.54092984239466E-11
      5.48444241471362E-18  -6.37269739818246E-01  -6.36892405357237E-01   0.00000000000000E+00   4.78207858955123E-13
     -1.53091493107219E-22  -1.19839415037280E-09  -1.19791594251399E-09  -4.38419703287369E-18
      3.79276571874999E-07
      0.00000000000000E+00  -2.47723625196141E-12   0.00000000000000E+00   3.17984909405980E-14   3.82681900421106E-22
      2.47723886689980E-09   2.47727066539112E-09  -1.02894404945629E-18  -1.11789460874954E-01  -1.11789460874889E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.56474717014828E-11   0.00000000000000E+00  -6.56474717014828E-11
      5.35314747131065E-18  -6.51256338406611E-01  -6.50496689902400E-01   0.00000000000000E+00   3.93824930556994E-13
     -1.51770144741418E-22  -2.41201701862005E-09  -2.41162319368964E-09  -4.32420342185436E-18
      3.81276571874999E-07
      0.00000000000000E+00  -4.54401837334239E-12   0.00000000000000E+00   5.23645163881157E-14   4.15433356968953E-22
      4.54396592172094E-09   4.54401828623775E-09  -9.64463878239953E-19  -1.40639937746117E-01  -1.40639937746039E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.86338078675083E-11   0.00000000000000E+00  -7.86338078675083E-11
      5.19587985557563E-18  -6.60989868255112E-01  -6.59583287919207E-01   0.00000000000000E+00   2.95770619745015E-13
     -1.50651285927477E-22  -4.46568024898984E-09  -4.46538447837024E-09  -4.23141597733568E-18
      3.82276571874999E-07
      0.00000000000000E+00  -6.00986037917451E-12   0.00000000000000E+00   7.35652101496131E-14   4.35945614892122E-22
      6.00974314684888E-09   6.00981671205947E-09  -9.34362179467162E-19  -1.54922516292731E-01  -1.54922516292644E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.73307337098449E-11   0.00000000000000E+00  -8.73307337098449E-11
      5.10854912186579E-18  -6.64382949043379E-01  -6.62517382274941E-01   0.00000000000000E+00   2.28379455725044E-13
     -1.50240329876743E-22  -5.92271435780520E-09  -5.92248597834962E-09  -4.17418694239863E-18
      3.83626571874999E-07
      0.00000000000000E+00  -8.44402144938559E-12   0.00000000000000E+00   9.00824194691240E-14   4.52372264252990E-22
      8.44389138378440E-09   8.44398146620432E-09  -8.96935490904694E-19  -1.73936789681257E-01  -1.73936789681159E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87357191579857E-11   0.00000000000000E+00  -9.87357191579857E-11
      4.97525590100251E-18  -6.65713755539051E-01  -6.63085017692735E-01   0.00000000000000E+00   2.01324840769223E-13
     -1.49683051563662E-22  -8.34544707188696E-09  -8.34524574704634E-09  -4.07832041009781E-18
      3.85449071874999E-07
      0.00000000000000E+00  -1.26119356238632E-11   0.00000000000000E+00   1.13862279014617E-13   4.60044445002621E-22
      1.26118145984490E-08   1.26119284607285E-08  -8.50472780557711E-19  -1.99121540864225E-01  -1.99121540864112E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12544344200686E-10   0.00000000000000E+00  -1.12544344200686E-10
      4.77014383369676E-18  -6.60129515952552E-01  -6.56192207469220E-01   0.00000000000000E+00   3.14693486267654E-13
     -1.48540675854226E-22  -1.24996988100139E-08  -1.24993841165278E-08  -3.91967105313905E-18
      3.87449071874999E-07
      0.00000000000000E+00  -1.85528206053948E-11   0.00000000000000E+00   1.47562494501556E-13   4.57595830380333E-22
      1.85525930528959E-08   1.85527406153909E-08  -8.02548934567838E-19  -2.26187929597057E-01  -2.26187929596933E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24846197639613E-10   0.00000000000000E+00  -1.24846197639613E-10
      4.52045143841753E-18  -6.42628679151166E-01  -6.36823814778778E-01   0.00000000000000E+00   6.73634342237286E-13
     -1.45911547277680E-22  -1.84285680520934E-08  -1.84278944177513E-08  -3.71790250384970E-18
      3.89449071874999E-07
      0.00000000000000E+00  -2.62316835491045E-11   0.00000000000000E+00   1.90537735827950E-13   4.44988347297607E-22
      2.62315173515650E-08   2.62317078893013E-08  -7.56214891892619E-19  -2.52697957445618E-01  -2.52697957445484E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34036215741378E-10   0.00000000000000E+00  -1.34036215741378E-10
      4.25237900693477E-18  -6.10593685464119E-01  -6.02372624583821E-01   0.00000000000000E+00   1.24742550339194E-12
     -1.40851762347779E-22  -2.60989190990632E-08  -2.60976716735599E-08  -3.49616411504216E-18
      3.91449071874999E-07
      0.00000000000000E+00  -3.59462850930190E-11   0.00000000000000E+00   2.41011566052951E-13   4.21309218090200E-22
      3.59460974992332E-08   3.59463385107997E-08  -7.10534324399100E-19  -2.78664155066466E-01  -2.78664155066324E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41658383019188E-10   0.00000000000000E+00  -1.41658383019188E-10
      3.96906224089640E-18  -5.60337438007866E-01  -5.49058185497912E-01   0.00000000000000E+00   1.84749708101579E-12
     -1.32585034744877E-22  -3.58065276248613E-08  -3.58046801277805E-08  -3.25852791649730E-18
      3.93449071874999E-07
      0.00000000000000E+00  -4.76289356658164E-11   0.00000000000000E+00   2.71975466912011E-13   3.78158055871520E-22
      4.76286476867560E-08   4.76289196622233E-08  -6.65228272743449E-19  -3.04092804831185E-01  -3.04092804831034E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51068130487185E-10   0.00000000000000E+00  -1.51068130487185E-10
      3.66692597992203E-18  -4.88346160170009E-01  -4.73389009426039E-01   0.00000000000000E+00   2.17335998815303E-12
     -1.21625961910486E-22  -4.74800248917241E-08  -4.74778515317361E-08  -3.00169770717858E-18
      3.95449071874999E-07
      0.00000000000000E+00  -6.04027935613765E-11   0.00000000000000E+00   3.17664472064780E-13   3.05757289306716E-22
      6.04024445006010E-08   6.04027621650734E-08  -6.20431932999022E-19  -3.28987476591856E-01  -3.28987476591692E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63759210355955E-10   0.00000000000000E+00  -1.63759210355955E-10
      3.33940755921012E-18  -3.92813224412796E-01  -3.73835160236038E-01   0.00000000000000E+00   2.00591125448741E-12
     -1.11766277891031E-22  -6.02410088659719E-08  -6.02390029547175E-08  -2.71897562621109E-18
      3.97449071874999E-07
      0.00000000000000E+00  -7.23285571535622E-11   0.00000000000000E+00   3.94701923513397E-13   2.39051305654306E-22
      7.23282919897330E-08   7.23286866916568E-08  -5.76170187964485E-19  -3.53356585042328E-01  -3.53356585042151E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77325369944291E-10   0.00000000000000E+00  -1.77325369944291E-10
      2.98475681932154E-18  -2.75809961439653E-01  -2.53078222246727E-01   0.00000000000000E+00   1.55421010220512E-12
     -9.60700215345007E-23  -7.21529155318146E-08  -7.21513613217124E-08  -2.40858663135705E-18
      3.99449071874999E-07
      0.00000000000000E+00  -7.82955260404608E-11   0.00000000000000E+00   1.49330127995713E-13   1.53100342120990E-22
      7.82953879265898E-08   7.82955372567179E-08  -5.33103643305610E-19  -3.77189006398985E-01  -3.77189006398783E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.01705525049772E-10   0.00000000000000E+00  -2.01705525049772E-10
      2.58134576922199E-18  -1.49412989014449E-01  -1.24808458209211E-01   0.00000000000000E+00   1.02436252602920E-12
     -8.21413630692495E-23  -7.80948560941942E-08  -7.80938317316682E-08  -2.04824212591638E-18
      4.01449071874999E-07
      0.00000000000000E+00  -6.21106464497504E-11   0.00000000000000E+00  -4.02558844690931E-13   4.81033953200535E-23
      6.21111107069041E-08   6.21107081480595E-08  -4.86082030102244E-19  -4.00554776400353E-01  -4.00554776400157E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.95584431205670E-10   0.00000000000000E+00  -1.95584431205670E-10
      2.19017690681065E-18  -5.70009703002073E-02  -3.74935779608080E-02   0.00000000000000E+00   8.64300911204076E-13
     -4.68810559426443E-23  -6.19159880177650E-08  -6.19151237168538E-08  -1.70409487670841E-18
      4.03449071874999E-07
      0.00000000000000E+00  -3.30971695001043E-11   0.00000000000000E+00  -7.18854266754126E-13   1.43070974639908E-23
      3.30978758525926E-08   3.30971569983259E-08  -4.28789810222767E-19  -4.23578686847317E-01  -4.23578686847187E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30323359190206E-10   0.00000000000000E+00  -1.30323359190206E-10
      1.92953018843024E-18  -2.29048898166597E-02  -1.25181089198341E-02   0.00000000000000E+00   8.46961778312496E-13
     -1.47454440603755E-23  -3.29676806009140E-08  -3.29668336391357E-08  -1.50074037820748E-18
      4.05449071874999E-07
      0.00000000000000E+00  -2.10910417628620E-11   0.00000000000000E+00  -2.96276622287372E-13   6.69950496488032E-24
      2.10913345302852E-08   2.10910382536629E-08  -3.72104629935314E-19  -4.46191117370752E-01  -4.46191117370648E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04021640576264E-10   0.00000000000000E+00  -1.04021640576264E-10
      1.72148690727772E-18  -1.28494851211476E-02  -6.23714719757275E-03   0.00000000000000E+00   3.56323205343598E-13
     -7.39515439288433E-24  -2.09873729362920E-08  -2.09870166130867E-08  -1.34938227734240E-18
      4.07449071874999E-07
      0.00000000000000E+00  -1.75490494724538E-11   0.00000000000000E+00  -8.70635702305447E-14   4.56703589267161E-24
      1.75491447456098E-08   1.75490576820396E-08  -3.18031623946951E-19  -4.68356958887029E-01  -4.68356958886930E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97734387151403E-11   0.00000000000000E+00  -9.97734387151403E-11
      1.52194002984744E-18  -9.87678050126803E-03  -4.37906373262877E-03   0.00000000000000E+00   1.29885973575887E-13
     -5.08847452646313E-24  -1.74494141292980E-08  -1.74492842433244E-08  -1.20390840590048E-18
      4.09449071874999E-07
      0.00000000000000E+00  -1.65837612844027E-11   0.00000000000000E+00  -2.34760251449214E-14   3.72037070663379E-24
      1.65837648643579E-08   1.65837413883328E-08  -2.66532646511641E-19  -4.90073862414135E-01  -4.90073862414034E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01195835691853E-10   0.00000000000000E+00  -1.01195835691853E-10
      1.31954835846373E-18  -8.83157228476551E-03  -3.63844036376831E-03   0.00000000000000E+00   5.90248549117830E-14
     -4.10315847495059E-24  -1.64826045774959E-08  -1.64825455526409E-08  -1.05301571195209E-18
      4.11449071874999E-07
      0.00000000000000E+00  -1.63062064885615E-11   0.00000000000000E+00  -6.53966227552092E-15   3.25402391395129E-24
      1.63062039150317E-08   1.63061973753695E-08  -2.17512895241193E-19  -5.11348725579438E-01  -5.11348725579334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03562035946284E-10   0.00000000000000E+00  -1.03562035946284E-10
      1.11242428657116E-18  -8.33972296061876E-03  -3.23477871434908E-03   0.00000000000000E+00   3.75154383511518E-14
     -3.52864811657131E-24  -1.62026728548615E-08  -1.62026353394232E-08  -8.94911391329969E-19
      4.13449071874999E-07
      0.00000000000000E+00  -1.62092184460704E-11   0.00000000000000E+00  -2.11500392765304E-15   2.94110162068192E-24
      1.62092065817746E-08   1.62092044667707E-08  -1.70862776044646E-19  -5.32190398660457E-01  -5.32190398660352E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05666960373743E-10   0.00000000000000E+00  -1.05666960373743E-10
      9.01090365823675E-19  -8.04116027265072E-03  -2.96743590040154E-03   0.00000000000000E+00   2.96662263310117E-14
     -3.12953047823933E-24  -1.61035671726233E-08  -1.61035375063970E-08  -7.30227589779029E-19
      4.15449071874999E-07
      0.00000000000000E+00  -1.61643982143131E-11   0.00000000000000E+00  -8.51949459734799E-16   2.70986577011552E-24
      1.61644308000124E-08   1.61644299480630E-08  -1.26439754672859E-19  -5.52607052166952E-01  -5.52607052166845E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07244299032861E-10   0.00000000000000E+00  -1.07244299032861E-10
      6.86601767757952E-19  -7.83182339540606E-03  -2.77270117179025E-03   0.00000000000000E+00   2.56715118743658E-14
     -2.82980870252938E-24  -1.60572113205420E-08  -1.60571856490301E-08  -5.60162013085094E-19
      4.17449071874999E-07
      0.00000000000000E+00  -1.61384979984206E-11   0.00000000000000E+00  -4.09088925848214E-16   2.53011154381296E-24
      1.61384643733209E-08   1.61384639642319E-08  -8.40859531069327E-20  -5.72603230323570E-01  -5.72603230323462E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08262663776211E-10   0.00000000000000E+00  -1.08262663776211E-10
      4.70076440205531E-19  -7.67398176949070E-03  -2.62335963166805E-03   0.00000000000000E+00   2.30016302621853E-14
     -2.59553156163363E-24  -1.60302243020860E-08  -1.60302013004557E-08  -3.85990487098598E-19
      4.19449071874999E-07
      0.00000000000000E+00  -1.61211393430883E-11   0.00000000000000E+00  -2.14281789590156E-16   2.38589764260199E-24
      1.61211322151078E-08   1.61211320008260E-08  -4.37020177881201E-20  -5.92151805622376E-01  -5.92151805622267E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08597840228578E-10   0.00000000000000E+00  -1.08597840228578E-10
      2.52880759748375E-19  -7.54964868370386E-03  -2.50459125691819E-03   0.00000000000000E+00   2.09308621021323E-14
     -2.40758348960086E-24  -1.60125550914596E-08  -1.60125341605975E-08  -2.09178741960255E-19
      4.21449071874999E-07
      0.00000000000000E+00  -1.61070870982956E-11   0.00000000000000E+00  -1.51469188999651E-16   2.26846778060676E-24
      1.61070796227586E-08   1.61070794712895E-08  -5.67285316136488E-21  -6.10983753464529E-01  -6.10983753464422E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06919569794570E-10   0.00000000000000E+00  -1.06919569794570E-10
      3.90416201592342E-20  -7.44862944187325E-03  -2.40746943198121E-03   0.00000000000000E+00   1.89748121947226E-14
     -2.25527060637101E-24  -1.60001788763071E-08  -1.60001599014949E-08  -3.33687669978710E-20
      4.23449071874999E-07
      0.00000000000000E+00  -1.60799929008194E-11   0.00000000000000E+00  -4.92870400534769E-16   2.18477632902892E-24
      1.60800221523248E-08   1.60800216594544E-08   2.91694268309600E-20  -6.28578114259319E-01  -6.28578114259218E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01641341467871E-10   0.00000000000000E+00  -1.01641341467871E-10
     -1.64241062776509E-19  -7.38933546811254E-03  -2.35503644275069E-03   0.00000000000000E+00   1.71115227042754E-14
     -2.14889839227321E-24  -1.59783974295092E-08  -1.59783803179865E-08   1.35071635945548E-19
      4.25449071874999E-07
      0.00000000000000E+00  -1.60591441454733E-11   0.00000000000000E+00  -3.67188447996053E-16   2.12033184815957E-24
      1.60591215805461E-08   1.60591212133576E-08   5.93903744243425E-20  -6.44098782787644E-01  -6.44098782787553E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.09732480087218E-11   0.00000000000000E+00  -9.09732480087218E-11
     -3.46187558793952E-19  -7.34886801281415E-03  -2.31779196611986E-03   0.00000000000000E+00   1.43055375869483E-14
     -2.06792743396360E-24  -1.59681622708865E-08  -1.59681479653489E-08   2.86797184369611E-19
      4.26449071874999E-07
      0.00000000000000E+00  -1.60473880191107E-11   0.00000000000000E+00  -4.48068712294806E-16   2.09270066013877E-24
      1.60473938276430E-08   1.60473933795743E-08   7.28585498571283E-20  -6.51091090794948E-01  -6.51091090794866E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.27212275376042E-11   0.00000000000000E+00  -8.27212275376042E-11
     -4.28908786331556E-19  -7.33170840819891E-03  -2.30172707913694E-03   0.00000000000000E+00   1.25236660456687E-14
     -2.03394827674258E-24  -1.59646846757027E-08  -1.59646721520367E-08   3.56050236474428E-19
      4.27799071874999E-07
      0.00000000000000E+00  -1.60278250900855E-11   0.00000000000000E+00  -6.10627717553433E-16   2.06314658182057E-24
      1.60278498101725E-08   1.60278491995448E-08   8.74150751531945E-20  -6.58698960109121E-01  -6.58698960109054E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70423197531001E-11   0.00000000000000E+00  -6.70423197531001E-11
     -5.19415917998242E-19  -7.31305951943580E-03  -2.28429558736594E-03   0.00000000000000E+00   9.94594037561121E-15
     -1.99817197210046E-24  -1.59608168257320E-08  -1.59608068797916E-08   4.32000842845047E-19
      4.29621571874999E-07
      0.00000000000000E+00  -1.59926485557350E-11   0.00000000000000E+00  -8.96195686585758E-16   2.03924941117998E-24
      1.59926478379375E-08   1.59926469417418E-08   9.82755685615295E-20  -6.64407722641036E-01  -6.64407722640998E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.74544939385536E-11   0.00000000000000E+00  -3.74544939385536E-11
     -5.87676733201255E-19  -7.29673927418015E-03  -2.26974395595386E-03   0.00000000000000E+00   5.53026662485476E-15
     -1.97178350121701E-24  -1.59551979780699E-08  -1.59551924478033E-08   4.89401164639726E-19
      4.31621571874999E-07
      0.00000000000000E+00  -1.59401133660523E-11   0.00000000000000E+00  -3.16920697443153E-16   2.03707173575418E-24
      1.59400885371302E-08   1.59400882202095E-08   9.58577392517448E-20  -6.63130930690087E-01  -6.63130930690094E-01
      0.00000000000000E+00   0.00000000000000E+00   7.61617400367895E-12   0.00000000000000E+00   7.61617400367895E-12
     -5.72444385193897E-19  -7.29194325120487E-03  -2.26730756638104E-03   0.00000000000000E+00  -1.89314506643132E-15
     -1.97598807574140E-24  -1.59477025010681E-08  -1.59477043942131E-08   4.76586645942153E-19
      4.33621571874999E-07
      0.00000000000000E+00  -1.58705868999862E-11   0.00000000000000E+00  -5.05728000280034E-16   2.06739582256226E-24
      1.58706507500383E-08   1.58706502443103E-08   7.43548300866821E-20  -6.51860844680995E-01  -6.51860844681062E-01
      0.00000000000000E+00   0.00000000000000E+00   6.71166121452223E-11   0.00000000000000E+00   6.71166121452223E-11
     -4.38211160903453E-19  -7.30486075931166E-03  -2.28335681254562E-03   0.00000000000000E+00  -1.08093724541769E-14
     -2.02574015819549E-24  -1.59377560470831E-08  -1.59377668564556E-08   3.63856330816771E-19
      4.35621571874999E-07
      0.00000000000000E+00  -1.57813138154205E-11   0.00000000000000E+00  -2.49029359675592E-15   2.14684105276294E-24
      1.57813220559293E-08   1.57813195656358E-08   2.75248532584514E-20  -6.27723510418419E-01  -6.27723510418561E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41815487766700E-10   0.00000000000000E+00   1.41815487766700E-10
     -1.54580185370053E-19  -7.34440807407902E-03  -2.32751513227028E-03   0.00000000000000E+00  -2.12612556278578E-14
     -2.14687022218360E-24  -1.59231137921468E-08  -1.59231350534024E-08   1.27055332111602E-19
      4.37621571874999E-07
      0.00000000000000E+00  -1.56424445727627E-11   0.00000000000000E+00  -3.84049479922324E-15   2.33911449808064E-24
      1.56424595374787E-08   1.56424556969839E-08  -5.36228971340755E-20  -5.87279457375962E-01  -5.87279457376192E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30801521570288E-10   0.00000000000000E+00   2.30801521570288E-10
      3.07022857770522E-19  -7.47904353217073E-03  -2.47786831589065E-03   0.00000000000000E+00  -3.81922257978393E-14
     -2.44138041587634E-24  -1.58732190263284E-08  -1.58732572185542E-08  -2.53399960636447E-19
      4.39621571874999E-07
      0.00000000000000E+00  -1.54159554508090E-11   0.00000000000000E+00  -6.30562108822569E-15   2.80972130720090E-24
      1.54159121363041E-08   1.54159058306830E-08  -1.82740006528819E-19  -5.26784301312143E-01  -5.26784301312468E-01
      0.00000000000000E+00   0.00000000000000E+00   3.24410642421589E-10   0.00000000000000E+00   3.24410642421589E-10
      9.55844142613700E-19  -7.86931710427294E-03  -2.91003291567206E-03   0.00000000000000E+00  -6.58102525065870E-14
     -3.23055985672760E-24  -1.57402506628521E-08  -1.57403164731046E-08  -7.73104136084880E-19
      4.41621571874999E-07
      0.00000000000000E+00  -1.48151071799973E-11   0.00000000000000E+00  -1.61440878436097E-14   4.15633206999004E-24
      1.48150921974552E-08   1.48150760533674E-08  -3.78369790020446E-19  -4.43379876666900E-01  -4.43379876667291E-01
      0.00000000000000E+00   0.00000000000000E+00   3.90452693314592E-10   0.00000000000000E+00   3.90452693314592E-10
      1.73674952924288E-18  -9.29551279798884E-03  -4.50473662067866E-03   0.00000000000000E+00  -1.17163030145970E-13
     -6.44723185868971E-24  -1.52054115836518E-08  -1.52055287466820E-08  -1.35837973922244E-18
      4.43621571874999E-07
      0.00000000000000E+00  -1.07792657376242E-11   0.00000000000000E+00  -1.02239662188707E-13   4.93965675214428E-24
      1.07793509426463E-08   1.07792487029841E-08  -6.38610170254977E-19  -3.36669253680446E-01  -3.36669253680845E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98989285496190E-10   0.00000000000000E+00   3.98989285496190E-10
      2.53472810023526E-18  -1.85611696797725E-02  -1.50392876550361E-02   0.00000000000000E+00  -2.04742174663288E-13
     -3.49450489804774E-23  -1.11780332463056E-08  -1.11782379884803E-08  -1.89611792998029E-18
      4.45621571874999E-07
      0.00000000000000E+00  -1.42947148989795E-12   0.00000000000000E+00  -2.35525435575857E-13  -3.15485284382181E-23
      1.42973813471009E-09   1.42950260927448E-09  -9.04464313719642E-19  -2.13022219377287E-01  -2.13022219377693E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06595818783631E-10   0.00000000000000E+00   4.06595818783631E-10
      3.34791973780252E-18  -4.58913818943513E-02  -4.53128973348787E-02   0.00000000000000E+00  -4.83917121282482E-13
     -8.34358366497738E-23  -1.83561451093675E-09  -1.83609842805811E-09  -2.44345542408288E-18
      4.47621571874999E-07
      0.00000000000000E+00   5.51986870617236E-14   0.00000000000000E+00  -4.39886823760119E-14  -4.48272522794660E-23
     -5.51491223288000E-11  -5.51931110112208E-11  -1.14675620765076E-18  -9.41620095233129E-02  -9.41620095236635E-02
      0.00000000000000E+00   0.00000000000000E+00   3.50560688473470E-10   0.00000000000000E+00   3.50560688473470E-10
      4.04904111474946E-18  -7.56805138003783E-02  -7.55874552177178E-02   0.00000000000000E+00  -1.18422682122229E-12
     -9.59985684487427E-23  -2.94183350640931E-10  -2.95367577462249E-10  -2.90228490709871E-18
      4.49621571874999E-07
      0.00000000000000E+00   5.93317002360623E-14   0.00000000000000E+00  -4.45383451014108E-15  -4.62125464330506E-23
     -5.93038499368700E-11  -5.93083037714263E-11  -1.26523346951027E-18  -3.50933030102436E-02  -3.50933030104473E-02
      0.00000000000000E+00   0.00000000000000E+00   2.03666247854080E-10   0.00000000000000E+00   2.03666247854080E-10
      4.45637361045762E-18  -1.05162291805563E-01  -1.05116810522656E-01   0.00000000000000E+00  -9.97663199408391E-13
     -1.03640596801830E-22  -1.43360280883142E-10  -1.44357944082654E-10  -3.19114014094735E-18
      4.50621571874999E-07
      0.00000000000000E+00   3.10435211761440E-14   0.00000000000000E+00  -2.30469590189184E-16  -4.64198307643175E-23
     -3.10054651151900E-11  -3.10056955848266E-11  -1.29522938890494E-18  -2.08729160096354E-02  -2.08729160097728E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37434025858827E-10   0.00000000000000E+00   1.37434025858827E-10
      4.59380763631645E-18  -1.19788284428066E-01  -1.19754753428468E-01   0.00000000000000E+00  -6.94172224604665E-13
     -1.05867957629965E-22  -1.05734158049291E-10  -1.06428330274002E-10  -3.29857824741151E-18
      4.51971571874999E-07
      0.00000000000000E+00   7.53126845101719E-15   0.00000000000000E+00   8.63531628391219E-16  -4.63878487881107E-23
     -7.54078897892946E-12  -7.53992544734745E-12  -1.31225003317920E-18  -1.35274408685572E-02  -1.35274408686509E-02
      0.00000000000000E+00   0.00000000000000E+00   9.37039874827243E-11   0.00000000000000E+00   9.37039874827243E-11
      4.72030801941813E-18  -1.39284729652974E-01  -1.39257583280098E-01   0.00000000000000E+00  -4.76023754054015E-13
     -1.07802763358130E-22  -8.56880382812144E-11  -8.61640620353762E-11  -3.40805798623893E-18
      4.53794071874999E-07
      0.00000000000000E+00  -1.12050579393183E-14   0.00000000000000E+00   9.86394517426155E-16  -4.60598652340060E-23
      1.12292314231033E-11   1.12302178175747E-11  -1.31968855545741E-18  -1.03218647804123E-02  -1.03218647804791E-02
      0.00000000000000E+00   0.00000000000000E+00   6.68440059736419E-11   0.00000000000000E+00   6.68440059736419E-11
      4.84213122030509E-18  -1.65123302877130E-01  -1.65098705434276E-01   0.00000000000000E+00  -4.08889259234072E-13
     -1.09939161336053E-22  -7.76653345318715E-11  -7.80742237912156E-11  -3.52244266484768E-18
      4.55794071874999E-07
      0.00000000000000E+00  -2.55328369436924E-14   0.00000000000000E+00   8.05871979661551E-16  -4.51961109477698E-23
      2.55564293734032E-11   2.55572352453377E-11  -1.32092606823453E-18  -9.07152772964922E-03  -9.07152772970083E-03
      0.00000000000000E+00   0.00000000000000E+00   5.16092609026268E-11   0.00000000000000E+00   5.16092609026268E-11
      4.94534974211035E-18  -1.92893926037501E-01  -1.92869614754800E-01   0.00000000000000E+00  -4.13084640036044E-13
     -1.12210418890662E-22  -7.67534115078168E-11  -7.71664961479650E-11  -3.62442367387582E-18
      4.57794071874999E-07
      0.00000000000000E+00  -3.69215843574258E-14   0.00000000000000E+00   6.22653983079870E-16  -4.33689030562447E-23
      3.69541879529925E-11   3.69548106069322E-11  -1.31936096667215E-18  -8.49127470122419E-03  -8.49127470126658E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23960764877972E-11   0.00000000000000E+00   4.23960764877972E-11
      5.03014189508594E-18  -2.20089643077207E-01  -2.20064643791820E-01   0.00000000000000E+00  -4.33310033280208E-13
     -1.14509388326187E-22  -7.89175770613343E-11  -7.93508870947291E-11  -3.71078092841380E-18
      4.59794071874999E-07
      0.00000000000000E+00  -4.67489712386311E-14   0.00000000000000E+00   4.90027991242490E-16  -4.00080327958937E-23
      4.67225873021661E-11   4.67230773301173E-11  -1.31664838559157E-18  -8.14686234084488E-03  -8.14686234088116E-03
      0.00000000000000E+00   0.00000000000000E+00   3.62844457732701E-11   0.00000000000000E+00   3.62844457732701E-11
      5.10271078663248E-18  -2.46725240244185E-01  -2.46699089157161E-01   0.00000000000000E+00  -4.53601535621843E-13
     -1.16843221671601E-22  -8.25539215676486E-11  -8.30075231033873E-11  -3.78606240104091E-18
      4.61794071874999E-07
      0.00000000000000E+00  -5.54742212733462E-14   0.00000000000000E+00   4.01846372017357E-16  -3.44953973296102E-23
      5.54841394100000E-11   5.54845412563376E-11  -1.31353408576585E-18  -7.91007399129904E-03  -7.91007399133106E-03
      0.00000000000000E+00   0.00000000000000E+00   3.20165644746392E-11   0.00000000000000E+00   3.20165644746392E-11
      5.16674391558176E-18  -2.72814340197276E-01  -2.72786773667031E-01   0.00000000000000E+00  -4.71755050518320E-13
     -1.19204631206264E-22  -8.70293506803388E-11  -8.75011057309763E-11  -3.85320982981590E-18
      4.63794071874999E-07
      0.00000000000000E+00  -6.35565581476085E-14   0.00000000000000E+00   3.43956166390944E-16  -2.62567475371092E-23
      6.35770643984483E-11   6.35774083545885E-11  -1.31036954929167E-18  -7.73435859427178E-03  -7.73435859430070E-03
      0.00000000000000E+00   0.00000000000000E+00   2.89189669202933E-11   0.00000000000000E+00   2.89189669202933E-11
      5.22458184942235E-18  -2.98364939201809E-01  -2.98335799210439E-01   0.00000000000000E+00  -4.88654996349810E-13
     -1.21588939498563E-22  -9.20077202784107E-11  -9.24963752748821E-11  -3.91421230013067E-18
      4.65794071874999E-07
      0.00000000000000E+00  -7.11796713358332E-14   0.00000000000000E+00   3.05723987840570E-16  -1.49192803230835E-23
      7.12173330777888E-11   7.12176388017617E-11  -1.30731468047103E-18  -7.59783028847326E-03  -7.59783028849984E-03
      0.00000000000000E+00   0.00000000000000E+00   2.65786065889372E-11   0.00000000000000E+00   2.65786065889372E-11
      5.27773906260022E-18  -3.23380225179922E-01  -3.23349415800263E-01   0.00000000000000E+00  -5.05699541994514E-13
     -1.23996818713193E-22  -9.72905458485803E-11  -9.77962453906988E-11  -3.97042438212919E-18
      4.67794071874999E-07
      0.00000000000000E+00  -7.85272503124354E-14   0.00000000000000E+00   2.80170940230008E-16  -5.15494788576856E-25
      7.85544410760650E-11   7.85547212470048E-11  -1.30443224664315E-18  -7.48815463898742E-03  -7.48815463901215E-03
      0.00000000000000E+00   0.00000000000000E+00   2.47346006648775E-11   0.00000000000000E+00   2.47346006648775E-11
      5.32720826392998E-18  -3.47868805488160E-01  -3.47836265887750E-01   0.00000000000000E+00  -5.24355898144067E-13
     -1.26434537331818E-22  -1.02764966013613E-10  -1.03289321911883E-10  -4.02277601728682E-18
      4.69794071874999E-07
      0.00000000000000E+00  -8.56911398146225E-14   0.00000000000000E+00   2.64777136581447E-16   1.59070765962373E-23
      8.57268807349832E-11   8.57271455121357E-11  -1.30171164968027E-18  -7.41052063494837E-03  -7.41052063497154E-03
      0.00000000000000E+00   0.00000000000000E+00   2.31774982224314E-11   0.00000000000000E+00   2.31774982224314E-11
      5.37356326037484E-18  -3.71824084244140E-01  -3.71789775949209E-01   0.00000000000000E+00  -5.44813172384187E-13
     -1.28907592629629E-22  -1.08359830562053E-10  -1.08904643734566E-10  -4.07185161069458E-18
      4.71794071874999E-07
      0.00000000000000E+00  -9.27631845796020E-14   0.00000000000000E+00   2.55036597093996E-16   3.29159877570385E-23
      9.28087320897108E-11   9.28089871263408E-11  -1.29913457343642E-18  -7.36411712023245E-03  -7.36411712025429E-03
      0.00000000000000E+00   0.00000000000000E+00   2.18367616621696E-11   0.00000000000000E+00   2.18367616621696E-11
      5.41723678369918E-18  -3.95277616256380E-01  -3.95241499681405E-01   0.00000000000000E+00  -5.69059579650567E-13
     -1.31428375202132E-22  -1.14076689208729E-10  -1.14645748788511E-10  -4.11810221026276E-18
      4.73794071874999E-07
      0.00000000000000E+00  -9.98352293445816E-14   0.00000000000000E+00   2.46747437136955E-16   4.95605932133457E-23
      9.98175397484209E-11   9.98177864959076E-11  -1.29670849605005E-18  -7.32995944750533E-03  -7.32995944752609E-03
      0.00000000000000E+00   0.00000000000000E+00   2.07657427345120E-11   0.00000000000000E+00   2.07657427345120E-11
      5.45876826916820E-18  -4.18384144570335E-01  -4.18346157799590E-01   0.00000000000000E+00  -6.02362683119909E-13
     -1.34028791913451E-22  -1.19981166547165E-10  -1.20583529230419E-10  -4.16205977311815E-18
      4.75794071874999E-07
      0.00000000000000E+00  -1.06723584635146E-13   0.00000000000000E+00   2.40063850076967E-16   6.50063689015796E-23
      1.06767241743342E-10   1.06767481807257E-10  -1.29442195702211E-18  -7.30600223890175E-03  -7.30600223892150E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97445499924269E-11   0.00000000000000E+00   1.97445499924269E-11
      5.49825736915305E-18  -4.41095286084445E-01  -4.41055432094668E-01   0.00000000000000E+00  -6.37785638471753E-13
     -1.36705535905444E-22  -1.25874246161076E-10  -1.26512031799684E-10  -4.20383541213095E-18
      4.75919071874999E-07
      0.00000000000000E+00  -1.07182808321184E-13   0.00000000000000E+00   2.41813687244872E-16   6.60117617590939E-23
      1.07207756893733E-10   1.07207998707486E-10  -1.29427986036897E-18  -7.30454075291372E-03  -7.30454075293335E-03
      0.00000000000000E+00   0.00000000000000E+00   1.96220598927461E-11   0.00000000000000E+00   1.96220598927461E-11
      5.50071012663965E-18  -4.42512866674011E-01  -4.42472912515949E-01   0.00000000000000E+00  -6.55783288827063E-13
     -1.36874334238625E-22  -1.26174275311277E-10  -1.26830058600241E-10  -4.20643026627068E-18
      4.76087821874999E-07
      0.00000000000000E+00  -1.07825721481636E-13   0.00000000000000E+00   2.41848490781163E-16   6.73679247249460E-23
      1.07804058176965E-10   1.07804300025523E-10  -1.29408905425501E-18  -7.30264043500555E-03  -7.30264043502508E-03
      0.00000000000000E+00   0.00000000000000E+00   1.95314920980850E-11   0.00000000000000E+00   1.95314920980850E-11
      5.50400606593120E-18  -4.44423664906428E-01  -4.44383551467226E-01   0.00000000000000E+00  -6.58536498704823E-13
     -1.37103002742894E-22  -1.26677255624752E-10  -1.27335792123594E-10  -4.20991701167620E-18
      4.76315634374999E-07
      0.00000000000000E+00  -1.08652324116504E-13   0.00000000000000E+00   2.40849589256160E-16   6.91768328000575E-23
      1.08607122651169E-10   1.08607363500827E-10  -1.29383331504269E-18  -7.30021274775805E-03  -7.30021274777746E-03
      0.00000000000000E+00   0.00000000000000E+00   1.94077600747388E-11   0.00000000000000E+00   1.94077600747388E-11
      5.50842739627323E-18  -4.46997697328926E-01  -4.46957369934555E-01   0.00000000000000E+00  -6.62584125993840E-13
     -1.37412833985329E-22  -1.27352539449448E-10  -1.28015123575580E-10  -4.21459408123054E-18
      4.76623181249999E-07
      0.00000000000000E+00  -1.09662616225787E-13   0.00000000000000E+00   2.39569937574345E-16   7.15623160516906E-23
      1.09687918458682E-10   1.09688158028691E-10  -1.29349135824802E-18  -7.29719851525452E-03  -7.29719851527376E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92414442102131E-11   0.00000000000000E+00   1.92414442102131E-11
      5.51434504231057E-18  -4.50462243616873E-01  -4.50421628209231E-01   0.00000000000000E+00  -6.68145670203044E-13
     -1.37832894447886E-22  -1.28261456568565E-10  -1.28929602238906E-10  -4.22085368406254E-18
      4.77038369531249E-07
      0.00000000000000E+00  -1.11132132021107E-13   0.00000000000000E+00   2.37957591622510E-16   7.46685550774080E-23
      1.11141323155071E-10   1.11141561112737E-10  -1.29303548996795E-18  -7.29363568353043E-03  -7.29363568354945E-03
      0.00000000000000E+00   0.00000000000000E+00   1.90202282314915E-11   0.00000000000000E+00   1.90202282314915E-11
      5.52224201817898E-18  -4.55120032511911E-01  -4.55079029031853E-01   0.00000000000000E+00  -6.75623844488684E-13
     -1.38402960681228E-22  -1.29486165499600E-10  -1.30161789344227E-10  -4.22920652821103E-18
      4.77598873710936E-07
      0.00000000000000E+00  -1.13060871502465E-13   0.00000000000000E+00   2.35974246583146E-16   7.86501911923916E-23
      1.13094004762209E-10   1.13094240736534E-10  -1.29243001622308E-18  -7.28981075516146E-03  -7.28981075518019E-03
      0.00000000000000E+00   0.00000000000000E+00   1.87283217681155E-11   0.00000000000000E+00   1.87283217681155E-11
      5.53273932080854E-18  -4.61372353236070E-01  -4.61330826706596E-01   0.00000000000000E+00  -6.85662184078816E-13
     -1.39177580430793E-22  -1.31136900320435E-10  -1.31822562504653E-10  -4.24030930458547E-18
      4.78355554353514E-07
      0.00000000000000E+00  -1.15724368881484E-13   0.00000000000000E+00   2.33615924428355E-16   8.36473561368322E-23
      1.15715025852916E-10   1.15715259468925E-10  -1.29162933831051E-18  -7.28659959248258E-03  -7.28659959250092E-03
      0.00000000000000E+00   0.00000000000000E+00   1.83459594406553E-11   0.00000000000000E+00   1.83459594406553E-11
      5.54662135318681E-18  -4.69747727626403E-01  -4.69705496055118E-01   0.00000000000000E+00  -6.99194006279107E-13
     -1.40231697758943E-22  -1.33362024903156E-10  -1.34061218909575E-10  -4.25499201487631E-18
      4.79377073220995E-07
      0.00000000000000E+00  -1.19214468895370E-13   0.00000000000000E+00   2.30947646449751E-16   8.97395016390750E-23
      1.19230581438349E-10   1.19230812386085E-10  -1.29057538639500E-18  -7.28627711014836E-03  -7.28627711016621E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78485521725496E-11   0.00000000000000E+00   1.78485521725496E-11
      5.56485398598828E-18  -4.80936155496859E-01  -4.80892973406437E-01   0.00000000000000E+00  -7.17508642159379E-13
     -1.41668248247767E-22  -1.36361855916335E-10  -1.37079364558636E-10  -4.27427859959328E-18
      4.80756123692094E-07
      0.00000000000000E+00  -1.23990395230161E-13   0.00000000000000E+00   2.28267995561748E-16   9.68798370250469E-23
      1.23946797519526E-10   1.23947025787619E-10  -1.28919280492835E-18  -7.29468512175299E-03  -7.29468512177020E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72053942087062E-11   0.00000000000000E+00   1.72053942087062E-11
      5.58858109297723E-18  -4.95827530364560E-01  -4.95783065554460E-01   0.00000000000000E+00  -7.42277832710166E-13
     -1.43627589229626E-22  -1.40410142163471E-10  -1.41152419996325E-10  -4.29938828804888E-18
      4.82617841828077E-07
      0.00000000000000E+00  -1.30327682097480E-13   0.00000000000000E+00   2.26630458319402E-16   1.04839731176135E-22
      1.30296711420380E-10   1.30296938050943E-10  -1.28737438283329E-18  -7.32829313791887E-03  -7.32829313793525E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63770775550969E-11   0.00000000000000E+00   1.63770775550969E-11
      5.61907059527596E-18  -5.15550063723904E-01  -5.15503860057646E-01   0.00000000000000E+00  -7.75324715230074E-13
     -1.46296281370746E-22  -1.45898690890663E-10  -1.46674015606039E-10  -4.33169621244267E-18
      4.84617841828077E-07
      0.00000000000000E+00  -1.37399726862460E-13   0.00000000000000E+00   2.35890315878276E-16   1.11939875104092E-22
      1.37358370388445E-10   1.37358606278873E-10  -1.28536321505452E-18  -7.43713513315513E-03  -7.43713513317058E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54444865840202E-11   0.00000000000000E+00   1.54444865840202E-11
      5.64995956844400E-18  -5.36306309982720E-01  -5.36258176203886E-01   0.00000000000000E+00  -8.11631929595790E-13
     -1.49165811438925E-22  -1.51991460933150E-10  -1.52803092862895E-10  -4.36459635338948E-18
      4.86617841828077E-07
      0.00000000000000E+00  -1.45482063736722E-13   0.00000000000000E+00   2.79846293973153E-16   1.18361145216776E-22
      1.45466498278930E-10   1.45466778125342E-10  -1.28294135308584E-18  -7.77462957163948E-03  -7.77462957165377E-03
      0.00000000000000E+00   0.00000000000000E+00   1.42821326692292E-11   0.00000000000000E+00   1.42821326692292E-11
      5.67852383378246E-18  -5.56639049934996E-01  -5.56588728850109E-01   0.00000000000000E+00  -8.39971035251480E-13
     -1.51993259490464E-22  -1.58908939759168E-10  -1.59748910794571E-10  -4.39558248069662E-18
      4.88617841828077E-07
      0.00000000000000E+00  -1.57881103259738E-13   0.00000000000000E+00   4.57052250410504E-16   1.26223728771783E-22
      1.57876298381213E-10   1.57876755433589E-10  -1.27878139711750E-18  -8.93930835562411E-03  -8.93930835563621E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20960948120980E-11   0.00000000000000E+00   1.20960948120980E-11
      5.70271602340666E-18  -5.76551277784168E-01  -5.76497736903126E-01   0.00000000000000E+00  -8.34785263334156E-13
     -1.54668113959458E-22  -1.69138064982199E-10  -1.69972850245687E-10  -4.42393462628915E-18
      4.90617841828077E-07
      0.00000000000000E+00  -2.08028329775048E-13   0.00000000000000E+00   1.92374420495173E-15   1.53685538204276E-22
      2.08031703617827E-10   2.08033627362185E-10  -1.26129549882025E-18  -1.61994422112932E-02  -1.61994422112937E-02
      0.00000000000000E+00   0.00000000000000E+00   4.07663484186752E-13   0.00000000000000E+00   4.07663484186752E-13
      5.70353135037503E-18  -5.95997381689124E-01  -5.95931724509555E-01   0.00000000000000E+00  -5.54612101354235E-13
     -1.56373689302587E-22  -2.07886678744862E-10  -2.08441290846373E-10  -4.44223585155479E-18
      4.92617841828077E-07
      0.00000000000000E+00  -4.55458051812125E-13   0.00000000000000E+00   8.25707301285553E-15   2.48105393087675E-22
      4.55442287144305E-10   4.55450544217566E-10  -1.19987908668102E-18  -4.24214414808457E-02  -4.24214414808086E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.70819821146917E-11   0.00000000000000E+00  -3.70819821146917E-11
      5.62936738614564E-18  -6.14654860124489E-01  -6.14523078765518E-01   0.00000000000000E+00   3.80682502611862E-13
     -1.55198827841553E-22  -4.18749244605331E-10  -4.18368562102874E-10  -4.42948829946463E-18
      4.94617841828077E-07
      0.00000000000000E+00  -9.77411693362500E-13   0.00000000000000E+00   1.48990553695626E-14   3.23522296022210E-22
      9.77407315118161E-10   9.77422214173854E-10  -1.12580894696126E-18  -7.22036242383731E-02  -7.22036242383209E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.21607563767228E-11   0.00000000000000E+00  -5.21607563767228E-11
      5.52504587339220E-18  -6.31964435657001E-01  -6.31672986187959E-01   0.00000000000000E+00   5.00075889727525E-13
     -1.53615606364116E-22  -9.25761533686702E-10  -9.25261457797129E-10  -4.39923692643094E-18
      4.96617841828077E-07
      0.00000000000000E+00  -1.97567214207111E-12   0.00000000000000E+00   2.63210869613633E-14   3.69913285270170E-22
      1.97561989297827E-09   1.97564621406561E-09  -1.05280380802190E-18  -1.01736362598305E-01  -1.01736362598244E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19159540364406E-11   0.00000000000000E+00  -6.19159540364406E-11
      5.40121396531932E-18  -6.47019631632729E-01  -6.46416818197523E-01   0.00000000000000E+00   4.25248847855336E-13
     -1.52211788596704E-22  -1.91415550887687E-09  -1.91373026002916E-09  -4.34841015729741E-18
      4.98617841828077E-07
      0.00000000000000E+00  -3.72283457796989E-12   0.00000000000000E+00   4.45507931521981E-14   4.05123256725129E-22
      3.72276813400454E-09   3.72281268479810E-09  -9.85789357960191E-19  -1.30776947884170E-01  -1.30776947884096E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.38252940046866E-11   0.00000000000000E+00  -7.38252940046866E-11
      5.25356337730994E-18  -6.58417921704484E-01  -6.57268505796662E-01   0.00000000000000E+00   3.28892259163188E-13
     -1.51064098596563E-22  -3.64931628305242E-09  -3.64898739079341E-09  -4.26777401934976E-18
      5.00617841828077E-07
      0.00000000000000E+00  -6.47404368102135E-12   0.00000000000000E+00   6.91208134679363E-14   4.32873576199624E-22
      6.47401596510704E-09   6.47408508592094E-09  -9.26122555554350E-19  -1.59252621061620E-01  -1.59252621061531E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.86940076404461E-11   0.00000000000000E+00  -8.86940076404461E-11
      5.07617536202905E-18  -6.64291098218393E-01  -6.62279716199626E-01   0.00000000000000E+00   2.46929089573430E-13
     -1.50133578115797E-22  -6.38563800736991E-09  -6.38539107828048E-09  -4.15005280647470E-18
      5.02617841828077E-07
      0.00000000000000E+00  -1.04139073730126E-11   0.00000000000000E+00   9.82898438278884E-14   4.50584152200638E-22
      1.04138021509850E-08   1.04139004408293E-08  -8.72662131890314E-19  -1.87145390267111E-01  -1.87145390267007E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04685178752659E-10   0.00000000000000E+00  -1.04685178752659E-10
      4.86680500452373E-18  -6.62445782259511E-01  -6.59198386507154E-01   0.00000000000000E+00   2.68364736929553E-13
     -1.49071658416204E-22  -1.03094836268135E-08  -1.03092152620767E-08  -3.99414287263342E-18
      5.04617841828077E-07
      0.00000000000000E+00  -1.57074706467056E-11   0.00000000000000E+00   1.31409540528906E-13   4.56287598414022E-22
      1.57073008628870E-08   1.57074322724280E-08  -8.23371083915199E-19  -2.14460642815881E-01  -2.14460642815762E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18943259690562E-10   0.00000000000000E+00  -1.18943259690562E-10
      4.62891848514261E-18  -6.50404038413482E-01  -6.45493626550695E-01   0.00000000000000E+00   4.99759436355845E-13
     -1.47122536357468E-22  -1.55889887721736E-08  -1.55884890127374E-08  -3.80554740122741E-18
      5.06617841828077E-07
      0.00000000000000E+00  -2.25973872978027E-11   0.00000000000000E+00   1.68795544443108E-13   4.49969288384370E-22
      2.25972186397564E-08   2.25973874353013E-08  -7.76399590169650E-19  -2.41212346753135E-01  -2.41212346753005E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29878060205123E-10   0.00000000000000E+00  -1.29878060205123E-10
      4.36916236473236E-18  -6.25258834862920E-01  -6.18181387846619E-01   0.00000000000000E+00   9.81276948676947E-13
     -1.43248171811932E-22  -2.24684906520447E-08  -2.24675093750962E-08  -3.59276277456271E-18
      5.08617841828077E-07
      0.00000000000000E+00  -3.14005216696697E-11   0.00000000000000E+00   2.18405023347763E-13   4.32193209271239E-22
      3.14003123584526E-08   3.14005307634763E-08  -7.30470824290516E-19  -2.67414844401499E-01  -2.67414844401361E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.38125514737199E-10   0.00000000000000E+00  -1.38125514737199E-10
      4.09291133525796E-18  -5.83537938789187E-01  -5.73689748364505E-01   0.00000000000000E+00   1.59313017972730E-12
     -1.36456078957575E-22  -3.12639983789187E-08  -3.12624052487391E-08  -3.36244051096745E-18
      5.10617841828077E-07
      0.00000000000000E+00  -4.22740201076688E-11   0.00000000000000E+00   2.69891069285466E-13   3.99835136706347E-22
      4.22737538495972E-08   4.22740237406669E-08  -6.84980181012194E-19  -2.93077656565752E-01  -2.93077656565605E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46432177414575E-10   0.00000000000000E+00  -1.46432177414575E-10
      3.80004698042881E-18  -5.21513237359132E-01  -5.08241830953149E-01   0.00000000000000E+00   2.05569261161365E-12
     -1.26559710200002E-22  -4.21296472558638E-08  -4.21275915632523E-08  -3.11506679941662E-18
      5.12617841828077E-07
      0.00000000000000E+00  -5.47153082098004E-11   0.00000000000000E+00   3.09192160196184E-13   3.39900791206135E-22
      5.47150104637545E-08   5.47153196559151E-08  -6.39946569117612E-19  -3.18204287131680E-01  -3.18204287131522E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58006076731666E-10   0.00000000000000E+00  -1.58006076731666E-10
      3.48403482696548E-18  -4.36454651195019E-01  -4.19266853280383E-01   0.00000000000000E+00   2.08684713385114E-12
     -1.15065360090613E-22  -5.45594004263172E-08  -5.45573135791834E-08  -2.84408825784787E-18
      5.14617841828077E-07
      0.00000000000000E+00  -6.74035668102830E-11   0.00000000000000E+00   3.15908657750920E-13   2.64920116988002E-22
      6.74032144725190E-08   6.74035303811770E-08  -5.95411023541727E-19  -3.42802330036504E-01  -3.42802330036333E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.70855147533195E-10   0.00000000000000E+00  -1.70855147533195E-10
      3.14232453189909E-18  -3.28223601911063E-01  -3.07041785237338E-01   0.00000000000000E+00   1.82982274554502E-12
     -1.02511359416598E-22  -6.72345050563893E-08  -6.72326752336438E-08  -2.54691350835736E-18
      5.16617841828077E-07
      0.00000000000000E+00  -7.66959580972545E-11   0.00000000000000E+00   2.31898293790597E-13   1.98295678746878E-22
      7.66957207325160E-08   7.66959526308100E-08  -5.51729316972519E-19  -3.66870594212783E-01  -3.66870594212594E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89465571702460E-10   0.00000000000000E+00  -1.89465571702460E-10
      2.76339338849417E-18  -2.03941780192968E-01  -1.79837552568987E-01   0.00000000000000E+00   1.29830340351058E-12
     -8.78185650504303E-23  -7.65077853625110E-08  -7.65064870591076E-08  -2.21166407152165E-18
      5.18617841828078E-07
      0.00000000000000E+00  -7.37949502278176E-11   0.00000000000000E+00  -7.17995473335961E-14   8.39837639155031E-23
      7.37950225288211E-08   7.37949507292739E-08  -5.08349905658513E-19  -3.90414991484875E-01  -3.90414991484665E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10245133442467E-10   0.00000000000000E+00  -2.10245133442467E-10
      2.34290312160924E-18  -8.77026733802855E-02  -6.45186483022680E-02   0.00000000000000E+00   8.14099644317154E-13
     -6.49706027914770E-23  -7.35855196954758E-08  -7.35847055958315E-08  -1.83455321595072E-18
      5.20617841828078E-07
      0.00000000000000E+00  -4.34402645807300E-11   0.00000000000000E+00  -7.53503094115144E-13   2.29948865188006E-23
      4.34409821939572E-08   4.34402286908631E-08  -4.54051226823387E-19  -4.13592919372459E-01  -4.13592919372303E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55784910474112E-10   0.00000000000000E+00  -1.55784910474112E-10
      2.03133330066101E-18  -3.28651940400274E-02  -1.92276811757547E-02   0.00000000000000E+00   9.69037331688106E-13
     -2.23993442424781E-23  -4.32854128177206E-08  -4.32844437803889E-08  -1.57728207383763E-18
      5.22617841828078E-07
      0.00000000000000E+00  -2.46311971585261E-11   0.00000000000000E+00  -4.64867774799975E-13   8.77426904377933E-24
      2.46316322951281E-08   2.46311674273533E-08  -3.96487270417386E-19  -4.36392778846307E-01  -4.36392778846197E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10877889621259E-10   0.00000000000000E+00  -1.10877889621259E-10
      1.80957752141849E-18  -1.57251158206089E-02  -7.99956056999723E-03   0.00000000000000E+00   5.42259006538627E-13
     -9.49638215077639E-24  -2.45208317967385E-08  -2.45202895377320E-08  -1.41309025100111E-18
      5.24617841828078E-07
      0.00000000000000E+00  -1.85445545790461E-11   0.00000000000000E+00  -1.49893776726845E-13   5.22091090211264E-24
      1.85446674065608E-08   1.85445175127840E-08  -3.41266631448157E-19  -4.58754686180817E-01  -4.58754686180717E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00337642522836E-10   0.00000000000000E+00  -1.00337642522836E-10
      1.60890223637282E-18  -1.07629337364150E-02  -4.95175907686284E-03   0.00000000000000E+00   1.98001774391718E-13
     -5.81569668967228E-24  -1.84443778720356E-08  -1.84441798702612E-08  -1.26763560492467E-18
      5.26617841828078E-07
      0.00000000000000E+00  -1.68558972407486E-11   0.00000000000000E+00  -4.13139863474966E-14   4.01543389861082E-24
      1.68558507138050E-08   1.68558093998187E-08  -2.88660091854182E-19  -4.80666659622610E-01  -4.80666659622510E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00306053696799E-10   0.00000000000000E+00  -1.00306053696799E-10
      1.40829012897922E-18  -9.17487179436270E-03  -3.89574108841118E-03   0.00000000000000E+00   7.95027257015455E-14
     -4.45384663947166E-24  -1.67555828488476E-08  -1.67555033461219E-08  -1.11963003712504E-18
      5.28617841828078E-07
      0.00000000000000E+00  -1.63887749073111E-11   0.00000000000000E+00  -1.12005378067174E-14   3.43083482478837E-24
      1.63887864072938E-08   1.63887752067560E-08  -2.38572059859964E-19  -5.02133087432379E-01  -5.02133087432277E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02526343759530E-10   0.00000000000000E+00  -1.02526343759530E-10
      1.20323744146016E-18  -8.51850286447720E-03  -3.38721596224567E-03   0.00000000000000E+00   4.39801582010956E-14
     -3.74955651915721E-24  -1.62862928431546E-08  -1.62862488629964E-08  -9.64665381600201E-19
      5.30617841828078E-07
      0.00000000000000E+00  -1.62409967251442E-11   0.00000000000000E+00  -3.35485771960485E-15   3.06466720293866E-24
      1.62410255121508E-08   1.62410221572931E-08  -1.90905173113400E-19  -5.23162472813624E-01  -5.23162472813519E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04808256878912E-10   0.00000000000000E+00  -1.04808256878912E-10
      9.93620927702340E-19  -8.15656976465479E-03  -3.07255121229287E-03   0.00000000000000E+00   3.22950533369106E-14
     -3.28824046389984E-24  -1.61362461954675E-08  -1.61362139004142E-08  -8.02715754588940E-19
      5.32617841828078E-07
      0.00000000000000E+00  -1.61805628880616E-11   0.00000000000000E+00  -1.22896102073752E-15   2.80298090518107E-24
      1.61805447168234E-08   1.61805434878624E-08  -1.45530937710488E-19  -5.43763445602972E-01  -5.43763445602866E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06625892144790E-10   0.00000000000000E+00  -1.06625892144790E-10
      7.80369143412760E-19  -7.91517023101285E-03  -2.85077708578488E-03   0.00000000000000E+00   2.71678578011840E-14
     -2.95083390144563E-24  -1.60739447635754E-08  -1.60739175957176E-08  -6.34838205702272E-19
      5.34617841828078E-07
      0.00000000000000E+00  -1.61483253853018E-11   0.00000000000000E+00  -5.54020821507631E-16   2.60332349169747E-24
      1.61483480658401E-08   1.61483475118193E-08  -1.02294266601749E-19  -5.63942963565730E-01  -5.63942963565622E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07888679289491E-10   0.00000000000000E+00  -1.07888679289491E-10
      5.64591784833779E-19  -7.73782292724941E-03  -2.68396974164173E-03   0.00000000000000E+00   2.40640896192358E-14
     -2.69100466729315E-24  -1.60404828966194E-08  -1.60404588325298E-08  -4.62297518232029E-19
      5.36617841828078E-07
      0.00000000000000E+00  -1.61280276983789E-11   0.00000000000000E+00  -2.81213764044903E-16   2.44505828927777E-24
      1.61279913780330E-08   1.61279910968192E-08  -6.10497713753832E-20  -5.83696989693089E-01  -5.83696989692980E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08571731295042E-10   0.00000000000000E+00  -1.08571731295042E-10
      3.47448322243694E-19  -7.60047867427623E-03  -2.55325263217276E-03   0.00000000000000E+00   2.17875193550082E-14
     -2.48463284231192E-24  -1.60194411530435E-08  -1.60194193655242E-08  -2.86398550868311E-19
      5.38617841828078E-07
      0.00000000000000E+00  -1.61131488509513E-11   0.00000000000000E+00  -1.62076584884223E-16   2.31670175868725E-24
      1.61131055467462E-08   1.61131053846696E-08  -2.18951101309103E-20  -6.02900990613730E-01  -6.02900990613622E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08052055784564E-10   0.00000000000000E+00  -1.08052055784564E-10
      1.31344210674566E-19  -7.49028708099882E-03  -2.44758586988593E-03   0.00000000000000E+00   1.98428727798575E-14
     -2.31769430995310E-24  -1.60050731717579E-08  -1.60050533288851E-08  -1.09449100543654E-19
      5.40617841828078E-07
      0.00000000000000E+00  -1.60930348535028E-11   0.00000000000000E+00  -3.10286714098392E-16   2.21807971104107E-24
      1.60930596352616E-08   1.60930593249749E-08   1.45053692135867E-20  -6.21134023283389E-01  -6.21134023283285E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04591162323204E-10   0.00000000000000E+00  -1.04591162323204E-10
     -7.78381139718429E-20  -7.41166256898914E-03  -2.37418562484550E-03   0.00000000000000E+00   1.79570541836739E-14
     -2.19092749829720E-24  -1.59884861197058E-08  -1.59884681626517E-08   6.33327447582561E-20
      5.41617841828078E-07
      0.00000000000000E+00  -1.60770538692287E-11   0.00000000000000E+00  -6.19016428152244E-16   2.17876197274090E-24
      1.60770379791215E-08   1.60770373601051E-08   3.17394007859142E-20  -6.29888619054459E-01  -6.29888619054357E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01674493961014E-10   0.00000000000000E+00  -1.01674493961014E-10
     -1.79512607932857E-19  -7.38491610474476E-03  -2.35156770696581E-03   0.00000000000000E+00   1.69011345212570E-14
     -2.14179977795885E-24  -1.59753797672786E-08  -1.59753628661441E-08   1.47773207146944E-19
      5.42967841828078E-07
      0.00000000000000E+00  -1.60637363823336E-11   0.00000000000000E+00  -3.31409839741698E-16   2.13344875616207E-24
      1.60637261236927E-08   1.60637257922828E-08   5.30309280015249E-20  -6.40813087999414E-01  -6.40813087999319E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.47864831668409E-11   0.00000000000000E+00  -9.47864831668409E-11
     -3.07474360208092E-19  -7.35672810501961E-03  -2.32540292269634E-03   0.00000000000000E+00   1.49202116117473E-14
     -2.08444935575859E-24  -1.59689542293276E-08  -1.59689393091160E-08   2.54443432206568E-19
      5.44790341828078E-07
      0.00000000000000E+00  -1.60438060743596E-11   0.00000000000000E+00  -4.13096417367093E-16   2.08488736777482E-24
      1.60437956758810E-08   1.60437952627846E-08   7.67883538893845E-20  -6.53139905840708E-01  -6.53139905840628E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.99761549192867E-11   0.00000000000000E+00  -7.99761549192867E-11
     -4.53230902548492E-19  -7.32683383508762E-03  -2.29712115799446E-03   0.00000000000000E+00   1.21034101567560E-14
     -2.02410825794863E-24  -1.59638312112754E-08  -1.59638191078653E-08   3.76442548659109E-19
      5.46790341828078E-07
      0.00000000000000E+00  -1.60121196400230E-11   0.00000000000000E+00  -6.99765811906934E-16   2.04917402699368E-24
      1.60120766268003E-08   1.60120759270345E-08   9.40592588891301E-20  -6.62188378417464E-01  -6.62188378417410E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39353047275485E-11   0.00000000000000E+00  -5.39353047275485E-11
     -5.61101512003590E-19  -7.30381371719494E-03  -2.27588964466431E-03   0.00000000000000E+00   7.96768859674473E-15
     -1.98207490876042E-24  -1.59581485899956E-08  -1.59581406223070E-08   4.67042253114459E-19
      5.48790341828078E-07
      0.00000000000000E+00  -1.59665646503681E-11   0.00000000000000E+00  -1.09904213520746E-15   2.03498169241948E-24
      1.59666021589635E-08   1.59666010599214E-08   9.88799219356021E-20  -6.64724875120054E-01  -6.64724875120039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51993470068172E-11   0.00000000000000E+00  -1.51993470068172E-11
     -5.91500206017224E-19  -7.29249564501876E-03  -2.26669465081509E-03   0.00000000000000E+00   2.33793198255191E-15
     -1.96968888254167E-24  -1.59514040508465E-08  -1.59514017129146E-08   4.92620284081622E-19
      5.50790341828078E-07
      0.00000000000000E+00  -1.59052123659134E-11   0.00000000000000E+00  -1.57223869759912E-15   2.04874989437095E-24
      1.59052188970236E-08   1.59052173247849E-08   8.69191632537983E-20  -6.58431965973446E-01  -6.58431965973483E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75751651039721E-11   0.00000000000000E+00   3.75751651039721E-11
     -5.16349875809280E-19  -7.29638039724672E-03  -2.27329224823274E-03   0.00000000000000E+00  -5.18110430349640E-15
     -1.99613313286474E-24  -1.59427873087846E-08  -1.59427924898889E-08   4.29430712555482E-19
      5.52790341828078E-07
      0.00000000000000E+00  -1.58253992892801E-11   0.00000000000000E+00  -2.73335927591676E-14   2.10254837297842E-24
      1.58254376535978E-08   1.58254103200051E-08   5.27508034699774E-20  -6.40655165520299E-01  -6.40655165520404E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05252266166906E-10   0.00000000000000E+00   1.05252266166906E-10
     -3.05845343475467E-19  -7.32209003306322E-03  -2.30281671269422E-03   0.00000000000000E+00   9.86922067842155E-15
     -2.07956897943962E-24  -1.59306724553927E-08  -1.59306625861720E-08   2.53094540005490E-19
      5.54790341828078E-07
      0.00000000000000E+00  -1.57189512388566E-11   0.00000000000000E+00  -5.09918598186368E-15   2.22593720247882E-24
      1.57189739905647E-08   1.57189688913787E-08  -1.11504649429279E-20  -6.08224500586237E-01  -6.08224500586425E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88053474831479E-10   0.00000000000000E+00   1.88053474831479E-10
      7.02616061874903E-20  -7.39188477996478E-03  -2.38006900107409E-03   0.00000000000000E+00  -2.74712788885176E-14
     -2.26729829308261E-24  -1.59069948949313E-08  -1.59070223662102E-08  -5.91111412445626E-20
      5.56790341828078E-07
      0.00000000000000E+00  -1.55336085591718E-11   0.00000000000000E+00  -1.06545149689929E-14   2.53871603850674E-24
      1.55336402568260E-08   1.55336296023110E-08  -1.15992791338770E-19  -5.57457257505769E-01  -5.57457257506050E-01
      0.00000000000000E+00   0.00000000000000E+00   2.81880843266052E-10   0.00000000000000E+00   2.81880843266052E-10
      6.34023292719595E-19  -7.63758260033575E-03  -2.65460246398723E-03   0.00000000000000E+00  -4.54296372451296E-14
     -2.76145089794001E-24  -1.58154650159398E-08  -1.58155104455770E-08  -5.18030501380825E-19
      5.58790341828078E-07
      0.00000000000000E+00  -1.51952525472993E-11   0.00000000000000E+00  -9.35652612756107E-15   3.33729471920010E-24
      1.51951988231411E-08   1.51951894666149E-08  -2.78539771816843E-19  -4.84881613699565E-01  -4.84881613699932E-01
      0.00000000000000E+00   0.00000000000000E+00   3.66493966740786E-10   0.00000000000000E+00   3.66493966740786E-10
      1.36701122620117E-18  -8.37301735193412E-03  -3.47002071934693E-03   0.00000000000000E+00  -8.91991450156418E-14
     -4.30470317596903E-24  -1.55615942342107E-08  -1.55616834333557E-08  -1.08847145438432E-18
      5.60790341828078E-07
      0.00000000000000E+00  -1.36386679411061E-11   0.00000000000000E+00  -4.04138034057290E-14   5.49905191691822E-24
      1.36386839968030E-08   1.36386435829996E-08  -5.13627416258808E-19  -3.88765864853735E-01  -3.88765864854135E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99281118787871E-10   0.00000000000000E+00   3.99281118787871E-10
      2.16557346377691E-18  -1.20700138346946E-02  -7.64712479297411E-03   0.00000000000000E+00  -1.61211854296699E-13
     -1.43778485824309E-23  -1.40377634899331E-08  -1.40379247017874E-08  -1.65194604751810E-18
      5.62790341828078E-07
      0.00000000000000E+00  -4.83617648239953E-12   0.00000000000000E+00  -2.20943699078129E-13  -1.09870773357604E-23
      4.83642040317847E-09   4.83619945947938E-09  -7.82068582181104E-19  -2.71390163928935E-01  -2.71390163929342E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07424120831680E-10   0.00000000000000E+00   4.07424120831680E-10
      2.98042170544027E-18  -3.28742000918886E-02  -3.12221237510772E-02   0.00000000000000E+00  -2.86125357100752E-13
     -7.01374479012524E-23  -5.24333745495389E-09  -5.24362358031106E-09  -2.19835312325916E-18
      5.64790341828078E-07
      0.00000000000000E+00  -1.80750442824413E-13   0.00000000000000E+00  -1.21306633572751E-13  -4.21557788692085E-23
      1.80881411613728E-10   1.80760104980113E-10  -1.04394984373816E-18  -1.45227578950709E-01  -1.45227578951096E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87227243849158E-10   0.00000000000000E+00   3.87227243849158E-10
      3.75487619313858E-18  -6.23932532601822E-02  -6.22143030266906E-02   0.00000000000000E+00  -8.85230247138230E-13
     -9.03166461931191E-23  -5.67102118582043E-10  -5.67987348829272E-10  -2.71092634940042E-18
      5.66790341828078E-07
      0.00000000000000E+00   8.02723003193784E-14   0.00000000000000E+00  -1.29627477637880E-14  -4.58276455211079E-23
     -8.02531288870278E-11  -8.02660916348374E-11  -1.22424878259785E-18  -5.51355086342096E-02  -5.51355086344832E-02
      0.00000000000000E+00   0.00000000000000E+00   2.73573215236055E-10   0.00000000000000E+00   2.73573215236055E-10
      4.30202262361069E-18  -9.20486086740427E-02  -9.19877053052270E-02   0.00000000000000E+00  -1.20997403544078E-12
     -1.00905514627912E-22  -1.92097149565675E-10  -1.93307123601217E-10  -3.07777384101284E-18
      5.68790341828079E-07
      0.00000000000000E+00   3.35233290807473E-14   0.00000000000000E+00  -9.13077602591255E-16  -4.63779512084908E-23
     -3.35473207795815E-11  -3.35482338572305E-11  -1.29209351499059E-18  -2.23374265245759E-02  -2.23374265247207E-02
      0.00000000000000E+00   0.00000000000000E+00   1.44827752144018E-10   0.00000000000000E+00   1.44827752144018E-10
      4.59167812789873E-18  -1.21261783978907E-01  -1.21226724563670E-01   0.00000000000000E+00  -7.36876768538730E-13
     -1.05860677051001E-22  -1.10542641518143E-10  -1.11279518286788E-10  -3.29958461290814E-18
      5.69790341828079E-07
      0.00000000000000E+00   1.26745737346387E-14   0.00000000000000E+00   6.77697365006515E-16  -4.64040391012050E-23
     -1.27087092080078E-11  -1.27080315106892E-11  -1.30856159303023E-18  -1.49811553111384E-02  -1.49811553112416E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03160516568800E-10   0.00000000000000E+00   1.03160516568800E-10
      4.69483864446753E-18  -1.35736880503829E-01  -1.35708382986760E-01   0.00000000000000E+00  -5.29572312851830E-13
     -1.07464474203744E-22  -8.99229127451520E-11  -9.04524850581112E-11  -3.38627705143730E-18
      5.71140341828079E-07
      0.00000000000000E+00  -4.50039212316881E-15   0.00000000000000E+00   1.01611852186163E-15  -4.62322923383845E-23
      4.46260747651534E-12   4.46362359499097E-12  -1.31755275970952E-18  -1.12423998400042E-02  -1.12423998400798E-02
      0.00000000000000E+00   0.00000000000000E+00   7.56810345553119E-11   0.00000000000000E+00   7.56810345553119E-11
      4.79700804111720E-18  -1.55017501621951E-01  -1.54992251811744E-01   0.00000000000000E+00  -4.24084191940796E-13
     -1.09126447849187E-22  -7.97205739582538E-11  -8.01446581503037E-11  -3.47945528140769E-18
      5.72962841828079E-07
      0.00000000000000E+00  -1.95629290252032E-14   0.00000000000000E+00   9.02868257521233E-16  -4.56732562562464E-23
      1.95666673318293E-11   1.95675702000411E-11  -1.32081704578644E-18  -9.50078531752716E-03  -9.50078531758459E-03
      0.00000000000000E+00   0.00000000000000E+00   5.74370860355644E-11   0.00000000000000E+00   5.74370860355644E-11
      4.90168713041702E-18  -1.80560240039422E-01  -1.80535979665279E-01   0.00000000000000E+00  -4.07005829097258E-13
     -1.11198870397401E-22  -7.65976504063967E-11  -7.70046562356051E-11  -3.58087008463058E-18
      5.74962841828079E-07
      0.00000000000000E+00  -3.20538132854268E-14   0.00000000000000E+00   7.01858269175851E-16  -4.43415602708141E-23
      3.20603099557919E-11   3.20610118140168E-11  -1.32023746506128E-18  -8.71296947659553E-03  -8.71296947664160E-03
      0.00000000000000E+00   0.00000000000000E+00   4.60690177789795E-11   0.00000000000000E+00   4.60690177789795E-11
      4.99382516597498E-18  -2.08010654420528E-01  -2.07986039678522E-01   0.00000000000000E+00  -4.23503465949240E-13
     -1.13479873645129E-22  -7.77065261269335E-11  -7.81300295929962E-11  -3.67358770091370E-18
      5.76962841828079E-07
      0.00000000000000E+00  -4.24322685898774E-14   0.00000000000000E+00   5.44647427956666E-16  -4.17415217466484E-23
      4.24693221409750E-11   4.24698667883612E-11  -1.31792722644267E-18  -8.28748983904514E-03  -8.28748983908392E-03
      0.00000000000000E+00   0.00000000000000E+00   3.87697960837959E-11   0.00000000000000E+00   3.87697960837959E-11
      5.07136475814257E-18  -2.34894367266996E-01  -2.34868773040780E-01   0.00000000000000E+00  -4.44649245242555E-13
     -1.15798026992539E-22  -8.07950136267986E-11  -8.12396628721570E-11  -3.75343753169990E-18
      5.78962841828079E-07
      0.00000000000000E+00  -5.16167423106300E-14   0.00000000000000E+00   4.37762544177828E-16  -3.72680391003409E-23
      5.16400898012486E-11   5.16405275637555E-11  -1.31494169062259E-18  -8.00991970751790E-03  -8.00991970755168E-03
      0.00000000000000E+00   0.00000000000000E+00   3.37719022599009E-11   0.00000000000000E+00   3.37719022599009E-11
      5.13890856266237E-18  -2.61226092922330E-01  -2.61199184308357E-01   0.00000000000000E+00  -4.63796731316666E-13
     -1.18147508818219E-22  -8.49486330922212E-11  -8.54124298236560E-11  -3.82396687203978E-18
      5.80962841828079E-07
      0.00000000000000E+00  -5.99746133965150E-14   0.00000000000000E+00   3.67526006755320E-16  -3.03123046405083E-23
      6.00088554113451E-11   6.00092229373216E-11  -1.31177583862530E-18  -7.80969653935238E-03  -7.80969653938259E-03
      0.00000000000000E+00   0.00000000000000E+00   3.02059389782187E-11   0.00000000000000E+00   3.02059389782187E-11
      5.19932044061881E-18  -2.87016711785109E-01  -2.86988290351906E-01   0.00000000000000E+00  -4.81121405231809E-13
     -1.20521582335314E-22  -8.97340405101879E-11  -9.02151619155403E-11  -3.88754460199351E-18
      5.82962841828079E-07
      0.00000000000000E+00  -6.78732607963623E-14   0.00000000000000E+00   3.21319383094315E-16  -2.03880008750708E-23
      6.78358387156283E-11   6.78361600349910E-11  -1.30866158776654E-18  -7.65702179221501E-03  -7.65702179224257E-03
      0.00000000000000E+00   0.00000000000000E+00   2.75613513300708E-11   0.00000000000000E+00   2.75613513300708E-11
      5.25444314327895E-18  -3.12270556287747E-01  -3.12240502474591E-01   0.00000000000000E+00  -4.97934438530159E-13
     -1.22918263920828E-22  -9.48995769264095E-11  -9.53975113650626E-11  -3.94578155551241E-18
      5.84962841828079E-07
      0.00000000000000E+00  -7.53126845101719E-14   0.00000000000000E+00   2.90637457749593E-16  -7.32033861761008E-24
      7.52977524265910E-11   7.52980430640414E-11  -1.30569857238136E-18  -7.53607720385065E-03  -7.53607720387617E-03
      0.00000000000000E+00   0.00000000000000E+00   2.55176284613688E-11   0.00000000000000E+00   2.55176284613688E-11
      5.30547840020169E-18  -3.36993320340252E-01  -3.36961559892039E-01   0.00000000000000E+00  -5.15722927046175E-13
     -1.25341515919389E-22  -1.00299948598239E-10  -1.00815671525410E-10  -3.99977982782032E-18
      5.86962841828079E-07
      0.00000000000000E+00  -8.24765740123590E-14   0.00000000000000E+00   2.69820686161592E-16   8.41342809888698E-24
      8.25137696314998E-11   8.25140394521944E-11  -1.30292020617684E-18  -7.43738552973479E-03  -7.43738552975865E-03
      0.00000000000000E+00   0.00000000000000E+00   2.38631291794293E-11   0.00000000000000E+00   2.38631291794293E-11
      5.35320465856054E-18  -3.61189441032552E-01  -3.61155928828887E-01   0.00000000000000E+00  -5.35598351355007E-13
     -1.27798887294608E-22  -1.05841570280140E-10  -1.06377168631623E-10  -4.05028445238370E-18
      5.88962841828079E-07
      0.00000000000000E+00  -8.96404635145461E-14   0.00000000000000E+00   2.60145263680862E-16   2.52836793962958E-23
      8.96547665780664E-11   8.96550267233554E-11  -1.30026970658788E-18  -7.38325268003116E-03  -7.38325268005356E-03
      0.00000000000000E+00   0.00000000000000E+00   2.23968432337734E-11   0.00000000000000E+00   2.23968432337734E-11
      5.39799834502809E-18  -3.84849634916338E-01  -3.84814335334168E-01   0.00000000000000E+00  -5.57091853651796E-13
     -1.30293992302824E-22  -1.11494778103346E-10  -1.12051869957129E-10  -4.09772863844021E-18
      5.90962841828079E-07
      0.00000000000000E+00  -9.67125082795257E-14   0.00000000000000E+00   2.50194710744627E-16   4.22030953612982E-23
      9.66906459592554E-11   9.66908961540083E-11  -1.29777613207135E-18  -7.34453551026827E-03  -7.34453551028949E-03
      0.00000000000000E+00   0.00000000000000E+00   2.12281435574224E-11   0.00000000000000E+00   2.12281435574224E-11
      5.44045463214294E-18  -4.08104919187487E-01  -4.08067771633565E-01   0.00000000000000E+00  -5.86759318048083E-13
     -1.32856984974982E-22  -1.17332280393250E-10  -1.17919039711431E-10  -4.14267850007159E-18
      5.92962841828079E-07
      0.00000000000000E+00  -1.03692708307298E-13   0.00000000000000E+00   2.42989260484530E-16   5.82738889076198E-23
      1.03668330599711E-10   1.03668573589029E-10  -1.29542808982189E-18  -7.31597850172679E-03  -7.31597850174699E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02013609469893E-11   0.00000000000000E+00   2.02013609469893E-11
      5.48085735403692E-18  -4.31002410407374E-01  -4.30963388555198E-01   0.00000000000000E+00  -6.21852174153880E-13
     -1.35500926395463E-22  -1.23248082361730E-10  -1.23869934536019E-10  -4.18542926421503E-18
      5.94962841828079E-07
      0.00000000000000E+00  -1.10581063597862E-13   0.00000000000000E+00   2.36872193173296E-16   7.27927838575940E-23
      1.10586602895581E-10   1.10586839767847E-10  -1.29321139867354E-18  -7.29817316124334E-03  -7.29817316126252E-03
      0.00000000000000E+00   0.00000000000000E+00   1.91865828855525E-11   0.00000000000000E+00   1.91865828855525E-11
      5.51923051980802E-18  -4.53470706256475E-01  -4.53429825097193E-01   0.00000000000000E+00  -6.57968238016235E-13
     -1.38215862093984E-22  -1.29115454415246E-10  -1.29773422653400E-10  -4.22601912113448E-18
      5.95462841828079E-07
      0.00000000000000E+00  -1.12326113604805E-13   0.00000000000000E+00   2.37274594703140E-16   7.64295793724040E-23
      1.12334535298638E-10   1.12334772573309E-10  -1.29266631577818E-18  -7.29439857045491E-03  -7.29439857047379E-03
      0.00000000000000E+00   0.00000000000000E+00   1.88772956282124E-11   0.00000000000000E+00   1.88772956282124E-11
      5.52866916762213E-18  -4.59059061978283E-01  -4.59017727721102E-01   0.00000000000000E+00  -6.80436503663142E-13
     -1.38902918346648E-22  -1.30531631697716E-10  -1.31212068201518E-10  -4.23600285184395E-18
      5.96137841828079E-07
      0.00000000000000E+00  -1.14714076772201E-13   0.00000000000000E+00   2.35113997843271E-16   8.10648081555406E-23
      1.14683079233874E-10   1.14683314347953E-10  -1.29194444839343E-18  -7.29076585446848E-03  -7.29076585448701E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85276445532992E-11   0.00000000000000E+00   1.85276445532992E-11
      5.54117532769560E-18  -4.66552052479261E-01  -4.66510088688927E-01   0.00000000000000E+00  -6.92658638262141E-13
     -1.39838264028667E-22  -1.32518300262849E-10  -1.33210958901251E-10  -4.24923087930217E-18
      5.97049091828079E-07
      0.00000000000000E+00  -1.17836797837257E-13   0.00000000000000E+00   2.32442997377803E-16   8.67956639481757E-23
      1.17832807825231E-10   1.17833040268315E-10  -1.29099284884698E-18  -7.28890841428684E-03  -7.28890841430491E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80708795239591E-11   0.00000000000000E+00   1.80708795239591E-11
      5.55764241666181E-18  -4.76573631050664E-01  -4.76530819147735E-01   0.00000000000000E+00  -7.09291457661576E-13
     -1.41113043008260E-22  -1.35194628334472E-10  -1.35903919792275E-10  -4.26664956781483E-18
      5.98279279328079E-07
      0.00000000000000E+00  -1.22061655748803E-13   0.00000000000000E+00   2.29616532002132E-16   9.36282838535960E-23
      1.22055820888690E-10   1.22056050505316E-10  -1.28974358925125E-18  -7.29296356480203E-03  -7.29296356481951E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74804311250491E-11   0.00000000000000E+00   1.74804311250491E-11
      5.57914662452646E-18  -4.89932634881458E-01  -4.89888678972731E-01   0.00000000000000E+00  -7.31687575725534E-13
     -1.42852246067492E-22  -1.38804794054498E-10  -1.39536481630367E-10  -4.28940303527521E-18
      5.99940032453079E-07
      0.00000000000000E+00  -1.27756029455670E-13   0.00000000000000E+00   2.27302869482188E-16   1.01403881327385E-22
      1.27728331972222E-10   1.27728559275193E-10  -1.28810456953542E-18  -7.31401980778022E-03  -7.31401980779694E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67215185777976E-11   0.00000000000000E+00   1.67215185777976E-11
      5.60691693875928E-18  -5.07661983449129E-01  -5.07616480137081E-01   0.00000000000000E+00  -7.61634595262666E-13
     -1.45224154858691E-22  -1.43688443257583E-10  -1.44450077852990E-10  -4.31881236922386E-18
      6.01940032453079E-07
      0.00000000000000E+00  -1.34644384746234E-13   0.00000000000000E+00   2.28407049738803E-16   1.09056448440373E-22
      1.34607164410968E-10   1.34607392818127E-10  -1.28615452656497E-18  -7.37655866313089E-03  -7.37655866314672E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58336908806176E-11   0.00000000000000E+00   1.58336908806176E-11
      5.63858432052052E-18  -5.28578903704416E-01  -5.28531513745420E-01   0.00000000000000E+00  -7.98192681764467E-13
     -1.48096623411008E-22  -1.49642891016832E-10  -1.50441083698745E-10  -4.35242979395555E-18
      6.03940032453079E-07
      0.00000000000000E+00  -1.42267497934459E-13   0.00000000000000E+00   2.60395651288068E-16   1.15750169327831E-22
      1.42258133630879E-10   1.42258394026646E-10  -1.28392049797424E-18  -7.61376358993740E-03  -7.61376358995215E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47463989845030E-11   0.00000000000000E+00   1.47463989845030E-11
      5.66807711848952E-18  -5.49069495076041E-01  -5.49020038144017E-01   0.00000000000000E+00  -8.30166480598053E-13
     -1.50943363644230E-22  -1.56174626530399E-10  -1.57004793011148E-10  -4.38415662051529E-18
      6.05940032453079E-07
      0.00000000000000E+00  -1.52186729552872E-13   0.00000000000000E+00   3.55618922590617E-16   1.22619345390265E-22
      1.52199455335587E-10   1.52199810954632E-10  -1.28074180588721E-18  -8.31705789850754E-03  -8.31705789852072E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31854508585677E-11   0.00000000000000E+00   1.31854508585677E-11
      5.69444802020666E-18  -5.69139677925839E-01  -5.69087581835660E-01   0.00000000000000E+00  -8.44742315125321E-13
     -1.53699903182756E-22  -1.64540519497921E-10  -1.65385261813200E-10  -4.41370621431945E-18
      6.07940032453079E-07
      0.00000000000000E+00  -1.77995100708187E-13   0.00000000000000E+00   9.94462584012330E-16   1.37533993441023E-22
      1.78039981068185E-10   1.78040975530907E-10  -1.27153279289426E-18  -1.18070845330649E-02  -1.18070845330724E-02
      0.00000000000000E+00   0.00000000000000E+00   7.49886551774524E-12   0.00000000000000E+00   7.49886551774524E-12
      5.70944575124215E-18  -5.88775827186652E-01  -5.88717383352793E-01   0.00000000000000E+00  -7.36555437440544E-13
     -1.55995230605970E-22  -1.84803285611056E-10  -1.85539841048652E-10  -4.43791295834789E-18
      6.09940032453079E-07
      0.00000000000000E+00  -3.40743975039924E-13   0.00000000000000E+00   5.76592021008146E-15   2.11997290268949E-22
      3.40763921905125E-10   3.40769687825547E-10  -1.22453926018452E-18  -3.21072470474546E-02  -3.21072470474301E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.45336286938259E-11   0.00000000000000E+00  -2.45336286938259E-11
      5.66037849385450E-18  -6.07772942820271E-01  -6.07673332048120E-01   0.00000000000000E+00   9.30049060807920E-14
     -1.55703590614168E-22  -3.16329064037646E-10  -3.16236059131721E-10  -4.43583923366998E-18
      6.11940032453079E-07
      0.00000000000000E+00  -7.49269366139003E-13   0.00000000000000E+00   1.22227671380391E-14   3.00630773468837E-22
      7.49247024077746E-10   7.49259246845184E-10  -1.15244022196524E-18  -6.15975607097557E-02  -6.15975607097075E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.82692867587532E-11   0.00000000000000E+00  -4.82692867587532E-11
      5.56383992033699E-18  -6.25651918251730E-01  -6.25431113062758E-01   0.00000000000000E+00   5.07750089926438E-13
     -1.54113694018638E-22  -7.01497710176203E-10  -7.00989960086431E-10  -4.41139969837175E-18
      6.13940032453079E-07
      0.00000000000000E+00  -1.54767566668403E-12   0.00000000000000E+00   2.14975651180991E-14   3.55023171066247E-22
      1.54765740757504E-09   1.54767890514051E-09  -1.07832050344806E-18  -9.12636505260243E-02  -9.12636505259660E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.82826374966124E-11   0.00000000000000E+00  -5.82826374966124E-11
      5.44727464534377E-18  -6.41652915399028E-01  -6.41183765682588E-01   0.00000000000000E+00   4.54768720238115E-13
     -1.52634923281149E-22  -1.48985103636398E-09  -1.48939626764390E-09  -4.36895414189571E-18
      6.15940032453079E-07
      0.00000000000000E+00  -2.99533241454907E-12   0.00000000000000E+00   3.72438348720062E-14   3.93235209808908E-22
      2.99529968783894E-09   2.99533693167421E-09  -1.00884889782488E-18  -1.20491087777788E-01  -1.20491087777719E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91977086892827E-11   0.00000000000000E+00  -6.91977086892827E-11
      5.30887922796520E-18  -6.54556785875745E-01  -6.53635065769284E-01   0.00000000000000E+00   3.64263376556507E-13
     -1.51390276473750E-22  -2.92650348636133E-09  -2.92613922298492E-09  -4.30003033014032E-18
      6.16940032453079E-07
      0.00000000000000E+00  -4.07652866095607E-12   0.00000000000000E+00   5.47245156215614E-14   4.17285127210187E-22
      4.07647010804845E-09   4.07652483256449E-09  -9.76116640754047E-19  -1.34973781524629E-01  -1.34973781524552E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.67149712253197E-11   0.00000000000000E+00  -7.67149712253197E-11
      5.23216425673988E-18  -6.59894421995911E-01  -6.58634497139785E-01   0.00000000000000E+00   2.92083204786276E-13
     -1.50864131880471E-22  -4.00010194454381E-09  -3.99980986133917E-09  -4.25604761598583E-18
      6.18290032453079E-07
      0.00000000000000E+00  -5.95153897104773E-12   0.00000000000000E+00   6.97845888310660E-14   4.38919327110399E-22
      5.95145259072200E-09   5.95152237531127E-09  -9.35530804813205E-19  -1.54264952412353E-01  -1.54264952412265E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.73236183469435E-11   0.00000000000000E+00  -8.73236183469435E-11
      5.11427737197151E-18  -6.64550620991373E-01  -6.62703414764817E-01   0.00000000000000E+00   2.24503530639518E-13
     -1.50285471425525E-22  -5.86442326049482E-09  -5.86419875696433E-09  -4.17874656715830E-18
      6.20112532453079E-07
      0.00000000000000E+00  -9.30019808963416E-12   0.00000000000000E+00   9.17785624581022E-14   4.53460816747386E-22
      9.30008368357075E-09   9.30017546213366E-09  -8.85948138808578E-19  -1.79821929207570E-01  -1.79821929207468E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01755074319154E-10   0.00000000000000E+00  -1.01755074319154E-10
      4.92882874902485E-18  -6.64826682645823E-01  -6.61929192587764E-01   0.00000000000000E+00   2.21369518939209E-13
     -1.49476657070145E-22  -9.19864175733328E-09  -9.19842038781450E-09  -4.04288061021627E-18
      6.22112532453079E-07
      0.00000000000000E+00  -1.42059010380998E-11   0.00000000000000E+00   1.22049166540051E-13   4.58826897334653E-22
      1.42057350933803E-08   1.42058571425473E-08  -8.35957600355824E-19  -2.07287654830988E-01  -2.07287654830872E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16203847949119E-10   0.00000000000000E+00  -1.16203847949119E-10
      4.69642105312661E-18  -6.55644071701104E-01  -6.51205813333238E-01   0.00000000000000E+00   4.02479336325918E-13
     -1.47898801453942E-22  -1.40900557739344E-08  -1.40896532945982E-08  -3.86046345277079E-18
      6.24112532453079E-07
      0.00000000000000E+00  -2.06352163321011E-11   0.00000000000000E+00   1.59636687477036E-13   4.53987589953663E-22
      2.06350832287659E-08   2.06352428654538E-08  -7.88604663043196E-19  -2.34186263294139E-01  -2.34186263294012E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27698878919478E-10   0.00000000000000E+00  -1.27698878919478E-10
      4.44102329528766E-18  -6.34198069468188E-01  -6.27738068456614E-01   0.00000000000000E+00   8.28591771757963E-13
     -1.44655905252611E-22  -2.05083725783060E-08  -2.05075439865343E-08  -3.65241863224446E-18
      6.26112532453079E-07
      0.00000000000000E+00  -2.88997731649832E-11   0.00000000000000E+00   2.05049519436455E-13   4.38586445895432E-22
      2.88995870576266E-08   2.88997921071464E-08  -7.42520375205585E-19  -2.60532517060624E-01  -2.60532517060488E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36260414155242E-10   0.00000000000000E+00  -1.36260414155242E-10
      4.16850246697717E-18  -5.97154106983223E-01  -5.88093186753921E-01   0.00000000000000E+00   1.43508088010382E-12
     -1.38704068393604E-22  -2.87649667738712E-08  -2.87635316929912E-08  -3.42598209177159E-18
      6.28112532453080E-07
      0.00000000000000E+00  -3.92406639719158E-11   0.00000000000000E+00   2.56620776490730E-13   4.10735442762755E-22
      3.92404480679144E-08   3.92407046886913E-08  -6.96944467547296E-19  -2.86337457767814E-01  -2.86337457767670E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44076758770944E-10   0.00000000000000E+00  -1.44076758770944E-10
      3.88034894943528E-18  -5.40760752805194E-01  -5.28444320275400E-01   0.00000000000000E+00   1.97711085736213E-12
     -1.29528939773327E-22  -3.90986050407776E-08  -3.90966279299204E-08  -3.18340448188799E-18
      6.30112532453080E-07
      0.00000000000000E+00  -5.13730782228185E-11   0.00000000000000E+00   3.01395620056468E-13   3.59370424002143E-22
      5.13727795320509E-08   5.13730809276713E-08  -6.51777137770826E-19  -3.11605557198072E-01  -3.11605557197917E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54641359582138E-10   0.00000000000000E+00  -1.54641359582138E-10
      3.57106623027101E-18  -4.61852655237951E-01  -4.45716905811158E-01   0.00000000000000E+00   2.12907224440019E-12
     -1.18236384583995E-22  -5.12205686403334E-08  -5.12184395680891E-08  -2.91928909250018E-18
      6.32112532453080E-07
      0.00000000000000E+00  -6.41907460580265E-11   0.00000000000000E+00   3.18966407875263E-13   2.83268684240003E-22
      6.41904675546332E-08   6.41907865210414E-08  -6.07122377988455E-19  -3.36342296513257E-01  -3.36342296513089E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67540591456405E-10   0.00000000000000E+00  -1.67540591456405E-10
      3.23598504735820E-18  -3.59416675099318E-01  -3.39246182404372E-01   0.00000000000000E+00   1.92029975259737E-12
     -1.06100368902315E-22  -6.40251662293374E-08  -6.40232459295849E-08  -2.62886266936974E-18
      6.34112532453080E-07
      0.00000000000000E+00  -7.49708383982855E-11   0.00000000000000E+00   2.68838215580812E-13   2.20030320359628E-22
      7.49705605230011E-08   7.49708293612169E-08  -5.63128454527601E-19  -3.60552624896599E-01  -3.60552624896415E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.83083673059552E-10   0.00000000000000E+00  -1.83083673059552E-10
      2.86981770123910E-18  -2.37901707702697E-01  -2.14339133579658E-01   0.00000000000000E+00   1.47457519209931E-12
     -9.17177381373475E-23  -7.47892202633493E-08  -7.47877456881573E-08  -2.30668924671149E-18
      6.36112532453080E-07
      0.00000000000000E+00  -7.73536582603976E-11   0.00000000000000E+00   5.98557785320875E-14   1.15816315770759E-22
      7.73536347983342E-08   7.73536946541128E-08  -5.20300673117926E-19  -3.84226446693512E-01  -3.84226446693303E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08926474872059E-10   0.00000000000000E+00  -2.08926474872059E-10
      2.45196475149498E-18  -1.14070003196367E-01  -8.97643887458526E-02   0.00000000000000E+00   8.77699780113311E-13
     -7.58868169072465E-23  -7.71456458790208E-08  -7.71447681792407E-08  -1.93166407837705E-18
      6.38112532453080E-07
      0.00000000000000E+00  -5.18582021247486E-11   0.00000000000000E+00  -6.33468239736519E-13   3.20782224428714E-23
      5.18588259794449E-08   5.18581925112052E-08  -4.69318486897623E-19  -4.07490342650748E-01  -4.07490342650573E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.75389138098853E-10   0.00000000000000E+00  -1.75389138098853E-10
      2.10118647529727E-18  -4.23212420213679E-02  -2.60376933743001E-02   0.00000000000000E+00   9.43518192379159E-13
     -3.01489158281069E-23  -5.16837468912988E-08  -5.16828033731064E-08  -1.63186798839965E-18
      6.40112532453080E-07
      0.00000000000000E+00  -2.79759987981499E-11   0.00000000000000E+00  -5.90902681865472E-13   1.08302304877614E-23
      2.79766339480901E-08   2.79760430454082E-08  -4.11551557422764E-19  -4.30398473555340E-01  -4.30398473555222E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18238621632996E-10   0.00000000000000E+00  -1.18238621632996E-10
      1.86470923203128E-18  -1.84838607344003E-02  -9.70676504912357E-03   0.00000000000000E+00   6.86429023865877E-13
     -1.14936245983422E-23  -2.78584908527990E-08  -2.78578044237752E-08  -1.45315767460851E-18
      6.42112532453080E-07
      0.00000000000000E+00  -1.95190272408180E-11   0.00000000000000E+00  -2.08478133927978E-13   5.79727089522734E-24
      1.95191925403107E-08   1.95189840621768E-08  -3.55628786810614E-19  -4.52878608404986E-01  -4.52878608404885E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01530795583172E-10   0.00000000000000E+00  -1.01530795583172E-10
      1.66164764086493E-18  -1.15730424710900E-02  -5.45522186266587E-03   0.00000000000000E+00   2.61213256827716E-13
     -6.44070524967634E-24  -1.94177144798504E-08  -1.94174532665936E-08  -1.30601885405432E-18
      6.42612532453080E-07
      0.00000000000000E+00  -1.81413561827051E-11   0.00000000000000E+00  -1.35633425612986E-13   5.07757591344706E-24
      1.81414517733464E-08   1.81413161399208E-08  -3.41914426429384E-19  -4.58469964817477E-01  -4.58469964817376E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01533052141205E-10   0.00000000000000E+00  -1.01533052141205E-10
      1.61088111479433E-18  -1.05349916817518E-02  -4.85122961272464E-03   0.00000000000000E+00   1.80320564572347E-13
     -5.75945687383724E-24  -1.80399634083442E-08  -1.80397830877796E-08  -1.26896668836495E-18
      6.43287532453080E-07
      0.00000000000000E+00  -1.72175818158718E-11   0.00000000000000E+00  -6.75982940347735E-14   4.53549989393796E-24
      1.72176834044391E-08   1.72176158061450E-08  -3.23731900796287E-19  -4.65967026124719E-01  -4.65967026124618E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00518709230808E-10   0.00000000000000E+00  -1.00518709230808E-10
      1.54303098606354E-18  -9.75630508983893E-03  -4.36325027502778E-03   0.00000000000000E+00   1.08453590901466E-13
     -5.12536531139716E-24  -1.71172055505051E-08  -1.71170970969142E-08  -1.21929908526725E-18
      6.44198782453080E-07
      0.00000000000000E+00  -1.66852497190170E-11   0.00000000000000E+00  -2.86551618546503E-14   4.08806428256279E-24
      1.66852359651654E-08   1.66852073100035E-08  -2.99712926246604E-19  -4.75994083319092E-01  -4.75994083318992E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00683271825016E-10   0.00000000000000E+00  -1.00683271825016E-10
      1.45128335461299E-18  -9.18881779011444E-03  -3.96355802706273E-03   0.00000000000000E+00   6.63540186681149E-14
     -4.58328547712831E-24  -1.65845903921971E-08  -1.65845240381785E-08  -1.15157042836638E-18
      6.45428969953080E-07
      0.00000000000000E+00  -1.64144914337292E-11   0.00000000000000E+00  -1.22260298440001E-14   3.69122631215222E-24
      1.64145106204894E-08   1.64144983944596E-08  -2.68180796349708E-19  -4.89360407225836E-01  -4.89360407225734E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01743184135663E-10   0.00000000000000E+00  -1.01743184135663E-10
      1.32612016127910E-18  -8.75384914245160E-03  -3.61421238345117E-03   0.00000000000000E+00   4.68636220401034E-14
     -4.09039099832367E-24  -1.63128020739460E-08  -1.63127552103239E-08  -1.05793936492939E-18
      6.47089723078080E-07
      0.00000000000000E+00  -1.62808573410922E-11   0.00000000000000E+00  -3.65839549369929E-15   3.31797673128186E-24
      1.62808328498972E-08   1.62808291915017E-08  -2.27183454561829E-19  -5.07099470531344E-01  -5.07099470531241E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03376912193667E-10   0.00000000000000E+00  -1.03376912193667E-10
      1.15443663130062E-18  -8.38668461086201E-03  -3.28967536843595E-03   0.00000000000000E+00   3.50658218254297E-14
     -3.61563412789923E-24  -1.61774873451299E-08  -1.61774522793080E-08  -9.27253176738789E-19
      6.49089723078080E-07
      0.00000000000000E+00  -1.62096776697564E-11   0.00000000000000E+00  -1.47082464502166E-15   2.99373707208939E-24
      1.62097080934036E-08   1.62097066225790E-08  -1.80071368305842E-19  -5.28027853860147E-01  -5.28027853860041E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05256824952800E-10   0.00000000000000E+00  -1.05256824952800E-10
      9.43922981395017E-19  -8.08577419437250E-03  -3.01176289151426E-03   0.00000000000000E+00   2.96247765080629E-14
     -3.19780838852214E-24  -1.61044794224027E-08  -1.61044497976262E-08  -7.63851613089176E-19
      6.51089723078080E-07
      0.00000000000000E+00  -1.61684393827502E-11   0.00000000000000E+00  -7.61536419456532E-16   2.75109214609412E-24
      1.61684034762629E-08   1.61684027147265E-08  -1.35213250241502E-19  -5.48529696638515E-01  -5.48529696638408E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06967060300499E-10   0.00000000000000E+00  -1.06967060300499E-10
      7.29988860794018E-19  -7.86757525510820E-03  -2.80711436194285E-03   0.00000000000000E+00   2.60842576718191E-14
     -2.88355682859956E-24  -1.60614617386837E-08  -1.60614356544260E-08  -5.94775610552516E-19
      6.53089723078080E-07
      0.00000000000000E+00  -1.61419880984345E-11   0.00000000000000E+00  -4.17278197424463E-16   2.56291988832292E-24
      1.61419443449105E-08   1.61419439276323E-08  -9.24543653925321E-20  -5.68611062687463E-01  -5.68611062687354E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08104018604714E-10   0.00000000000000E+00  -1.08104018604714E-10
      5.13780823584590E-19  -7.70222531884209E-03  -2.65045712132541E-03   0.00000000000000E+00   2.34242966015094E-14
     -2.63835454972266E-24  -1.60338633333242E-08  -1.60338399090276E-08  -4.21326458192058E-19
      6.55089723078080E-07
      0.00000000000000E+00  -1.61238946852046E-11   0.00000000000000E+00  -2.29546494761653E-16   2.41252095690594E-24
      1.61238503323065E-08   1.61238501027600E-08  -5.16660700698843E-20  -5.88259664065998E-01  -5.88259664065889E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08625501278352E-10   0.00000000000000E+00  -1.08625501278352E-10
      2.96529821027886E-19  -7.57237889943343E-03  -2.52647411702589E-03   0.00000000000000E+00   2.13097274999756E-14
     -2.44225490228762E-24  -1.60152459112092E-08  -1.60152246014817E-08  -2.44863750958001E-19
      6.57089723078080E-07
      0.00000000000000E+00  -1.61096587509374E-11   0.00000000000000E+00  -1.50569035032514E-16   2.29017256484535E-24
      1.61096777874968E-08   1.61096776369277E-08  -1.30894305201999E-20  -6.07279336707610E-01  -6.07279336707502E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07545260809106E-10   0.00000000000000E+00  -1.07545260809106E-10
      8.14392994096727E-20  -7.46736297259900E-03  -2.42558174836730E-03   0.00000000000000E+00   1.93807634038240E-14
     -2.28333790510769E-24  -1.60021517568820E-08  -1.60021323761186E-08  -6.83498688894729E-20
      6.59089723078080E-07
      0.00000000000000E+00  -1.60859628087379E-11   0.00000000000000E+00  -4.05336086638258E-16   2.19975148341737E-24
      1.60859796420133E-08   1.60859792366772E-08   2.25225721667741E-20  -6.25196748739053E-01  -6.25196748738949E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03180328017895E-10   0.00000000000000E+00  -1.03180328017895E-10
     -1.24921356626116E-19  -7.39938318000505E-03  -2.36369219601559E-03   0.00000000000000E+00   1.75194826510099E-14
     -2.16776516874695E-24  -1.59828164281419E-08  -1.59827989086593E-08   1.02398784459341E-19
      6.60089723078080E-07
      0.00000000000000E+00  -1.60725534771056E-11   0.00000000000000E+00  -4.97339845654694E-16   2.16246349963474E-24
      1.60725360389771E-08   1.60725355416373E-08   3.92815106341231E-20  -6.33744862003972E-01  -6.33744862003873E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96254864892397E-11   0.00000000000000E+00  -9.96254864892397E-11
     -2.24546843115356E-19  -7.37478022892058E-03  -2.34220440519880E-03   0.00000000000000E+00   1.62116462483696E-14
     -2.12115923676380E-24  -1.59729262667943E-08  -1.59729100551480E-08   1.85265332481232E-19
      6.61439723078080E-07
      0.00000000000000E+00  -1.60590523007361E-11   0.00000000000000E+00  -3.42916612327865E-16   2.11959216818691E-24
      1.60590959400266E-08   1.60590955971100E-08   5.97259189765689E-20  -6.44272446966554E-01  -6.44272446966462E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.16218842210750E-11   0.00000000000000E+00  -9.16218842210750E-11
     -3.48236386813808E-19  -7.34823855507199E-03  -2.31737493464193E-03   0.00000000000000E+00   1.42348677223860E-14
     -2.06710986411285E-24  -1.59674879477567E-08  -1.59674737128890E-08   2.88510467837239E-19
      6.63262223078080E-07
      0.00000000000000E+00  -1.60371932532807E-11   0.00000000000000E+00  -4.76241850377996E-16   2.07465674720912E-24
      1.60372242785260E-08   1.60372238022841E-08   8.18190790746293E-20  -6.55768169926965E-01  -6.55768169926890E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.47608539795373E-11   0.00000000000000E+00  -7.47608539795373E-11
     -4.84488043191514E-19  -7.32038540167631E-03  -2.29109985879583E-03   0.00000000000000E+00   1.12232250302113E-14
     -2.01174592159094E-24  -1.59624741715296E-08  -1.59624629483046E-08   4.02668964116886E-19
      6.65262223078080E-07
      0.00000000000000E+00  -1.60024759426162E-11   0.00000000000000E+00  -7.88128091004789E-16   2.04369989859872E-24
      1.60024420141086E-08   1.60024412259805E-08   9.64522702820834E-20  -6.63447544438830E-01  -6.63447544438785E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58424024235516E-11   0.00000000000000E+00  -4.58424024235516E-11
     -5.76172848038618E-19  -7.29995983410618E-03  -2.27252146420699E-03   0.00000000000000E+00   6.76229524018523E-15
     -1.97625057753123E-24  -1.59566055858522E-08  -1.59565988235570E-08   4.79720577756535E-19
      6.67262223078080E-07
      0.00000000000000E+00  -1.59533390082102E-11   0.00000000000000E+00  -1.20554035301874E-15   2.03549863782466E-24
      1.59533499187714E-08   1.59533487132311E-08   9.76662878514039E-20  -6.64084375785639E-01  -6.64084375785636E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.83503879677071E-12   0.00000000000000E+00  -3.83503879677071E-12
     -5.83842925632159E-19  -7.29189990367190E-03  -2.26669380644235E-03   0.00000000000000E+00   7.22735279722044E-16
     -1.97213831387632E-24  -1.59495143971696E-08  -1.59495136744343E-08   4.86176637780755E-19
      6.69262223078080E-07
      0.00000000000000E+00  -1.58878537105812E-11   0.00000000000000E+00  -3.57950562905341E-16   2.05746341785588E-24
      1.58878398210480E-08   1.58878394630975E-08   8.09271514222565E-20  -6.55293246945552E-01  -6.55293246945605E-01
      0.00000000000000E+00   0.00000000000000E+00   5.24312590266481E-11   0.00000000000000E+00   5.24312590266481E-11
     -4.78980407578863E-19  -7.30025580610013E-03  -2.27796278524391E-03   0.00000000000000E+00  -8.67629053707146E-15
     -2.01009377911648E-24  -1.59402620458336E-08  -1.59402707221241E-08   3.98053256156606E-19
      6.71262223078080E-07
      0.00000000000000E+00  -1.58031728628759E-11   0.00000000000000E+00  -2.28626580875586E-15   2.12382816856007E-24
      1.58031691116300E-08   1.58031668253642E-08   4.04178638871134E-20  -6.34312045104306E-01  -6.34312045104430E-01
      0.00000000000000E+00   0.00000000000000E+00   1.23769687205579E-10   0.00000000000000E+00   1.23769687205579E-10
     -2.31441033167704E-19  -7.33278341381325E-03  -2.31469237567743E-03   0.00000000000000E+00  -1.83076689564605E-14
     -2.11187583418340E-24  -1.59269182049008E-08  -1.59269365125698E-08   1.91023169280591E-19
      6.73262223078080E-07
      0.00000000000000E+00  -1.56810193623899E-11   0.00000000000000E+00  -1.29968280325458E-13   2.27978689744711E-24
      1.56810332628914E-08   1.56809032946111E-08  -3.20980914665499E-20  -5.97830754281387E-01  -5.97830754281596E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09934084662895E-10   0.00000000000000E+00   2.09934084662895E-10
      1.88427136158086E-19  -7.43334967166393E-03  -2.42659491337049E-03   0.00000000000000E+00   9.27078579868082E-14
     -2.34951778951500E-24  -1.58909300871320E-08  -1.58908373792740E-08  -1.56329044691535E-19
      6.75262223078080E-07
      0.00000000000000E+00  -1.54776751142124E-11   0.00000000000000E+00  -5.64946172218589E-15   2.66468798932920E-24
      1.54777092899228E-08   1.54777036404611E-08  -1.49042428322750E-19  -5.42110545239758E-01  -5.42110545240062E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04306472415234E-10   0.00000000000000E+00   3.04306472415234E-10
      7.97040080988553E-19  -7.74333479034148E-03  -2.77091267577666E-03   0.00000000000000E+00  -5.81767782041282E-14
     -2.97376846552589E-24  -1.57819519360981E-08  -1.57820101128763E-08  -6.47997652665803E-19
      6.77262223078080E-07
      0.00000000000000E+00  -1.50340650335001E-11   0.00000000000000E+00  -1.24885063309870E-14   3.69509544115589E-24
      1.50340711211971E-08   1.50340586326908E-08  -3.28340157014269E-19  -4.63953402618543E-01  -4.63953402618923E-01
      0.00000000000000E+00   0.00000000000000E+00   3.80662710488439E-10   0.00000000000000E+00   3.80662710488439E-10
      1.55836550196543E-18  -8.76351469850084E-03  -3.90682456075406E-03   0.00000000000000E+00  -1.02221612683751E-13
     -5.19624383396656E-24  -1.54146191215665E-08  -1.54147213431792E-08  -1.23002534495116E-18
      6.79262223078080E-07
      0.00000000000000E+00  -1.24754543443728E-11   0.00000000000000E+00  -6.54084513376760E-14   5.80714681812833E-24
      1.24755183119135E-08   1.24754529034622E-08  -5.78301097478327E-19  -3.62260582927643E-01  -3.62260582928042E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98742603473515E-10   0.00000000000000E+00   3.98742603473515E-10
      2.35585070891246E-18  -1.47263046515745E-02  -1.06700758109507E-02   0.00000000000000E+00  -1.83710175752796E-13
     -2.27821684730687E-23  -1.28740117967599E-08  -1.28741955069357E-08  -1.77754961143413E-18
      6.81262223078080E-07
      0.00000000000000E+00  -2.69665332915019E-12   0.00000000000000E+00  -3.03157310168628E-13  -2.27168537046355E-23
      2.69691387559422E-09   2.69661071828402E-09  -8.45633607601688E-19  -2.41222383224547E-01  -2.41222383224956E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08956273459971E-10   0.00000000000000E+00   4.08956273459971E-10
      3.17376325583240E-18  -3.96536893852038E-02  -3.86752225647070E-02   0.00000000000000E+00  -3.11238178688804E-13
     -7.89527905393835E-23  -3.10525575356522E-09  -3.10556699174399E-09  -2.32812964823071E-18
      6.83262223078081E-07
      0.00000000000000E+00  -1.30419526834688E-14   0.00000000000000E+00  -7.33236829749739E-14  -4.39318989310296E-23
      1.30720652494098E-11   1.29987415663909E-11  -1.10103808515052E-18  -1.17041258771516E-01  -1.17041258771888E-01
      0.00000000000000E+00   0.00000000000000E+00   3.71560921922087E-10   0.00000000000000E+00   3.71560921922087E-10
      3.91688509967657E-18  -6.93943500106313E-02  -6.92731905676879E-02   0.00000000000000E+00  -1.06323618715713E-12
     -9.33332387152085E-23  -3.83496427301227E-10  -3.84559663488477E-10  -2.81584701452606E-18
      6.85262223078081E-07
      0.00000000000000E+00   7.05367581753806E-14   0.00000000000000E+00  -7.52213246423865E-15  -4.60614303844230E-23
     -7.05714255859399E-11  -7.05789477184502E-11  -1.24798178460728E-18  -4.34666162060393E-02  -4.34666162062749E-02
      0.00000000000000E+00   0.00000000000000E+00   2.35687262730271E-10   0.00000000000000E+00   2.35687262730271E-10
      4.38825962513712E-18  -9.89630571174510E-02  -9.89110381425227E-02   0.00000000000000E+00  -1.11387406414407E-12
     -1.02461492182416E-22  -1.63994440947576E-10  -1.65108315011822E-10  -3.14027784052984E-18
      6.87262223078081E-07
      0.00000000000000E+00   2.41551658855795E-14   0.00000000000000E+00  -1.65517188003303E-16  -4.63952476774482E-23
     -2.41290788588658E-11  -2.41292443761002E-11  -1.29996693038952E-18  -1.88246811793094E-02  -1.88246811794353E-02
      0.00000000000000E+00   0.00000000000000E+00   1.25841429052648E-10   0.00000000000000E+00   1.25841429052648E-10
      4.63994248324242E-18  -1.28053485660019E-01  -1.28021440593418E-01   0.00000000000000E+00  -6.44283658282390E-13
     -1.06625422089107E-22  -1.01067901018158E-10  -1.01712184676547E-10  -3.33997555285290E-18
      6.89262223078081E-07
      0.00000000000000E+00  -3.39825527667849E-15   0.00000000000000E+00   8.90803005225897E-16  -4.62189775566160E-23
      3.36480475707191E-12   3.36569556003092E-12  -1.31627842902014E-18  -1.16729344621732E-02  -1.16729344622518E-02
      0.00000000000000E+00   0.00000000000000E+00   7.85680428261814E-11   0.00000000000000E+00   7.85680428261814E-11
      4.79707856889478E-18  -1.56583603869276E-01  -1.56557790397076E-01   0.00000000000000E+00  -4.47377393531792E-13
     -1.09246063833970E-22  -8.14863609925713E-11  -8.19337383862124E-11  -3.48080013987464E-18
      6.89762223078081E-07
      0.00000000000000E+00  -9.27631845796020E-15   0.00000000000000E+00   1.01394486801136E-15  -4.61098614889503E-23
      9.28919205976539E-12   9.29020600458729E-12  -1.31879323030682E-18  -1.05994251106059E-02  -1.05994251106756E-02
      0.00000000000000E+00   0.00000000000000E+00   6.96264267004700E-11   0.00000000000000E+00   6.96264267004700E-11
      4.83189178224501E-18  -1.63679600559503E-01  -1.63654737694591E-01   0.00000000000000E+00  -4.24621145049544E-13
     -1.09847322950592E-22  -7.84920115598963E-11  -7.89166327050557E-11  -3.51309855193819E-18
      6.90437223078081E-07
      0.00000000000000E+00  -1.56136053252795E-14   0.00000000000000E+00   9.93075300357822E-16  -4.58949902174646E-23
      1.56831670935645E-11   1.56841601688189E-11  -1.32055598181718E-18  -9.79599289530718E-03  -9.79599289536867E-03
      0.00000000000000E+00   0.00000000000000E+00   6.14894239309870E-11   0.00000000000000E+00   6.14894239309870E-11
      4.87339714339843E-18  -1.73191920795584E-01  -1.73167607155358E-01   0.00000000000000E+00  -4.07846117301994E-13
     -1.10616037637998E-22  -7.67657379823934E-11  -7.71735840998061E-11  -3.55284116158125E-18
      6.91348473078081E-07
      0.00000000000000E+00  -2.26856500902591E-14   0.00000000000000E+00   8.81109965947546E-16  -4.54711248294157E-23
      2.27177618101240E-11   2.27186429200444E-11  -1.32133898816204E-18  -9.21324201357721E-03  -9.21324201363118E-03
      0.00000000000000E+00   0.00000000000000E+00   5.39771019455726E-11   0.00000000000000E+00   5.39771019455726E-11
      4.92258377754633E-18  -1.85910819835935E-01  -1.85886656819985E-01   0.00000000000000E+00  -4.08650612295700E-13
     -1.11639311125394E-22  -7.62870942532094E-11  -7.66957448656168E-11  -3.60124478938429E-18
      6.92578660578081E-07
      0.00000000000000E+00  -3.05842974901064E-14   0.00000000000000E+00   7.34045297016397E-16  -4.45926881247516E-23
      3.06035355569611E-11   3.06042696022135E-11  -1.32091087188357E-18  -8.76952022972160E-03  -8.76952022976854E-03
      0.00000000000000E+00   0.00000000000000E+00   4.69506653570512E-11   0.00000000000000E+00   4.69506653570512E-11
      4.98034189918526E-18  -2.02860285610985E-01  -2.02835852017190E-01   0.00000000000000E+00  -4.20834274954582E-13
     -1.13034106716640E-22  -7.71341006841979E-11  -7.75549349592656E-11  -3.65943102730169E-18
      6.94239413703081E-07
      0.00000000000000E+00  -3.95850817364440E-14   0.00000000000000E+00   5.79610810020419E-16  -4.26674952288440E-23
      3.95534305376632E-11   3.95540101484305E-11  -1.31906429933270E-18  -8.39717210490700E-03  -8.39717210494740E-03
      0.00000000000000E+00   0.00000000000000E+00   4.04022658815069E-11   0.00000000000000E+00   4.04022658815069E-11
      5.04744008850505E-18  -2.25348296307849E-01  -2.25323106335106E-01   0.00000000000000E+00  -4.38682512864245E-13
     -1.14949695216375E-22  -7.95175935169594E-11  -7.99562760299385E-11  -3.72837578917234E-18
      6.96239413703081E-07
      0.00000000000000E+00  -4.88614001944042E-14   0.00000000000000E+00   4.57700876926235E-16  -3.88107101449466E-23
      4.88993251399013E-11   4.88997828407394E-11  -1.31609106926034E-18  -8.09308039980041E-03  -8.09308039983538E-03
      0.00000000000000E+00   0.00000000000000E+00   3.49683139001994E-11   0.00000000000000E+00   3.49683139001994E-11
      5.11737671630545E-18  -2.51874302643074E-01  -2.51847880480616E-01   0.00000000000000E+00  -4.57717859433318E-13
     -1.17291395204128E-22  -8.34103788813887E-11  -8.38680967409393E-11  -3.80128564704511E-18
      6.98239413703081E-07
      0.00000000000000E+00  -5.74029607547042E-14   0.00000000000000E+00   3.80497696465830E-16  -3.26510637805737E-23
      5.73901807093941E-11   5.73905612070579E-11  -1.31288950298581E-18  -7.87298301148922E-03  -7.87298301152032E-03
      0.00000000000000E+00   0.00000000000000E+00   3.10954064801378E-11   0.00000000000000E+00   3.10954064801378E-11
      5.17956752926573E-18  -2.77856836042849E-01  -2.77828959287726E-01   0.00000000000000E+00  -4.75732123770013E-13
     -1.19660559767572E-22  -8.80102355633057E-11  -8.84859676871954E-11  -3.86667802627992E-18
      7.00239413703081E-07
      0.00000000000000E+00  -6.53016081545515E-14   0.00000000000000E+00   3.29992064686890E-16  -2.36469495057673E-23
      6.53003032733790E-11   6.53006332654200E-11  -1.30971744882897E-18  -7.70639741936421E-03  -7.70639741939246E-03
      0.00000000000000E+00   0.00000000000000E+00   2.82495025334553E-11   0.00000000000000E+00   2.82495025334553E-11
      5.23606653433264E-18  -3.03302078009573E-01  -3.03272606094269E-01   0.00000000000000E+00  -4.92458432704411E-13
     -1.22051790919866E-22  -9.30576773660488E-11  -9.35501357988752E-11  -3.92634908550366E-18
      7.02239413703081E-07
      0.00000000000000E+00  -7.28328766055687E-14   0.00000000000000E+00   2.96536253294254E-16  -1.15096122098636E-23
      7.28159667958991E-11   7.28162633321409E-11  -1.30669024841667E-18  -7.57570946834663E-03  -7.57570946837271E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60736116833259E-11   0.00000000000000E+00   2.60736116833259E-11
      5.28821375769929E-18  -3.28213095044358E-01  -3.28181941187306E-01   0.00000000000000E+00  -5.09580168989910E-13
     -1.24466745912513E-22  -9.83802948463529E-11  -9.88898750154673E-11  -3.98152350928262E-18
      7.04239413703081E-07
      0.00000000000000E+00  -8.00886108449633E-14   0.00000000000000E+00   2.74018080369234E-16   3.56593171614379E-24
      8.00676505010307E-11   8.00679245191146E-11  -1.30384855185010E-18  -7.47010324737686E-03  -7.47010324740120E-03
      0.00000000000000E+00   0.00000000000000E+00   2.43375119525884E-11   0.00000000000000E+00   2.43375119525884E-11
      5.33688878160446E-18  -3.52598419917063E-01  -3.52565528762811E-01   0.00000000000000E+00  -5.28554106131228E-13
     -1.26912509537537E-22  -1.03876882365445E-10  -1.04405436471703E-10  -4.03304022975436E-18
      7.06239413703081E-07
      0.00000000000000E+00  -8.71606556099429E-14   0.00000000000000E+00   2.61467247244394E-16   2.02150061477875E-23
      8.71981023908161E-11   8.71983638580836E-11  -1.30116002652130E-18  -7.40086149142929E-03  -7.40086149145213E-03
      0.00000000000000E+00   0.00000000000000E+00   2.28383740173774E-11   0.00000000000000E+00   2.28383740173774E-11
      5.38256552963922E-18  -3.76447580554969E-01  -3.76412915680028E-01   0.00000000000000E+00  -5.49224393574789E-13
     -1.29393786820510E-22  -1.09487513481757E-10  -1.10036737875461E-10  -4.08140550311792E-18
      7.07239413703081E-07
      0.00000000000000E+00  -9.07426003610364E-14   0.00000000000000E+00   2.58392496093272E-16   2.92178412924008E-23
      9.07806638692627E-11   9.07809222617880E-11  -1.29985220148042E-18  -7.37600290699478E-03  -7.37600290701687E-03
      0.00000000000000E+00   0.00000000000000E+00   2.20858899076783E-11   0.00000000000000E+00   2.20858899076783E-11
      5.40465141954690E-18  -3.88232947819130E-01  -3.88197391551526E-01   0.00000000000000E+00  -5.68283394567119E-13
     -1.30654084629400E-22  -1.12298528774768E-10  -1.12866812169465E-10  -4.10479921806648E-18
      7.08589413703081E-07
      0.00000000000000E+00  -9.55185266958278E-14   0.00000000000000E+00   2.51101553681845E-16   4.10786526512979E-23
      9.55496213250072E-11   9.55498724266019E-11  -1.29815925044184E-18  -7.34926815230829E-03  -7.34926815232961E-03
      0.00000000000000E+00   0.00000000000000E+00   2.13209345816479E-11   0.00000000000000E+00   2.13209345816479E-11
      5.43343468123212E-18  -4.03978917095435E-01  -4.03942099694527E-01   0.00000000000000E+00  -5.87075763688085E-13
     -1.32386059563606E-22  -1.16283731244430E-10  -1.16870807008250E-10  -4.13527543079029E-18
      7.10411913703081E-07
      0.00000000000000E+00  -1.01947658300355E-13   0.00000000000000E+00   2.43677694204909E-16   5.59888656045591E-23
      1.01906826861172E-10   1.01907070538922E-10  -1.29599680713107E-18  -7.32118225103390E-03  -7.32118225105431E-03
      0.00000000000000E+00   0.00000000000000E+00   2.04087495641460E-11   0.00000000000000E+00   2.04087495641460E-11
      5.47062962731278E-18  -4.24949299841965E-01  -4.24910767465874E-01   0.00000000000000E+00  -6.15002918060800E-13
     -1.34783948347304E-22  -1.21700817184871E-10  -1.22315820103067E-10  -4.17463282018171E-18
      7.12411913703081E-07
      0.00000000000000E+00  -1.08836013590919E-13   0.00000000000000E+00   2.37344347427283E-16   7.07342890654525E-23
      1.08816765813506E-10   1.08817003157924E-10  -1.29375758492929E-18  -7.30046717834796E-03  -7.30046717836737E-03
      0.00000000000000E+00   0.00000000000000E+00   1.94102529838660E-11   0.00000000000000E+00   1.94102529838660E-11
      5.50945013328051E-18  -4.47538224606580E-01  -4.47497830405679E-01   0.00000000000000E+00  -6.48758807614189E-13
     -1.37483288408598E-22  -1.27578497334040E-10  -1.28227256141791E-10  -4.21569254835122E-18
      7.14411913703081E-07
      0.00000000000000E+00  -1.15724368881484E-13   0.00000000000000E+00   2.32396190675489E-16   8.35711917354474E-23
      1.15678340520551E-10   1.15678572916825E-10  -1.29163400184381E-18  -7.29204881626737E-03  -7.29204881628580E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84265816802373E-11   0.00000000000000E+00   1.84265816802373E-11
      5.54630329664099E-18  -4.69677586602168E-01  -4.69635341199055E-01   0.00000000000000E+00  -6.86138024140604E-13
     -1.40246400260939E-22  -1.33419016572782E-10  -1.34105154597062E-10  -4.25466929479718E-18
      7.16411913703081E-07
      0.00000000000000E+00  -1.22520879434841E-13   0.00000000000000E+00   2.28743310571775E-16   9.43872077720454E-23
      1.22505627227109E-10   1.22505855970513E-10  -1.28960382313801E-18  -7.29991534023872E-03  -7.29991534025619E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74729301140256E-11   0.00000000000000E+00   1.74729301140256E-11
      5.58124915686904E-18  -4.91367758919602E-01  -4.91323663720634E-01   0.00000000000000E+00  -7.25650091563688E-13
     -1.43062882505974E-22  -1.39253135992832E-10  -1.39978786084538E-10  -4.29164533373102E-18
      7.18411913703081E-07
      0.00000000000000E+00  -1.29317389988198E-13   0.00000000000000E+00   2.27132464128052E-16   1.03308456112335E-22
      1.29332402073929E-10   1.29332629206497E-10  -1.28763756533099E-18  -7.33169574233010E-03  -7.33169574234665E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65504217824789E-11   0.00000000000000E+00   1.65504217824789E-11
      5.61435000043400E-18  -5.12616296504407E-01  -5.12570341926242E-01   0.00000000000000E+00  -7.66179768520843E-13
     -1.45916047712517E-22  -1.45116871220309E-10  -1.45883050988976E-10  -4.32671243510301E-18
      7.20411913703081E-07
      0.00000000000000E+00  -1.36389434753177E-13   0.00000000000000E+00   2.34664362515128E-16   1.10701351208070E-22
      1.36365026565591E-10   1.36365261230064E-10  -1.28563330842705E-18  -7.42888824987898E-03  -7.42888824989458E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56058767343624E-11   0.00000000000000E+00   1.56058767343624E-11
      5.64556175390272E-18  -5.33432162148535E-01  -5.33384290357819E-01   0.00000000000000E+00  -8.04810019232994E-13
     -1.48779390575729E-22  -1.51166327945046E-10  -1.51971137964427E-10  -4.35992844547567E-18
      7.22411913703081E-07
      0.00000000000000E+00  -1.44288082153025E-13   0.00000000000000E+00   2.72799775627639E-16   1.17277908406989E-22
      1.44316707800464E-10   1.44316980600357E-10  -1.28327286618248E-18  -7.73131385980192E-03  -7.73131385981639E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44677841912642E-11   0.00000000000000E+00   1.44677841912642E-11
      5.67449732228525E-18  -5.53823480936568E-01  -5.53773463467318E-01   0.00000000000000E+00  -8.35131401573503E-13
     -1.51609529296393E-22  -1.57949633389896E-10  -1.58784764791622E-10  -4.39122445610277E-18
      7.24411913703081E-07
      0.00000000000000E+00  -1.55768674303965E-13   0.00000000000000E+00   4.17226497521229E-16   1.24772607921756E-22
      1.55756365168198E-10   1.55756782394820E-10  -1.27949333990783E-18  -8.71599489265556E-03  -8.71599489266809E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25273771604148E-11   0.00000000000000E+00   1.25273771604148E-11
      5.69955207660608E-18  -5.73794411010955E-01  -5.73741401955034E-01   0.00000000000000E+00  -8.38204898547521E-13
     -1.54313297545573E-22  -1.67445954656533E-10  -1.68284159555235E-10  -4.42005873669825E-18
      7.26411913703081E-07
      0.00000000000000E+00  -1.95353756040409E-13   0.00000000000000E+00   1.52547244006910E-15   1.46866504483044E-22
      1.95298220163939E-10   1.95299745636526E-10  -1.26550321871002E-18  -1.43870309275914E-02  -1.43870309275948E-02
      0.00000000000000E+00   0.00000000000000E+00   3.40003221315239E-12   0.00000000000000E+00   3.40003221315239E-12
      5.70635214103238E-18  -5.93313563273368E-01  -5.93250974423920E-01   0.00000000000000E+00  -6.31507558573420E-13
     -1.56264536631060E-22  -1.98068270290948E-10  -1.98699777849678E-10  -4.44084892232236E-18
      7.28411913703081E-07
      0.00000000000000E+00  -4.13852385857116E-13   0.00000000000000E+00   7.44465694026263E-15   2.36285664663001E-22
      4.13862781590761E-10   4.13870226247938E-10  -1.20825695206625E-18  -3.89610459021740E-02  -3.89610459021406E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.33718937555824E-11   0.00000000000000E+00  -3.33718937555824E-11
      5.63960835352122E-18  -6.12097079340305E-01  -6.11977226694882E-01   0.00000000000000E+00   3.02253536845979E-13
     -1.55330577663965E-22  -3.80800586029046E-10  -3.80498332492355E-10  -4.43135140145497E-18
      7.30411913703081E-07
      0.00000000000000E+00  -8.95118808824556E-13   0.00000000000000E+00   1.39371262322128E-14   3.16280772870257E-22
      8.95116435060165E-10   8.95130372186714E-10  -1.13466296483996E-18  -6.86885926339048E-02  -6.86885926338539E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.09178115486934E-11   0.00000000000000E+00  -5.09178115486934E-11
      5.53777273042383E-18  -6.29613801555605E-01  -6.29347882006058E-01   0.00000000000000E+00   5.04629594373935E-13
     -1.53737956119552E-22  -8.44717190232239E-10  -8.44212560638019E-10  -4.40310976558387E-18
      7.32411913703081E-07
      0.00000000000000E+00  -1.82275065462058E-12   0.00000000000000E+00   2.46121904443810E-14   3.65036726482916E-22
      1.82269228045594E-09   1.82271689264675E-09  -1.06121400371644E-18  -9.82664166168490E-02  -9.82664166167884E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.06626484437494E-11   0.00000000000000E+00  -6.06626484437494E-11
      5.41644743353633E-18  -6.45008894514120E-01  -6.44453858404733E-01   0.00000000000000E+00   4.35197577550988E-13
     -1.52307601021347E-22  -1.76248944178040E-09  -1.76205424420300E-09  -4.35523342981988E-18
      7.34411913703081E-07
      0.00000000000000E+00  -3.46603669273764E-12   0.00000000000000E+00   4.20150019072939E-14   4.01189143770838E-22
      3.46597357401787E-09   3.46601558902018E-09  -9.93357185692696E-19  -1.27369381076490E-01  -1.27369381076417E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.22253587153817E-11   0.00000000000000E+00  -7.22253587153817E-11
      5.27199671610557E-18  -6.56940966432433E-01  -6.55871936967404E-01   0.00000000000000E+00   3.40575364955723E-13
     -1.51126901151190E-22  -3.39413080566960E-09  -3.39379023030479E-09  -4.27863953041287E-18
      7.36411913703081E-07
      0.00000000000000E+00  -6.08645889000559E-12   0.00000000000000E+00   6.59158260079256E-14   4.29950463961312E-22
      6.08642607012323E-09   6.08649198594966E-09  -9.32844077861427E-19  -1.55913171226357E-01  -1.55913171226270E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.67961368254473E-11   0.00000000000000E+00  -8.67961368254473E-11
      5.09840444245468E-18  -6.63590336320165E-01  -6.61700447926474E-01   0.00000000000000E+00   2.53379704320664E-13
     -1.50180228764570E-22  -5.99994922882838E-09  -5.99969584912421E-09  -4.16556036459325E-18
      7.36911913703082E-07
      0.00000000000000E+00  -6.95622855136087E-12   0.00000000000000E+00   8.70065628744898E-14   4.40985538194242E-22
      6.95616457425728E-09   6.95625158082060E-09  -9.18273921122856E-19  -1.63012629892790E-01  -1.63012629892698E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.19084519571584E-11   0.00000000000000E+00  -9.19084519571584E-11
      5.05245021647610E-18  -6.64819341177528E-01  -6.62657088507618E-01   0.00000000000000E+00   2.10989583164767E-13
     -1.49968748055928E-22  -6.86455411844646E-09  -6.86434312886345E-09  -4.13417629535324E-18
      7.37586913703081E-07
      0.00000000000000E+00  -8.24912691703122E-12   0.00000000000000E+00   9.56163913773396E-14   4.52419982882652E-22
      8.24910061895186E-09   8.24919623534369E-09  -8.99518295560057E-19  -1.72529650469328E-01  -1.72529650469229E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81933923321262E-11   0.00000000000000E+00  -9.81933923321262E-11
      4.98616967665191E-18  -6.65614963136781E-01  -6.63047411476919E-01   0.00000000000000E+00   1.89325346469761E-13
     -1.49703080623176E-22  -8.15119216835790E-09  -8.15100284301158E-09  -4.08665138109186E-18
      7.38498163703082E-07
      0.00000000000000E+00  -1.02134103116886E-11   0.00000000000000E+00   1.07412422025388E-13   4.61508086623331E-22
      1.02132804470883E-08   1.02133878595108E-08  -8.75450762399636E-19  -1.85254876400690E-01  -1.85254876400584E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06185092149106E-10   0.00000000000000E+00  -1.06185092149106E-10
      4.88940851143104E-18  -6.64933703463007E-01  -6.61749944962746E-01   0.00000000000000E+00   2.02396056212802E-13
     -1.49315010055589E-22  -1.01074051634177E-08  -1.01072027673617E-08  -4.01395774903140E-18
      7.39728351203081E-07
      0.00000000000000E+00  -1.32829532739013E-11   0.00000000000000E+00   1.24041647614944E-13   4.65603614650473E-22
      1.32828022621713E-08   1.32829263038194E-08  -8.44598063406420E-19  -2.02212774258724E-01  -2.02212774258609E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15562088595840E-10   0.00000000000000E+00  -1.15562088595840E-10
      4.74724547456654E-18  -6.60349625499409E-01  -6.56201901762785E-01   0.00000000000000E+00   3.10880787100528E-13
     -1.48541519167962E-22  -1.31676750960105E-08  -1.31673642152236E-08  -3.90264741116012E-18
      7.41389104328081E-07
      0.00000000000000E+00  -1.82754494990281E-11   0.00000000000000E+00   1.49338527097895E-13   4.61623832612166E-22
      1.82752930561306E-08   1.82754423946581E-08  -8.04881504505077E-19  -2.24711912283764E-01  -2.24711912283639E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25454789441970E-10   0.00000000000000E+00  -1.25454789441970E-10
      4.53889604095457E-18  -6.46214844523308E-01  -6.40497535641178E-01   0.00000000000000E+00   6.30310592010156E-13
     -1.46502111166858E-22  -1.81506179158080E-08  -1.81499876052162E-08  -3.73401453644950E-18
      7.43389104328082E-07
      0.00000000000000E+00  -2.58422618633446E-11   0.00000000000000E+00   1.87767769854215E-13   4.47552975712040E-22
      2.58420654981808E-08   2.58422532659511E-08  -7.58590219459844E-19  -2.51250969034408E-01  -2.51250969034274E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34196592698186E-10   0.00000000000000E+00  -1.34196592698186E-10
      4.27050285555820E-18  -6.14866867164773E-01  -6.06768563110807E-01   0.00000000000000E+00   1.21969282885264E-12
     -1.41620877969573E-22  -2.57092763660816E-08  -2.57080566732528E-08  -3.51191263609836E-18
      7.45389104328082E-07
      0.00000000000000E+00  -3.54437106910194E-11   0.00000000000000E+00   2.38230082979056E-13   4.23675262797876E-22
      3.54434571245131E-08   3.54436953545965E-08  -7.12928875240903E-19  -2.77246311261694E-01  -2.77246311261552E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41495843509722E-10   0.00000000000000E+00  -1.41495843509722E-10
      3.98751116853876E-18  -5.65505314623065E-01  -5.54384389799673E-01   0.00000000000000E+00   1.83923864737869E-12
     -1.33514892283201E-22  -3.53040387497339E-08  -3.53021995110867E-08  -3.27458229329785E-18
      7.47389104328082E-07
      0.00000000000000E+00  -4.70493035292997E-11   0.00000000000000E+00   2.88179341276743E-13   3.82521518114164E-22
      4.70489892160638E-08   4.70492773954055E-08  -6.67614905472485E-19  -3.02704288829813E-01  -3.02704288829662E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50542348971856E-10   0.00000000000000E+00  -1.50542348971856E-10
      3.68642647059504E-18  -4.94545283876724E-01  -4.79770623226581E-01   0.00000000000000E+00   2.16223814093104E-12
     -1.22626569508042E-22  -4.69008972845744E-08  -4.68987350464336E-08  -3.01881156512256E-18
      7.49389104328082E-07
      0.00000000000000E+00  -5.98152627774599E-11   0.00000000000000E+00   3.17474343059381E-13   3.11508286864306E-22
      5.98149527234606E-08   5.98152701978040E-08  -6.22804766323125E-19  -3.27627893343278E-01  -3.27627893343115E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63158198263461E-10   0.00000000000000E+00  -1.63158198263461E-10
      3.36011007406812E-18  -4.00046477187900E-01  -3.81253355807181E-01   0.00000000000000E+00   2.03851356244566E-12
     -1.10745502828503E-22  -5.96541505131028E-08  -5.96521119995405E-08  -2.73730530774500E-18
      7.51389104328082E-07
      0.00000000000000E+00  -7.19055202939843E-11   0.00000000000000E+00   3.01271594321463E-13   2.42706860058511E-22
      7.19051861877222E-08   7.19054874593168E-08  -5.78520066857472E-19  -3.52025715970256E-01  -3.52025715970080E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.76558415849120E-10   0.00000000000000E+00  -1.76558415849120E-10
      3.00699324236988E-18  -2.83730577004512E-01  -2.61131938841723E-01   0.00000000000000E+00   1.68913912713520E-12
     -9.72284097181720E-23  -7.17306181825947E-08  -7.17289290434677E-08  -2.42847317551241E-18
      7.53389104328082E-07
      0.00000000000000E+00  -7.83918711697915E-11   0.00000000000000E+00   1.62149612409150E-13   1.59924976655876E-22
      7.83917363915815E-08   7.83918985411940E-08  -5.35390218488425E-19  -3.75887695572583E-01  -3.75887695572383E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.00231312078423E-10   0.00000000000000E+00  -2.00231312078423E-10
      2.60653061821304E-18  -1.56994091424421E-01  -1.32358759450210E-01   0.00000000000000E+00   1.06448254319043E-12
     -8.30087393055006E-23  -7.81927317116587E-08  -7.81916672291156E-08  -2.07114039972461E-18
      7.55389104328082E-07
      0.00000000000000E+00  -6.41311388235788E-11   0.00000000000000E+00  -3.54545095085375E-13   5.13361689367032E-23
      6.41314503971632E-08   6.41310958520681E-08  -4.89065414948894E-19  -3.99272935376998E-01  -3.99272935376799E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.98976911103215E-10   0.00000000000000E+00  -1.98976911103215E-10
      2.20857679600661E-18  -6.04980111681872E-02  -4.03551366391868E-02   0.00000000000000E+00   8.52003791283815E-13
     -4.55975363896898E-23  -6.39329709447561E-08  -6.39321189409649E-08  -1.71951138105771E-18
      7.57389104328082E-07
      0.00000000000000E+00  -3.43076831364995E-11   0.00000000000000E+00  -7.39142418865199E-13   1.51743002362826E-23
      3.43083905477420E-08   3.43076514053232E-08  -4.31993646694449E-19  -4.22316807084528E-01  -4.22316807084395E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33275892328667E-10   0.00000000000000E+00  -1.33275892328667E-10
      1.94202501134927E-18  -2.39766338112425E-02  -1.32093967189764E-02   0.00000000000000E+00   8.75770620484582E-13
     -1.55425289960081E-23  -3.41752512836150E-08  -3.41743755129945E-08  -1.51003136465482E-18
      7.59389104328082E-07
      0.00000000000000E+00  -2.14744935407035E-11   0.00000000000000E+00  -3.16750833714622E-13   6.91307765293635E-24
      2.14747804690407E-08   2.14744637182070E-08  -3.75172005250145E-19  -4.44953245713119E-01  -4.44953245713014E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04710709021079E-10   0.00000000000000E+00  -1.04710709021079E-10
      1.73260359330711E-18  -1.31543830740261E-02  -6.42145756445631E-03   0.00000000000000E+00   3.78552726816771E-13
     -7.61771011204081E-24  -2.13701315619128E-08  -2.13697530091860E-08  -1.35743158805697E-18
      7.61389104328082E-07
      0.00000000000000E+00  -1.76540280070820E-11   0.00000000000000E+00  -9.39225893567199E-14   4.63785136230244E-24
      1.76541444520677E-08   1.76540505294783E-08  -3.20951979663651E-19  -4.67143930627638E-01  -4.67143930627538E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97979254928919E-11   0.00000000000000E+00  -9.97979254928919E-11
      1.53300774232133E-18  -9.97209866741147E-03  -4.44130995291971E-03   0.00000000000000E+00   1.37323224558784E-13
     -5.16839879142252E-24  -1.75543899272100E-08  -1.75542526039854E-08  -1.21205576265768E-18
      7.63389104328082E-07
      0.00000000000000E+00  -1.66123249976742E-11   0.00000000000000E+00  -2.53589409414377E-14   3.75399077039775E-24
      1.66123921894525E-08   1.66123668305115E-08  -2.69312889934936E-19  -4.88885479524699E-01  -4.88885479524598E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01075729541140E-10   0.00000000000000E+00  -1.01075729541140E-10
      1.33085628323905E-18  -8.86993289592598E-03  -3.66774435416985E-03   0.00000000000000E+00   6.12157855812932E-14
     -4.14355855264028E-24  -1.65113523167560E-08  -1.65112911009704E-08  -1.06154339330412E-18
      7.65389104328082E-07
      0.00000000000000E+00  -1.63151154280706E-11   0.00000000000000E+00  -7.02488904671858E-15   3.27483392637864E-24
      1.63150958446326E-08   1.63150888197435E-08  -2.20158598739652E-19  -5.10184531100244E-01  -5.10184531100141E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03433994253467E-10   0.00000000000000E+00  -1.03433994253467E-10
      1.12398829473212E-18  -8.36047373824839E-03  -3.25268790042227E-03   0.00000000000000E+00   3.82173034000049E-14
     -3.55482387070987E-24  -1.62116930427935E-08  -1.62116548254901E-08  -9.03829695992467E-19
      7.67389104328082E-07
      0.00000000000000E+00  -1.62128003908215E-11   0.00000000000000E+00  -2.24467684247307E-15   2.95589114351107E-24
      1.62127801231343E-08   1.62127778784574E-08  -1.73380942464890E-19  -5.31049925510271E-01  -5.31049925510165E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05563825851196E-10   0.00000000000000E+00  -1.05563825851196E-10
      9.12860643029727E-19  -8.05486818785381E-03  -2.97998558262221E-03   0.00000000000000E+00   2.99646804757283E-14
     -3.14858626015787E-24  -1.61072440172867E-08  -1.61072140526062E-08  -7.39479700564836E-19
      7.69389104328082E-07
      0.00000000000000E+00  -1.61663269537944E-11   0.00000000000000E+00  -8.94527188256476E-16   2.72111541885476E-24
      1.61663114778578E-08   1.61663105833306E-08  -1.28838911447279E-19  -5.51489912927189E-01  -5.51489912927082E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07171922732338E-10   0.00000000000000E+00  -1.07171922732338E-10
      6.98516797565051E-19  -7.84184701335627E-03  -2.78210955786962E-03   0.00000000000000E+00   2.58504966476023E-14
     -2.84444577619102E-24  -1.60591645110949E-08  -1.60591386605983E-08  -5.69677886117772E-19
      7.71389104328082E-07
      0.00000000000000E+00  -1.61396919800043E-11   0.00000000000000E+00  -4.36247064865544E-16   2.53901051497689E-24
      1.61396476213308E-08   1.61396471850837E-08  -8.63743712494124E-20  -5.71509536491499E-01  -5.71509536491391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08222010890493E-10   0.00000000000000E+00  -1.08222010890493E-10
      4.82072775784064E-19  -7.68172073253595E-03  -2.63071308283597E-03   0.00000000000000E+00   2.31411529895406E-14
     -2.60713602848763E-24  -1.60314483153462E-08  -1.60314251741932E-08  -3.95698404534651E-19
      7.73389104328082E-07
      0.00000000000000E+00  -1.61219659457232E-11   0.00000000000000E+00  -2.43068808340463E-16   2.39310820519613E-24
      1.61219853751895E-08   1.61219851321207E-08  -4.58771733281211E-20  -5.91086991641316E-01  -5.91086991641207E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08615523076141E-10   0.00000000000000E+00  -1.08615523076141E-10
      2.64841729631783E-19  -7.55584234819413E-03  -2.51052177457568E-03   0.00000000000000E+00   2.10599512649265E-14
     -2.41696504805988E-24  -1.60133906689958E-08  -1.60133696090445E-08  -2.18964556303663E-19
      7.75389104328082E-07
      0.00000000000000E+00  -1.61079137009305E-11   0.00000000000000E+00  -1.58826908979904E-16   2.27432652553354E-24
      1.61078826150757E-08   1.61078824562488E-08  -7.68967479423254E-21  -6.09974884168739E-01  -6.09974884168632E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07118869289093E-10   0.00000000000000E+00  -1.07118869289093E-10
      5.06039910535977E-20  -7.45372029379686E-03  -2.41237014370864E-03   0.00000000000000E+00   1.90976417217166E-14
     -2.26283608651831E-24  -1.60007826846014E-08  -1.60007635869597E-08  -4.29143162593657E-20
      7.77389104328082E-07
      0.00000000000000E+00  -1.60817379508263E-11   0.00000000000000E+00  -4.76474274721286E-16   2.18880336256846E-24
      1.60817415965606E-08   1.60817411200863E-08   2.73796438139920E-20  -6.27666469148370E-01  -6.27666469148268E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02116153866483E-10   0.00000000000000E+00  -1.02116153866483E-10
     -1.53628316679368E-19  -7.39206650913994E-03  -2.35737538601239E-03   0.00000000000000E+00   1.72380459050264E-14
     -2.15395837951483E-24  -1.59796422042658E-08  -1.59796249662198E-08   1.26248672865376E-19
      7.79389104328082E-07
      0.00000000000000E+00  -1.60605218165314E-11   0.00000000000000E+00  -3.74081648484543E-16   2.12335473809652E-24
      1.60604865195811E-08   1.60604861454995E-08   5.79465337182653E-20  -6.43351912756962E-01  -6.43351912756870E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.18750505953667E-11   0.00000000000000E+00  -9.18750505953667E-11
     -3.37378417870102E-19  -7.35077759970551E-03  -2.31955567871539E-03   0.00000000000000E+00   1.45006986423837E-14
     -2.07166122029675E-24  -1.59686255956027E-08  -1.59686110949041E-08   2.79431884151836E-19
      7.81389104328082E-07
      0.00000000000000E+00  -1.60359074269598E-11   0.00000000000000E+00  -4.91737886234444E-16   2.07457431235943E-24
      1.60358816761126E-08   1.60358811843747E-08   8.17770018020735E-20  -6.55746081861293E-01  -6.55746081861219E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34240103071961E-11   0.00000000000000E+00  -7.34240103071961E-11
     -4.84226438484494E-19  -7.32031290927266E-03  -2.29102918713947E-03   0.00000000000000E+00   1.10547871889156E-14
     -2.01182328593934E-24  -1.59624682288547E-08  -1.59624571740675E-08   4.02449436682420E-19
      7.83389104328082E-07
      0.00000000000000E+00  -1.60000879794488E-11   0.00000000000000E+00  -8.16488775033321E-16   2.04466747751393E-24
      1.60001085657516E-08   1.60001077492629E-08   9.57466457227070E-20  -6.63075820111899E-01  -6.63075820111855E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.37503694337596E-11   0.00000000000000E+00  -4.37503694337596E-11
     -5.71727177352013E-19  -7.30039435893340E-03  -2.27303208062718E-03   0.00000000000000E+00   6.47025663976325E-15
     -1.97784147399156E-24  -1.59563638500857E-08  -1.59563573798291E-08   4.75980531629307E-19
      7.85389104328082E-07
      0.00000000000000E+00  -1.59499407529335E-11   0.00000000000000E+00  -1.23877324471117E-15   2.03800871010483E-24
      1.59499329619129E-08   1.59499317231396E-08   9.60097519477869E-20  -6.63211532006855E-01  -6.63211532006854E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.36052881087278E-13   0.00000000000000E+00  -8.36052881087278E-13
     -5.73399283114188E-19  -7.29314500223941E-03  -2.26807065259046E-03   0.00000000000000E+00   3.01235323358466E-16
     -1.97590320614591E-24  -1.59490959714938E-08  -1.59490956702585E-08   4.77389531166401E-19
      7.87389104328082E-07
      0.00000000000000E+00  -1.58831696289836E-11   0.00000000000000E+00   6.77819833274916E-15   2.06230016550882E-24
      1.58832109234486E-08   1.58832177016469E-08   7.79698962505197E-20  -6.53747667020936E-01  -6.53747667020992E-01
      0.00000000000000E+00   0.00000000000000E+00   5.63963795880148E-11   0.00000000000000E+00   5.63963795880148E-11
     -4.60606523938158E-19  -7.30275456828644E-03  -2.28067078150983E-03   0.00000000000000E+00  -1.64418944054254E-14
     -2.01718675705883E-24  -1.59395976393405E-08  -1.59396140812349E-08   3.82636627687638E-19
      7.89389104328083E-07
      0.00000000000000E+00  -1.57971111102202E-11   0.00000000000000E+00  -1.63105436468009E-15   2.13245172330108E-24
      1.57971430622603E-08   1.57971414312059E-08   3.56940203292185E-20  -6.31893107665620E-01  -6.31893107665749E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28718701687754E-10   0.00000000000000E+00   1.28718701687754E-10
     -2.03169120562651E-19  -7.33730531092367E-03  -2.31955377013242E-03   0.00000000000000E+00  -1.98564198616886E-14
     -2.12461184573286E-24  -1.59258402764739E-08  -1.59258601328937E-08   1.67475100233433E-19
      7.91389104328083E-07
      0.00000000000000E+00  -1.56698143044506E-11   0.00000000000000E+00  -3.52207972556303E-15   2.29930461412537E-24
      1.56698028121755E-08   1.56697992900957E-08  -3.92636331609445E-20  -5.94303757327341E-01  -5.94303757327556E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15698853696827E-10   0.00000000000000E+00   2.15698853696827E-10
      2.28228586831003E-19  -7.44842231759444E-03  -2.44338982314648E-03   0.00000000000000E+00  -3.50825486347530E-14
     -2.37925035946005E-24  -1.58854630612439E-08  -1.58854981437926E-08  -1.88964953670058E-19
      7.93389104328083E-07
      0.00000000000000E+00  -1.54603164588802E-11   0.00000000000000E+00  -8.83155504970115E-15   2.70882828021489E-24
      1.54602891456203E-08   1.54602803140652E-08  -1.59677502501856E-19  -5.37238883670538E-01  -5.37238883670848E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09869843945139E-10   0.00000000000000E+00   3.09869843945139E-10
      8.47968274721281E-19  -7.78123526729941E-03  -2.81254934165385E-03   0.00000000000000E+00  -5.73708605842878E-14
     -3.04996377604135E-24  -1.57700927871498E-08  -1.57701501580103E-08  -6.88290772219426E-19
      7.95389104328083E-07
      0.00000000000000E+00  -1.49755599358989E-11   0.00000000000000E+00  -1.41078343611107E-14   3.81921910133640E-24
      1.49755233742219E-08   1.49755092663876E-08  -3.43698072281123E-19  -4.57595869910522E-01  -4.57595869910905E-01
      0.00000000000000E+00   0.00000000000000E+00   3.83280624964574E-10   0.00000000000000E+00   3.83280624964574E-10
      1.61452952465043E-18  -8.90991144942187E-03  -4.07084455143839E-03   0.00000000000000E+00  -1.05865839586777E-13
     -5.54300256655091E-24  -1.53586840255125E-08  -1.53587898913521E-08  -1.27083145236931E-18
      7.97389104328083E-07
      0.00000000000000E+00  -1.20242211504722E-11   0.00000000000000E+00  -1.11488442344024E-13   5.72007546183012E-24
      1.20242928891219E-08   1.20241814006795E-08  -5.96930268364992E-19  -3.54465927175034E-01  -3.54465927175432E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98048497756289E-10   0.00000000000000E+00   3.98048497756289E-10
      2.41062652016300E-18  -1.57527716671455E-02  -1.18389330364136E-02   0.00000000000000E+00  -1.53761484763154E-13
     -2.60641007683619E-23  -1.24220761369510E-08  -1.24222298984358E-08  -1.81369625179801E-18
      7.99389104328083E-07
      0.00000000000000E+00  -2.24284848260780E-12   0.00000000000000E+00  -2.50621403527604E-13  -2.56943187315240E-23
      2.24306998519557E-09   2.24281936379202E-09  -8.63560530776694E-19  -2.32651021434323E-01  -2.32651021434732E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08306124106398E-10   0.00000000000000E+00   4.08306124106398E-10
      3.22723876837580E-18  -4.15473808483602E-02  -4.07121090640544E-02   0.00000000000000E+00  -3.94858623249592E-13
     -8.05896988699590E-23  -2.65073062927508E-09  -2.65112548789841E-09  -2.36367823759911E-18
      8.01389104328083E-07
      0.00000000000000E+00   1.40522447927516E-14   0.00000000000000E+00  -6.29136145800076E-14  -4.42568598308007E-23
     -1.39613433924635E-11  -1.40242570070878E-11  -1.11571606094606E-18  -1.09723897450032E-01  -1.09723897450398E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65815546928430E-10   0.00000000000000E+00   3.65815546928430E-10
      3.95886986223266E-18  -7.13138968583258E-02  -7.12030614152698E-02   0.00000000000000E+00  -1.10527937880678E-12
     -9.42390033216235E-23  -3.50686010542442E-10  -3.51791289921343E-10  -2.84315380128660E-18
      8.03389104328083E-07
      0.00000000000000E+00   6.72303476359096E-14   0.00000000000000E+00  -6.44069943034509E-15  -4.61127615756598E-23
     -6.72284792372500E-11  -6.72349199367264E-11  -1.25364412661173E-18  -4.07074244567725E-02  -4.07074244569981E-02
      0.00000000000000E+00   0.00000000000000E+00   2.25548444691088E-10   0.00000000000000E+00   2.25548444691088E-10
      4.40996675161484E-18  -1.00857003016566E-01  -1.00807124832132E-01   0.00000000000000E+00  -1.08007308092440E-12
     -1.02841926636331E-22  -1.57233451673334E-10  -1.58313524754361E-10  -3.15632262500311E-18
      8.05389104328083E-07
      0.00000000000000E+00   2.17672027181838E-14   0.00000000000000E+00  -8.20833240626322E-18  -4.63956705329506E-23
     -2.17326858219682E-11  -2.17326940303470E-11  -1.30181511410118E-18  -1.80127349067971E-02  -1.80127349069183E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21196290562708E-10   0.00000000000000E+00   1.21196290562708E-10
      4.65235933274025E-18  -1.29913050833105E-01  -1.29881714223013E-01   0.00000000000000E+00  -6.21625680515142E-13
     -1.06821482629763E-22  -9.88419708517393E-11  -9.94635965323613E-11  -3.35054421863908E-18
      8.07389104328083E-07
      0.00000000000000E+00  -4.68408159758386E-15   0.00000000000000E+00   8.21471776460934E-16  -4.61939991297691E-23
      4.72273925362207E-12   4.72356072535234E-12  -1.31682249907651E-18  -1.14374046732113E-02  -1.14374046732879E-02
      0.00000000000000E+00   0.00000000000000E+00   7.66053511200601E-11   0.00000000000000E+00   7.66053511200601E-11
      4.80557003498038E-18  -1.58405924023324E-01  -1.58380301092164E-01   0.00000000000000E+00  -4.41688585626370E-13
     -1.09398222042547E-22  -8.08872232596759E-11  -8.13289118454117E-11  -3.48874753590387E-18
      8.09389104328083E-07
      0.00000000000000E+00  -2.13079790321462E-14   0.00000000000000E+00   8.58091413945641E-16  -4.55388557003135E-23
      2.12972935313969E-11   2.12981516227653E-11  -1.32038534525836E-18  -9.41268263463827E-03  -9.41268263469451E-03
      0.00000000000000E+00   0.00000000000000E+00   5.62358585719839E-11   0.00000000000000E+00   5.62358585719839E-11
      4.91804175212435E-18  -1.86316177865063E-01  -1.86291750750422E-01   0.00000000000000E+00  -4.14107672034903E-13
     -1.11696011316641E-22  -7.71199025226028E-11  -7.75340101947494E-11  -3.59765640686598E-18
      8.11389104328083E-07
      0.00000000000000E+00  -3.37070185551623E-14   0.00000000000000E+00   6.79753656063341E-16  -4.40657462708120E-23
      3.36927204643792E-11   3.36934002179912E-11  -1.31970060644136E-18  -8.63094425056502E-03  -8.63094425061009E-03
      0.00000000000000E+00   0.00000000000000E+00   4.50719060686782E-11   0.00000000000000E+00   4.50719060686782E-11
      5.00818556426170E-18  -2.13648618137149E-01  -2.13623803291286E-01   0.00000000000000E+00  -4.27764553972764E-13
     -1.13982540333414E-22  -7.83375417325830E-11  -7.87653062866697E-11  -3.68848495782035E-18
      8.13389104328083E-07
      0.00000000000000E+00  -4.39936291224053E-14   0.00000000000000E+00   5.31491885176558E-16  -4.12361421609508E-23
      4.40104303860095E-11   4.40109618778535E-11  -1.31733319605052E-18  -8.22501426777722E-03  -8.22501426781524E-03
      0.00000000000000E+00   0.00000000000000E+00   3.80270521397045E-11   0.00000000000000E+00   3.80270521397045E-11
      5.08423966854111E-18  -2.40417049791616E-01  -2.40391204092452E-01   0.00000000000000E+00  -4.47749159523299E-13
     -1.16301779229443E-22  -8.15902648579177E-11  -8.20380140175573E-11  -3.76690647249059E-18
      8.15389104328083E-07
      0.00000000000000E+00  -5.30862581059505E-14   0.00000000000000E+00   4.29540171419704E-16  -3.64397929481584E-23
      5.31197511746922E-11   5.31201807148272E-11  -1.31433489411691E-18  -7.96319088673246E-03  -7.96319088676569E-03
      0.00000000000000E+00   0.00000000000000E+00   3.32227380823996E-11   0.00000000000000E+00   3.32227380823996E-11
      5.15068514470591E-18  -2.66635877576008E-01  -2.66608675866912E-01   0.00000000000000E+00  -4.66543679448294E-13
     -1.18651657747299E-22  -8.58763751176595E-11  -8.63429187972264E-11  -3.83635025058900E-18
      8.17389104328083E-07
      0.00000000000000E+00  -6.14441291918354E-14   0.00000000000000E+00   3.65520138375129E-16  -2.90758411339937E-23
      6.14474889226830E-11   6.14478544427923E-11  -1.31118184771526E-18  -7.77401656827690E-03  -7.77401656830669E-03
      0.00000000000000E+00   0.00000000000000E+00   2.97884513947741E-11   0.00000000000000E+00   2.97884513947741E-11
      5.21026204749546E-18  -2.92314821535979E-01  -2.92286078455561E-01   0.00000000000000E+00  -4.83884297107888E-13
     -1.21026705925292E-22  -9.07524215403381E-11  -9.12363058375670E-11  -3.89908019978019E-18
      8.19389104328083E-07
      0.00000000000000E+00  -6.92509318544752E-14   0.00000000000000E+00   3.17681830066988E-16  -1.86897685802066E-23
      6.92484763715637E-11   6.92487940533750E-11  -1.30809242424419E-18  -7.62897251355123E-03  -7.62897251357846E-03
      0.00000000000000E+00   0.00000000000000E+00   2.72294805441931E-11   0.00000000000000E+00   2.72294805441931E-11
      5.26472100858384E-18  -3.17457505024739E-01  -3.17427110787766E-01   0.00000000000000E+00  -5.00969791041407E-13
     -1.23425810137246E-22  -9.59773048064030E-11  -9.64782745975678E-11  -3.95662858433965E-18
      8.21389104328083E-07
      0.00000000000000E+00  -7.66903555682848E-14   0.00000000000000E+00   2.88161061000618E-16  -5.16880313756669E-24
      7.66956430398865E-11   7.66959312009423E-11  -1.30515840025167E-18  -7.51340975086255E-03  -7.51340975088779E-03
      0.00000000000000E+00   0.00000000000000E+00   2.52413188064290E-11   0.00000000000000E+00   2.52413188064290E-11
      5.31520364619670E-18  -3.42071350032839E-01  -3.42039236309632E-01   0.00000000000000E+00  -5.19294531572795E-13
     -1.25853778979034E-22  -1.01417955475673E-10  -1.01937250007371E-10  -4.01004524594503E-18
      8.23389104328083E-07
      0.00000000000000E+00  -8.39460898076795E-14   0.00000000000000E+00   2.68951636489710E-16   1.08450579200622E-23
      8.39201047455748E-11   8.39203736972222E-11  -1.30239869314918E-18  -7.42386140375325E-03  -7.42386140377686E-03
      0.00000000000000E+00   0.00000000000000E+00   2.36080659244648E-11   0.00000000000000E+00   2.36080659244648E-11
      5.36241977804563E-18  -3.66155861759821E-01  -3.66121986934982E-01   0.00000000000000E+00  -5.39572106552846E-13
     -1.28317158628894E-22  -1.06988867515005E-10  -1.07528439621686E-10  -4.06002108489645E-18
      8.25389104328083E-07
      0.00000000000000E+00  -9.10181345726590E-14   0.00000000000000E+00   2.58792442807074E-16   2.77974200436170E-23
      9.10578537696541E-11   9.10581125621247E-11  -1.29977234630791E-18  -7.37404751434152E-03  -7.37404751436369E-03
      0.00000000000000E+00   0.00000000000000E+00   2.21753042168067E-11   0.00000000000000E+00   2.21753042168067E-11
      5.40677038647924E-18  -3.89714309247172E-01  -3.89678637514163E-01   0.00000000000000E+00  -5.62176890343175E-13
     -1.30822301005237E-22  -1.12671239888458E-10  -1.13233416778932E-10  -4.10699804017133E-18
      8.27389104328083E-07
      0.00000000000000E+00  -9.80901793376386E-14   0.00000000000000E+00   2.49373019547866E-16   4.46644123417959E-23
      9.80982709430209E-11   9.80985203160851E-11  -1.29730220961150E-18  -7.33753647722842E-03  -7.33753647724947E-03
      0.00000000000000E+00   0.00000000000000E+00   2.10459691553438E-11   0.00000000000000E+00   2.10459691553438E-11
      5.44886232478993E-18  -4.12902367903953E-01  -4.12864834377657E-01   0.00000000000000E+00  -5.93844853562115E-13
     -1.33402323129796E-22  -1.18550644617733E-10  -1.19144489471428E-10  -4.15156011517843E-18
      8.29389104328083E-07
      0.00000000000000E+00  -1.05070379365411E-13   0.00000000000000E+00   2.42172183273189E-16   6.05622913080453E-23
      1.05075736603983E-10   1.05075978776226E-10  -1.29497656927635E-18  -7.31107925497848E-03  -7.31107925499849E-03
      0.00000000000000E+00   0.00000000000000E+00   2.00128134063021E-11   0.00000000000000E+00   2.00128134063021E-11
      5.48888795160253E-18  -4.35714830774804E-01  -4.35675425038516E-01   0.00000000000000E+00  -6.29139373537846E-13
     -1.36061433907817E-22  -1.24459652808854E-10  -1.25088792182528E-10  -4.19391138232618E-18
      8.31389104328083E-07
      0.00000000000000E+00  -1.11958734655975E-13   0.00000000000000E+00   2.36132193899461E-16   7.48287089400554E-23
      1.11991458762446E-10   1.11991694894715E-10  -1.29278003172106E-18  -7.29574476129662E-03  -7.29574476131561E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89954932330455E-11   0.00000000000000E+00   1.89954932330455E-11
      5.52687893806863E-18  -4.58090203801921E-01  -4.58048940374792E-01   0.00000000000000E+00  -6.65658691397599E-13
     -1.38789885223621E-22  -1.30321529436225E-10  -1.30987188127762E-10  -4.23409890634757E-18
      8.33389104328084E-07
      0.00000000000000E+00  -1.18847089946540E-13   0.00000000000000E+00   2.31393046309362E-16   8.71225988881885E-23
      1.18856458771259E-10   1.18856690164392E-10  -1.29069229413197E-18  -7.29438221118076E-03  -7.29438221119877E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80098023039371E-11   0.00000000000000E+00   1.80098023039371E-11
      5.56289854267650E-18  -4.80015650634119E-01  -4.79972535590662E-01   0.00000000000000E+00  -7.04324325105675E-13
     -1.41578709220214E-22  -1.36162168143082E-10  -1.36866492468329E-10  -4.27220624854453E-18
      8.35389104328084E-07
      0.00000000000000E+00  -1.25735445237104E-13   0.00000000000000E+00   2.28310995377463E-16   9.74045620145619E-23
      1.25694360177620E-10   1.25694588488713E-10  -1.28868783105348E-18  -7.31239222624251E-03  -7.31239222625957E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70597986898822E-11   0.00000000000000E+00   1.70597986898822E-11
      5.59701814005627E-18  -5.01495327926620E-01  -5.01450358625089E-01   0.00000000000000E+00  -7.44600403537123E-13
     -1.44414174792570E-22  -1.42009786774914E-10  -1.42754387178596E-10  -4.30833030900279E-18
      8.37389104328084E-07
      0.00000000000000E+00  -1.32531955790461E-13   0.00000000000000E+00   2.27800191465824E-16   1.05856636351438E-22
      1.32554463304931E-10   1.32554691105228E-10  -1.28673145264209E-18  -7.35984410357760E-03  -7.35984410359374E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61432048470817E-11   0.00000000000000E+00   1.61432048470817E-11
      5.62930454975043E-18  -5.22537687573416E-01  -5.22490846563423E-01   0.00000000000000E+00  -7.85122308602524E-13
     -1.47276624344160E-22  -1.47912773643559E-10  -1.48697895952309E-10  -4.34257309710834E-18
      8.39389104328084E-07
      0.00000000000000E+00  -1.39971379504271E-13   0.00000000000000E+00   2.50171497952120E-16   1.13063771748457E-22
      1.39958979689628E-10   1.39959229861239E-10  -1.28458958598022E-18  -7.53938208200872E-03  -7.53938208202382E-03
      0.00000000000000E+00   0.00000000000000E+00   1.51014227481067E-11   0.00000000000000E+00   1.51014227481067E-11
      5.65950739524664E-18  -5.43151380168856E-01  -5.43102535461942E-01   0.00000000000000E+00  -8.20138990764231E-13
     -1.50128701733912E-22  -1.54240513618431E-10  -1.55060652609346E-10  -4.37491780926642E-18
      8.41389104328084E-07
      0.00000000000000E+00  -1.48880319013401E-13   0.00000000000000E+00   3.14486524744590E-16   1.19880438964330E-22
      1.48909128786004E-10   1.48909443272649E-10  -1.28181287712935E-18  -8.04676559144609E-03  -8.04676559145985E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37635666178607E-11   0.00000000000000E+00   1.37635666178607E-11
      5.68703452848237E-18  -5.63343447905785E-01  -5.63292205963564E-01   0.00000000000000E+00  -8.42999090410590E-13
     -1.52919078062821E-22  -1.61830010799946E-10  -1.62673009890509E-10  -4.40522165135302E-18
      8.43389104328084E-07
      0.00000000000000E+00  -1.66606353294454E-13   0.00000000000000E+00   6.70714426542957E-16   1.30649810170479E-22
      1.66595053499493E-10   1.66595724214050E-10  -1.27561066032041E-18  -1.01526682204093E-02  -1.01526682204195E-02
      0.00000000000000E+00   0.00000000000000E+00   1.01987990670177E-11   0.00000000000000E+00   1.01987990670177E-11
      5.70743212661640E-18  -5.83110527608500E-01  -5.83054838219034E-01   0.00000000000000E+00  -7.97378394346213E-13
     -1.55434901236109E-22  -1.75997144886567E-10  -1.76794523281068E-10  -4.43182146629599E-18
      8.45389104328084E-07
      0.00000000000000E+00  -2.68554011594808E-13   0.00000000000000E+00   3.77046385145126E-15   1.82222672002397E-22
      2.68530049594913E-10   2.68533820058947E-10  -1.24300194358088E-18  -2.41778584525181E-02  -2.41778584525058E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.23259666344020E-11   0.00000000000000E+00  -1.23259666344020E-11
      5.68278019334760E-18  -6.02335211031400E-01  -6.02254508261773E-01   0.00000000000000E+00  -2.17862831290008E-13
     -1.56097896943326E-22  -2.55989990593098E-10  -2.56207853424544E-10  -4.43977824976671E-18
      8.47389104328084E-07
      0.00000000000000E+00  -5.99654289227942E-13   0.00000000000000E+00   1.03815521288841E-14   2.78351618690731E-22
      5.99688312361776E-10   5.99698693914184E-10  -1.17415052395968E-18  -5.28927111575020E-02  -5.28927111574578E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.42615535104673E-11   0.00000000000000E+00  -4.42615535104673E-11
      5.59425708632666E-18  -6.20602809176377E-01  -6.20427852234443E-01   0.00000000000000E+00   4.87638206346038E-13
     -1.54583268403255E-22  -5.55924778609908E-10  -5.55437140403717E-10  -4.42010656236698E-18
      8.49389104328084E-07
      0.00000000000000E+00  -1.26010979448727E-12   0.00000000000000E+00   1.81892730719066E-14   3.41534442301381E-22
      1.26010038576369E-09   1.26011857503710E-09  -1.09967161917231E-18  -8.26471452690582E-02  -8.26471452690027E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.54784592554257E-11   0.00000000000000E+00  -5.54784592554257E-11
      5.48330016781581E-18  -6.37254472922839E-01  -6.36875020334494E-01   0.00000000000000E+00   4.77456754368754E-13
     -1.53049707766634E-22  -1.20511757253589E-09  -1.20464011578168E-09  -4.38362854864350E-18
      8.51389104328084E-07
      0.00000000000000E+00  -2.48945160201001E-12   0.00000000000000E+00   3.19288359080099E-14   3.82921016980293E-22
      2.48939527136136E-09   2.48942720019765E-09  -1.02841370771075E-18  -1.12020065836756E-01  -1.12020065836690E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57315914741898E-11   0.00000000000000E+00  -6.57315914741898E-11
      5.35183698486743E-18  -6.51217970003323E-01  -6.50454518636850E-01   0.00000000000000E+00   3.92934353663571E-13
     -1.51728571200534E-22  -2.42408854307698E-09  -2.42369560872347E-09  -4.32342327715667E-18
      8.53389104328084E-07
      0.00000000000000E+00  -4.56358130236759E-12   0.00000000000000E+00   5.25420260037116E-14   4.15709580174765E-22
      4.56351541025992E-09   4.56356795228634E-09  -9.63991094260794E-19  -1.40866105274294E-01  -1.40866105274215E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.87418672120582E-11   0.00000000000000E+00  -7.87418672120582E-11
      5.19435325044331E-18  -6.60914567015953E-01  -6.59501862443000E-01   0.00000000000000E+00   2.94971332363014E-13
     -1.50672412193386E-22  -4.48512105640649E-09  -4.48482608507428E-09  -4.23036215618252E-18
      8.55389104328084E-07
      0.00000000000000E+00  -7.71449870174621E-12   0.00000000000000E+00   7.89198123406321E-14   4.40307010952466E-22
      7.71440499085514E-09   7.71448391066792E-09  -9.06714008408798E-19  -1.69136972395277E-01  -1.69136972395182E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.43228999011629E-11   0.00000000000000E+00  -9.43228999011629E-11
      5.00570745064099E-18  -6.64346234159229E-01  -6.61945897766363E-01   0.00000000000000E+00   2.36854483278973E-13
     -1.49755523036984E-22  -7.62039786524989E-09  -7.62016101076676E-09  -4.09899344223219E-18
      8.57389104328084E-07
      0.00000000000000E+00  -1.21086264639659E-11   0.00000000000000E+00   1.09461321720667E-13   4.53929178156811E-22
      1.21085435296483E-08   1.21086529909705E-08  -8.54955930975231E-19  -1.96825183465633E-01  -1.96825183465523E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10007739831282E-10   0.00000000000000E+00  -1.10007739831282E-10
      4.78569197097842E-18  -6.59225583019461E-01  -6.55446006512986E-01   0.00000000000000E+00   3.21245698175682E-13
     -1.48486649414316E-22  -1.19989664968372E-08  -1.19986452511392E-08  -3.93073604000319E-18
      8.59389104328084E-07
      0.00000000000000E+00  -1.79296540634418E-11   0.00000000000000E+00   1.44616192339041E-13   4.55343762476087E-22
      1.79295081484208E-08   1.79296527646136E-08  -8.06664701794550E-19  -2.23940338809652E-01  -2.23940338809529E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23172653462020E-10   0.00000000000000E+00  -1.23172653462020E-10
      4.53934666405438E-18  -6.42946680048178E-01  -6.37337565450709E-01   0.00000000000000E+00   6.41003336724465E-13
     -1.45986269330994E-22  -1.78071211144882E-08  -1.78064801111516E-08  -3.73268196225983E-18
      8.61389104328084E-07
      0.00000000000000E+00  -2.54555036749637E-11   0.00000000000000E+00   1.86750951090847E-13   4.44985465454065E-22
      2.54552853702612E-08   2.54554721212128E-08  -7.60172007766492E-19  -2.50497257393101E-01  -2.50497257392968E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32978697642745E-10   0.00000000000000E+00  -1.32978697642745E-10
      4.27338926876890E-18  -6.12408673267667E-01  -6.04431812402495E-01   0.00000000000000E+00   1.18880797591014E-12
     -1.41183099506488E-22  -2.53236822315458E-08  -2.53224934235700E-08  -3.51321726100241E-18
      8.63389104328084E-07
      0.00000000000000E+00  -3.49892629313166E-11   0.00000000000000E+00   2.36545665249265E-13   4.22866583239535E-22
      3.49890095283118E-08   3.49892460739775E-08  -7.14429697818858E-19  -2.76509072368035E-01  -2.76509072367894E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40844078546981E-10   0.00000000000000E+00  -1.40844078546981E-10
      3.99170111167493E-18  -5.63973733044781E-01  -5.52995754240718E-01   0.00000000000000E+00   1.78940564167777E-12
     -1.33245835938206E-22  -3.48501914010720E-08  -3.48484019954305E-08  -3.27727141385608E-18
      8.65389104328084E-07
      0.00000000000000E+00  -4.65155019166496E-11   0.00000000000000E+00   2.86195613634702E-13   3.82515139375966E-22
      4.65152382724658E-08   4.65155244680798E-08  -6.69078323150521E-19  -3.01982856363711E-01  -3.01982856363560E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50073716867770E-10   0.00000000000000E+00  -1.50073716867770E-10
      3.69155367793939E-18  -4.94077480238288E-01  -4.79470820568189E-01   0.00000000000000E+00   2.11587862999601E-12
     -1.22565609269202E-22  -4.63675666298419E-08  -4.63654507512120E-08  -3.02247535478887E-18
      8.67389104328084E-07
      0.00000000000000E+00  -5.92348958830455E-11   0.00000000000000E+00   3.16291293192060E-13   3.12288382919028E-22
      5.92346144008407E-08   5.92349306921342E-08  -6.24229625775514E-19  -3.26922137451909E-01  -3.26922137451746E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62595952670033E-10   0.00000000000000E+00  -1.62595952670033E-10
      3.36636177259933E-18  -4.00715339223749E-01  -3.82104880715446E-01   0.00000000000000E+00   2.01266966225136E-12
     -1.10838147617041E-22  -5.90743474091263E-08  -5.90723347394642E-08  -2.74213214682381E-18
      8.69389104328084E-07
      0.00000000000000E+00  -7.13699736313272E-11   0.00000000000000E+00   3.02359748669099E-13   2.43710216328067E-22
      7.13696507108961E-08   7.13699530706450E-08  -5.79894949368213E-19  -3.51335611198535E-01  -3.51335611198359E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.75846934508680E-10   0.00000000000000E+00  -1.75846934508680E-10
      3.01466790358197E-18  -2.85428931595673E-01  -2.62998803596763E-01   0.00000000000000E+00   1.68253110893658E-12
     -9.74465973983612E-23  -7.11957886672452E-08  -7.11941061361363E-08  -2.43477295421375E-18
      8.71389104328084E-07
      0.00000000000000E+00  -7.80758334290604E-11   0.00000000000000E+00   1.67552689248496E-13   1.62172974784392E-22
      7.80756565191251E-08   7.80758240718146E-08  -5.36704125411654E-19  -3.75213406286545E-01  -3.75213406286346E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99273461000654E-10   0.00000000000000E+00  -1.99273461000654E-10
      2.61612098158066E-18  -1.59275727671816E-01  -1.34739685421924E-01   0.00000000000000E+00   1.06881407549197E-12
     -8.32523361192277E-23  -7.78776194248893E-08  -7.78765506108139E-08  -2.07941685616900E-18
      8.73389104328084E-07
      0.00000000000000E+00  -6.46463877993130E-11   0.00000000000000E+00  -3.33854312217991E-13   5.28209537238465E-23
      6.46467216614618E-08   6.46463878071497E-08  -4.90597265656364E-19  -3.98610798687632E-01  -3.98610798687432E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99726046037748E-10   0.00000000000000E+00  -1.99726046037748E-10
      2.21666888950516E-18  -6.17310236277290E-02  -4.14260362526331E-02   0.00000000000000E+00   8.42734632283076E-13
     -4.66526169608216E-23  -6.44475044957441E-08  -6.44466617611119E-08  -1.72607162384880E-18
      8.75389104328084E-07
      0.00000000000000E+00  -3.47199741618241E-11   0.00000000000000E+00  -7.41740319126267E-13   1.55304219809949E-23
      3.47207456491533E-08   3.47200039088342E-08  -4.33627651896470E-19  -4.21666083153508E-01  -4.21666083153374E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34275371450994E-10   0.00000000000000E+00  -1.34275371450994E-10
      1.94811814660317E-18  -2.43823909727601E-02  -1.34855504223117E-02   0.00000000000000E+00   8.81695861454508E-13
     -1.58558958755384E-23  -3.45866102332447E-08  -3.45857285373832E-08  -1.51449049470670E-18
      8.76389104328084E-07
      0.00000000000000E+00  -2.45295250344374E-11   0.00000000000000E+00  -5.03416603228646E-13   8.95525749344806E-24
      2.45300408800458E-08   2.45295374634426E-08  -4.04587704364360E-19  -4.33099512687367E-01  -4.33099512687256E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11196073592059E-10   0.00000000000000E+00  -1.11196073592059E-10
      1.83692207301111E-18  -1.59140347836189E-02  -8.22060133357553E-03   0.00000000000000E+00   5.76916529291795E-13
     -9.93720617059885E-24  -2.44189183063798E-08  -2.44183413898505E-08  -1.43233436864675E-18
      8.77739104328084E-07
      0.00000000000000E+00  -1.92520345897557E-11   0.00000000000000E+00  -1.92662548541319E-13   5.92881793567024E-24
      1.92521557541662E-08   1.92519630916177E-08  -3.66673940429444E-19  -4.48337254824425E-01  -4.48337254824324E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01023819898397E-10   0.00000000000000E+00  -1.01023819898397E-10
      1.70053991614828E-18  -1.16100260891659E-02  -5.57617664859410E-03   0.00000000000000E+00   2.44875794185473E-13
     -6.65759649803991E-24  -1.91511841475134E-08  -1.91509392717193E-08  -1.33386597571883E-18
      8.79561604328084E-07
      0.00000000000000E+00  -1.71426365103105E-11   0.00000000000000E+00  -5.67458221551011E-14   4.44917101737931E-24
      1.71426799468672E-08   1.71426232010451E-08  -3.17564293820343E-19  -4.68533731001946E-01  -4.68533731001846E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.91529760721357E-11   0.00000000000000E+00  -9.91529760721357E-11
      1.51983361725681E-18  -9.64046385571546E-03  -4.27060616040469E-03   0.00000000000000E+00   9.84029950180989E-14
     -4.96646012345133E-24  -1.70435686279680E-08  -1.70434702249729E-08  -1.20226932343647E-18
      8.81561604328084E-07
      0.00000000000000E+00  -1.64912736340347E-11   0.00000000000000E+00  -1.57271276300905E-14   3.69547138676126E-24
      1.64913011838469E-08   1.64912854567193E-08  -2.66117153510635E-19  -4.90247435629604E-01  -4.90247435629503E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01021633988687E-10   0.00000000000000E+00  -1.01021633988687E-10
      1.31779034927944E-18  -8.77862619403156E-03  -3.61456930865756E-03   0.00000000000000E+00   5.10882387779545E-14
     -4.07496108199920E-24  -1.63903149109694E-08  -1.63902638227306E-08  -1.05167319576880E-18
      8.83561604328085E-07
      0.00000000000000E+00  -1.62856332674270E-11   0.00000000000000E+00  -4.76507015889193E-15   3.24714467168886E-24
      1.62856630511406E-08   1.62856582860704E-08  -2.17124458859505E-19  -5.11518860755326E-01  -5.11518860755223E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03539970025403E-10   0.00000000000000E+00  -1.03539970025403E-10
      1.11071040922863E-18  -8.32680736586071E-03  -3.22832736702933E-03   0.00000000000000E+00   3.56867224019497E-14
     -3.52060277314905E-24  -1.61821540027674E-08  -1.61821183160450E-08  -8.93585950369126E-19
      8.85561604328085E-07
      0.00000000000000E+00  -1.62044425197356E-11   0.00000000000000E+00  -1.72582886869151E-15   2.93818397718902E-24
      1.62044466969513E-08   1.62044449711224E-08  -1.70494539248586E-19  -5.32357108265110E-01  -5.32357108265004E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05673574659479E-10   0.00000000000000E+00  -1.05673574659479E-10
      8.99363259909674E-19  -8.03705646553088E-03  -2.96483372865984E-03   0.00000000000000E+00   2.92488431003230E-14
     -3.12593364564381E-24  -1.60988006453060E-08  -1.60987713964629E-08  -7.28868720661088E-19
      8.87561604328085E-07
      0.00000000000000E+00  -1.61631123879922E-11   0.00000000000000E+00  -7.67073260484127E-16   2.70805754782528E-24
      1.61631179156494E-08   1.61631171485762E-08  -1.26089152074809E-19  -5.52770391921798E-01  -5.52770391921691E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07253201502279E-10   0.00000000000000E+00  -1.07253201502279E-10
      6.84856856905114E-19  -7.82986179643300E-03  -2.77115598524275E-03   0.00000000000000E+00   2.55663071562649E-14
     -2.82749857747240E-24  -1.60558895133810E-08  -1.60558639470739E-08  -5.58767704830305E-19
      8.89561604328085E-07
      0.00000000000000E+00  -1.61379469299973E-11   0.00000000000000E+00  -3.89366180328364E-16   2.52876515615151E-24
      1.61379576429477E-08   1.61379572535815E-08  -8.37514195440774E-20  -5.72763221799168E-01  -5.72763221799060E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08268544789865E-10   0.00000000000000E+00  -1.08268544789865E-10
      4.68319767325385E-19  -7.67269662830413E-03  -2.62223597821527E-03   0.00000000000000E+00   2.29655535021846E-14
     -2.59378977024224E-24  -1.60297116743451E-08  -1.60296887087916E-08  -3.84568347781308E-19
      8.91561604328085E-07
      0.00000000000000E+00  -1.61208638088767E-11   0.00000000000000E+00  -2.08782036016491E-16   2.38482371623301E-24
      1.61208540832632E-08   1.61208538744811E-08  -4.33834141114686E-20  -5.92307877816744E-01  -5.92307877816635E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08596763206074E-10   0.00000000000000E+00  -1.08596763206074E-10
      2.51126240913238E-19  -7.54867260809806E-03  -2.50370245943347E-03   0.00000000000000E+00   2.09110605528597E-14
     -2.40619232080963E-24  -1.60122780223356E-08  -1.60122571112751E-08  -2.07742826801770E-19
      8.93561604328085E-07
      0.00000000000000E+00  -1.61069034088212E-11   0.00000000000000E+00  -1.49768638068289E-16   2.26759460262182E-24
      1.61068772027678E-08   1.61068770529991E-08  -5.37510477748586E-21  -6.11132786371784E-01  -6.11132786371678E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06896859615505E-10   0.00000000000000E+00  -1.06896859615505E-10
      3.73325216822279E-20  -7.44783810723545E-03  -2.40673470756033E-03   0.00000000000000E+00   1.89574830283797E-14
     -2.25414526407100E-24  -1.59999991508666E-08  -1.59999801933836E-08  -3.19574169047422E-20
      8.95561604328085E-07
      0.00000000000000E+00  -1.60797173666077E-11   0.00000000000000E+00  -4.95425018158795E-16   2.18416630779584E-24
      1.60797232509763E-08   1.60797227555513E-08   2.94388423959278E-20  -6.28715415577707E-01  -6.28715415577605E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01586368544745E-10   0.00000000000000E+00  -1.01586368544745E-10
     -1.65840215407262E-19  -7.38890005055539E-03  -2.35467787208282E-03   0.00000000000000E+00   1.70957059137907E-14
     -2.14813053011409E-24  -1.59781534827125E-08  -1.59781363870065E-08   1.36401373011334E-19
      8.97561604328085E-07
      0.00000000000000E+00  -1.60588686112616E-11   0.00000000000000E+00  -3.65277355032475E-16   2.11985622960046E-24
      1.60589090703572E-08   1.60589087050799E-08   5.96182819979169E-20  -6.44216723656521E-01  -6.44216723656430E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.08694514030879E-11   0.00000000000000E+00  -9.08694514030879E-11
     -3.47579118213438E-19  -7.34855401262468E-03  -2.31751221077794E-03   0.00000000000000E+00   1.42806192766683E-14
     -2.06733444245090E-24  -1.59680535342961E-08  -1.59680392536768E-08   2.87960836215521E-19
      8.99561604328085E-07
      0.00000000000000E+00  -1.60337031532668E-11   0.00000000000000E+00  -5.09176054468057E-16   2.07228555959983E-24
      1.60337159787709E-08   1.60337154695948E-08   8.28638272846212E-20  -6.56314652864111E-01  -6.56314652864039E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.17088608220846E-11   0.00000000000000E+00  -7.17088608220846E-11
     -4.90996839857607E-19  -7.31880588447191E-03  -2.28966408933057E-03   0.00000000000000E+00   1.07751453941351E-14
     -2.00914958003967E-24  -1.59620173839181E-08  -1.59620066087727E-08   4.08133012572986E-19
      9.01561604328085E-07
      0.00000000000000E+00  -1.59969652583838E-11   0.00000000000000E+00  -8.42922453186561E-16   2.04384352425931E-24
      1.59970052155354E-08   1.59970043726130E-08   9.59928760662106E-20  -6.63205300159312E-01  -6.63205300159271E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.11412551230481E-11   0.00000000000000E+00  -4.11412551230481E-11
     -5.73279350103703E-19  -7.29969335258071E-03  -2.27248679391722E-03   0.00000000000000E+00   6.08808090089740E-15
     -1.97718530869114E-24  -1.59558692055708E-08  -1.59558631174899E-08   4.77286474037493E-19
      9.02561604328085E-07
      0.00000000000000E+00  -1.59727182477610E-11   0.00000000000000E+00  -1.16752570725402E-15   2.03515423866400E-24
      1.59727250035970E-08   1.59727238360713E-08   9.92063050976913E-20  -6.64897329087188E-01  -6.64897329087168E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.02806778678861E-11   0.00000000000000E+00  -2.02806778678861E-11
     -5.93560027971589E-19  -7.29307273073429E-03  -2.26694360013090E-03   0.00000000000000E+00   3.06169086612657E-15
     -1.96912451676346E-24  -1.59524462198943E-08  -1.59524431582034E-08   4.94353722873899E-19
      9.03911604328085E-07
      0.00000000000000E+00  -1.59337760791850E-11   0.00000000000000E+00  -1.44509362589128E-15   2.03539442110770E-24
      1.59337396020327E-08   1.59337381569391E-08   9.63675749179221E-20  -6.63399060868768E-01  -6.63399060868781E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32601341840795E-11   0.00000000000000E+00   1.32601341840795E-11
     -5.75658846823082E-19  -7.29061833239886E-03  -2.26620479103316E-03   0.00000000000000E+00  -1.69102530988303E-15
     -1.97464669591340E-24  -1.59469966000979E-08  -1.59469982911232E-08   4.79291271905160E-19
      9.05734104328085E-07
      0.00000000000000E+00  -1.58693010736653E-11   0.00000000000000E+00  -1.85047511581034E-15   2.06340911675008E-24
      1.58692918430108E-08   1.58692899925357E-08   7.64203796118785E-20  -6.52938044252810E-01  -6.52938044252878E-01
      0.00000000000000E+00   0.00000000000000E+00   6.83992795018803E-11   0.00000000000000E+00   6.83992795018803E-11
     -4.51001159930905E-19  -7.30250028286723E-03  -2.28102030600968E-03   0.00000000000000E+00  -9.65897594387376E-15
     -2.02062402032938E-24  -1.59376796130616E-08  -1.59376892720375E-08   3.74580780319026E-19
      9.07734104328085E-07
      0.00000000000000E+00  -1.57797524548880E-11   0.00000000000000E+00  -2.49363658841789E-15   2.14321598067284E-24
      1.57798250901929E-08   1.57798225965563E-08   2.92146369825164E-20  -6.28584267416270E-01  -6.28584267416413E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43200238892608E-10   0.00000000000000E+00   1.43200238892608E-10
     -1.64600682145689E-19  -7.34226146228129E-03  -2.32540382545685E-03   0.00000000000000E+00  -2.14097628663680E-14
     -2.14210252484158E-24  -1.59230014256860E-08  -1.59230228354489E-08   1.35386045163171E-19
      9.09734104328085E-07
      0.00000000000000E+00  -1.56415261253906E-11   0.00000000000000E+00  -4.91448891956371E-15   2.33497198675213E-24
      1.56415339820870E-08   1.56415290675981E-08  -5.23420496223187E-20  -5.87903452869330E-01  -5.87903452869563E-01
      0.00000000000000E+00   0.00000000000000E+00   2.32323241258757E-10   0.00000000000000E+00   2.32323241258757E-10
      3.00045800371827E-19  -7.47573390625407E-03  -2.47437080153050E-03   0.00000000000000E+00  -3.72736368239835E-14
     -2.43562338119435E-24  -1.58738150352200E-08  -1.58738523088568E-08  -2.47703750749507E-19
      9.11734104328085E-07
      0.00000000000000E+00  -1.54144859350136E-11   0.00000000000000E+00  -1.06244578877401E-13   2.80551090856004E-24
      1.54145088882628E-08   1.54144026436839E-08  -1.81953870557756E-19  -5.27138056226130E-01  -5.27138056226456E-01
      0.00000000000000E+00   0.00000000000000E+00   3.26088716293338E-10   0.00000000000000E+00   3.26088716293338E-10
      9.52223232958503E-19  -7.86550377600936E-03  -2.90613295893442E-03   0.00000000000000E+00   3.39301932305699E-14
     -3.22399823527991E-24  -1.57405252901705E-08  -1.57404913599772E-08  -7.70269362400747E-19
      9.13734104328085E-07
      0.00000000000000E+00  -1.48129029063043E-11   0.00000000000000E+00  -1.61797602755622E-14   4.19473910517384E-24
      1.48129519618455E-08   1.48129357820852E-08  -3.78237205316787E-19  -4.43433796542601E-01  -4.43433796542993E-01
      0.00000000000000E+00   0.00000000000000E+00   3.92034011577006E-10   0.00000000000000E+00   3.92034011577006E-10
      1.73629125611251E-18  -9.29284100760030E-03  -4.50224092259073E-03   0.00000000000000E+00  -1.17473789485069E-13
     -6.37929992613898E-24  -1.52048523198727E-08  -1.52049697936622E-08  -1.35805405079573E-18
      9.15734104328085E-07
      0.00000000000000E+00  -1.07570393112199E-11   0.00000000000000E+00  -1.02743105681198E-13   4.91213079865696E-24
      1.07571484455352E-08   1.07570457024295E-08  -6.39176688612164E-19  -3.36424036510479E-01  -3.36424036510879E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00062064875529E-10   0.00000000000000E+00   4.00062064875529E-10
      2.53641538586357E-18  -1.85998139864581E-02  -1.50845894478264E-02   0.00000000000000E+00  -2.05327659934612E-13
     -3.50800214244317E-23  -1.11569024396451E-08  -1.11571077673050E-08  -1.89723869725141E-18
      9.17734104328085E-07
      0.00000000000000E+00  -1.41211283456572E-12   0.00000000000000E+00  -2.35424556195102E-13  -3.16908239702574E-23
      1.41229414428268E-09   1.41205871972645E-09  -9.05464940590254E-19  -2.12549303157995E-01  -2.12549303158402E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07099239264167E-10   0.00000000000000E+00   4.07099239264167E-10
      3.35061386439190E-18  -4.59623221123793E-02  -4.53891748733027E-02   0.00000000000000E+00  -4.86437881473495E-13
     -8.34909153542081E-23  -1.81867152110906E-09  -1.81915795899062E-09  -2.44514892380165E-18
      9.19734104328085E-07
      0.00000000000000E+00   5.63008239082139E-14   0.00000000000000E+00  -4.36778656960274E-14  -4.48425623040278E-23
     -5.62425132359141E-11  -5.62861911016550E-11  -1.14763923009902E-18  -9.37267925476302E-02  -9.37267925479806E-02
      0.00000000000000E+00   0.00000000000000E+00   3.50335906381135E-10   0.00000000000000E+00   3.50335906381135E-10
      4.05128567715418E-18  -7.57525807043661E-02  -7.56599372995912E-02   0.00000000000000E+00  -1.18653892811544E-12
     -9.60462967231524E-23  -2.92863176351269E-10  -2.94049715279480E-10  -2.90364644705516E-18
      9.21734104328085E-07
      0.00000000000000E+00   5.91480107616472E-14   0.00000000000000E+00  -4.39944696815089E-15  -4.62158457901238E-23
     -5.91200016662046E-11  -5.91244011132190E-11  -1.26558638327879E-18  -3.49296709759560E-02  -3.49296709761591E-02
      0.00000000000000E+00   0.00000000000000E+00   2.03098556990028E-10   0.00000000000000E+00   2.03098556990028E-10
      4.45748279113423E-18  -1.05233629163617E-01  -1.05188268798379E-01   0.00000000000000E+00  -9.95144998966441E-13
     -1.03659724296218E-22  -1.42979010877739E-10  -1.43974155876809E-10  -3.19189640785544E-18
      9.22734104328085E-07
      0.00000000000000E+00   3.08598317017290E-14   0.00000000000000E+00  -2.15542367357749E-16  -4.64208480285321E-23
     -3.08508247158560E-11  -3.08510402582697E-11  -1.29542191402320E-18  -2.07924488572173E-02  -2.07924488573544E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37080326980029E-10   0.00000000000000E+00   1.37080326980029E-10
      4.59456311811426E-18  -1.19859073589358E-01  -1.19825605301511E-01   0.00000000000000E+00  -6.92015976104460E-13
     -1.05879054257800E-22  -1.05537270745548E-10  -1.06229286721758E-10  -3.29914120409105E-18
      9.24084104328085E-07
      0.00000000000000E+00   7.43942371380967E-15   0.00000000000000E+00   8.67688014074238E-16  -4.63875800379079E-23
     -7.44524143133882E-12  -7.44437374337113E-12  -1.31234170027393E-18  -1.34947851107297E-02  -1.34947851108233E-02
      0.00000000000000E+00   0.00000000000000E+00   9.35246172438063E-11   0.00000000000000E+00   9.35246172438063E-11
      4.72082135139340E-18  -1.39354626746540E-01  -1.39327506782045E-01   0.00000000000000E+00  -4.75133040169898E-13
     -1.07809757450479E-22  -8.56051104601566E-11  -8.60802435004343E-11  -3.40847965111947E-18
      9.25906604328085E-07
      0.00000000000000E+00  -1.12969026765258E-14   0.00000000000000E+00   1.00774929955048E-15  -4.60584169033500E-23
      1.12867786476490E-11   1.12877863969025E-11  -1.31972664863164E-18  -1.03098095195849E-02  -1.03098095196517E-02
      0.00000000000000E+00   0.00000000000000E+00   6.67607267234943E-11   0.00000000000000E+00   6.67607267234943E-11
      4.84249277584697E-18  -1.65191905584288E-01  -1.65167316248857E-01   0.00000000000000E+00  -4.08705242404870E-13
     -1.09944791141327E-22  -7.76398078778825E-11  -7.80485131203973E-11  -3.52276612721533E-18
      9.27906604328085E-07
      0.00000000000000E+00  -2.56246816809000E-14   0.00000000000000E+00   8.05308575086642E-16  -4.51926782393137E-23
      2.55962092080541E-11   2.55970145165840E-11  -1.32094005757114E-18  -9.06624047995863E-03  -9.06624048001020E-03
      0.00000000000000E+00   0.00000000000000E+00   5.15657736098949E-11   0.00000000000000E+00   5.15657736098949E-11
      4.94562432306676E-18  -1.92961100073828E-01  -1.92936789959804E-01   0.00000000000000E+00  -4.13090939497616E-13
     -1.12215895555342E-22  -7.67496971868688E-11  -7.71627881264786E-11  -3.62468426549562E-18
      9.29906604328085E-07
      0.00000000000000E+00  -3.70134290946333E-14   0.00000000000000E+00   6.22002838831023E-16  -4.33620912450955E-23
      3.69851061687210E-11   3.69857281715165E-11  -1.31936398900457E-18  -8.48829806207041E-03  -8.48829806211278E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23697668772937E-11   0.00000000000000E+00   4.23697668772937E-11
      5.03036385682134E-18  -2.20155419768296E-01  -2.20130419031631E-01   0.00000000000000E+00  -4.33359331456922E-13
     -1.14514949246035E-22  -7.89221357172392E-11  -7.93554950488107E-11  -3.71099986781677E-18
      9.31906604328085E-07
      0.00000000000000E+00  -4.67489712386311E-14   0.00000000000000E+00   4.89358463849167E-16  -3.99962013911225E-23
      4.67483763278974E-11   4.67488656863212E-11  -1.31664617640960E-18  -8.14488525189343E-03  -8.14488525192970E-03
      0.00000000000000E+00   0.00000000000000E+00   3.62670839007335E-11   0.00000000000000E+00   3.62670839007335E-11
      5.10289802462281E-18  -2.46789659945454E-01  -2.46763506204153E-01   0.00000000000000E+00  -4.53652603208128E-13
     -1.16848885651896E-22  -8.25622969837300E-11  -8.30159495870549E-11  -3.78625184821321E-18
      9.33906604328085E-07
      0.00000000000000E+00  -5.54742212733462E-14   0.00000000000000E+00   4.01594613858107E-16  -3.44768704695876E-23
      5.55066589028284E-11   5.55070604974077E-11  -1.31352944678002E-18  -7.90863925143734E-03  -7.90863925146934E-03
      0.00000000000000E+00   0.00000000000000E+00   3.20045277480140E-11   0.00000000000000E+00   3.20045277480140E-11
      5.16690708011884E-18  -2.72877435368772E-01  -2.72849865536682E-01   0.00000000000000E+00  -4.71802237947200E-13
     -1.19210381123873E-22  -8.70397860073549E-11  -8.75115882454213E-11  -3.85337763333882E-18
      9.35906604328085E-07
      0.00000000000000E+00  -6.35565581476085E-14   0.00000000000000E+00   3.43790741265751E-16  -2.62301364260031E-23
      6.35974058582739E-11   6.35977496489890E-11  -1.31036391425578E-18  -7.73326261506497E-03  -7.73326261509388E-03
      0.00000000000000E+00   0.00000000000000E+00   2.89102946594682E-11   0.00000000000000E+00   2.89102946594682E-11
      5.22472766943778E-18  -2.98426723910597E-01  -2.98397580243662E-01   0.00000000000000E+00  -4.88699958756018E-13
     -1.21594764267892E-22  -9.20193443495798E-11  -9.25080443084574E-11  -3.91436375518200E-18
      9.37906604328085E-07
      0.00000000000000E+00  -7.12715160730408E-14   0.00000000000000E+00   3.05617360081740E-16  -1.48840092954626E-23
      7.12362098943291E-11   7.12365155116743E-11  -1.30730878187633E-18  -7.59696061011934E-03  -7.59696061014591E-03
      0.00000000000000E+00   0.00000000000000E+00   2.65721090595629E-11   0.00000000000000E+00   2.65721090595629E-11
      5.27787188755690E-18  -3.23440703414505E-01  -3.23409890135638E-01   0.00000000000000E+00  -5.05745599243390E-13
     -1.24002721201868E-22  -9.73028789718698E-11  -9.78086245712372E-11  -3.97056310568058E-18
      9.39906604328086E-07
      0.00000000000000E+00  -7.85272503124354E-14   0.00000000000000E+00   2.80102258746380E-16  -4.72400008341282E-25
      7.85723183465769E-11   7.85725984488352E-11  -1.30442644896678E-18  -7.48743895222514E-03  -7.48743895224987E-03
      0.00000000000000E+00   0.00000000000000E+00   2.47295285298030E-11   0.00000000000000E+00   2.47295285298030E-11
      5.32733094461651E-18  -3.47927985884680E-01  -3.47895442250978E-01   0.00000000000000E+00  -5.24406272061048E-13
     -1.26440531868304E-22  -1.02777720706451E-10  -1.03302126978639E-10  -4.02290449564973E-18
      9.41906604328086E-07
      0.00000000000000E+00  -8.57829845518300E-14   0.00000000000000E+00   2.64767087409559E-16   1.59534637390540E-23
      8.57448191971526E-11   8.57450839642560E-11  -1.30170565640722E-18  -7.41013234953964E-03  -7.41013234956282E-03
      0.00000000000000E+00   0.00000000000000E+00   2.31729149844050E-11   0.00000000000000E+00   2.31729149844050E-11
      5.37367677458531E-18  -3.71881932663689E-01  -3.71847620162252E-01   0.00000000000000E+00  -5.44862347749988E-13
     -1.28913664566445E-22  -1.08373136600782E-10  -1.08917998948661E-10  -4.07197111817810E-18
      9.43906604328086E-07
      0.00000000000000E+00  -9.28550293168095E-14   0.00000000000000E+00   2.54999555875936E-16   3.29626246636821E-23
      9.28260723427565E-11   9.28263273423454E-11  -1.29912883733489E-18  -7.36381459752385E-03  -7.36381459754568E-03
      0.00000000000000E+00   0.00000000000000E+00   2.18333547990168E-11   0.00000000000000E+00   2.18333547990168E-11
      5.41734348418335E-18  -3.95334422507475E-01  -3.95298301543956E-01   0.00000000000000E+00  -5.69131486958806E-13
     -1.31434611908382E-22  -1.14090550654271E-10  -1.14659682141362E-10  -4.11821464684846E-18
      9.45906604328086E-07
      0.00000000000000E+00  -9.98352293445816E-14   0.00000000000000E+00   2.46722352277529E-16   4.96049320588756E-23
      9.98345500914678E-11   9.98347968138697E-11  -1.29670307416269E-18  -7.32970298630285E-03  -7.32970298632362E-03
      0.00000000000000E+00   0.00000000000000E+00   2.07628827441246E-11   0.00000000000000E+00   2.07628827441246E-11
      5.45886924967160E-18  -4.18440054608367E-01  -4.18402063380840E-01   0.00000000000000E+00  -6.02448927509759E-13
     -1.34035230296403E-22  -1.19995230630351E-10  -1.20597679557994E-10  -4.16216617550891E-18
      9.47906604328086E-07
      0.00000000000000E+00  -1.06815429372354E-13   0.00000000000000E+00   2.40044071426509E-16   6.50464135544558E-23
      1.06783970366920E-10   1.06784210411057E-10  -1.29441684786666E-18  -7.30578389353492E-03  -7.30578389355466E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97418346037054E-11   0.00000000000000E+00   1.97418346037054E-11
      5.49835291887901E-18  -4.41150137027684E-01  -4.41110278624456E-01   0.00000000000000E+00  -6.37874490708815E-13
     -1.36712152374563E-22  -1.25888170523917E-10  -1.26526045014762E-10  -4.20393607101235E-18
      9.48906604328086E-07
      0.00000000000000E+00  -1.10305529386240E-13   0.00000000000000E+00   2.38179106872467E-16   7.25340888836235E-23
      1.10272836254419E-10   1.10273074433599E-10  -1.29330864980162E-18  -7.29654969215058E-03  -7.29654969216976E-03
      0.00000000000000E+00   0.00000000000000E+00   1.91848313394805E-11   0.00000000000000E+00   1.91848313394805E-11
      5.51753775021849E-18  -4.52395167250360E-01  -4.52354385458123E-01   0.00000000000000E+00  -6.65215286098040E-13
     -1.38075497772373E-22  -1.28792690486841E-10  -1.29457905773077E-10  -4.22422910041687E-18
      9.50256604328086E-07
      0.00000000000000E+00  -1.14897766246616E-13   0.00000000000000E+00   2.33959760099805E-16   8.15901702114008E-23
      1.14938437020731E-10   1.14938670980572E-10  -1.29186688645724E-18  -7.28984698349730E-03  -7.28984698351581E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85082776973288E-11   0.00000000000000E+00   1.85082776973288E-11
      5.54252392510989E-18  -4.67370824488255E-01  -4.67328786377605E-01   0.00000000000000E+00  -6.88467574981866E-13
     -1.39943752117354E-22  -1.32758481102781E-10  -1.33446948677903E-10  -4.25065703865265E-18
      9.52079104328086E-07
      0.00000000000000E+00  -1.21143208376728E-13   0.00000000000000E+00   2.29636210479636E-16   9.19476289061220E-23
      1.21175069456447E-10   1.21175299092750E-10  -1.29000127250222E-18  -7.29386478731439E-03  -7.29386478733203E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76427841311315E-11   0.00000000000000E+00   1.76427841311315E-11
      5.57467789918887E-18  -4.87214504215281E-01  -4.87170774553546E-01   0.00000000000000E+00  -7.20342623869951E-13
     -1.42507068319669E-22  -1.38097740599868E-10  -1.38818083223881E-10  -4.28467662668665E-18
      9.54079104328086E-07
      0.00000000000000E+00  -1.28031563667292E-13   0.00000000000000E+00   2.27242293092164E-16   1.01328612791563E-22
      1.27998507894413E-10   1.27998735136807E-10  -1.28802426307078E-18  -7.32031162090933E-03  -7.32031162092605E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67219783400642E-11   0.00000000000000E+00   1.67219783400642E-11
      5.60812185586900E-18  -5.08547721583351E-01  -5.08502133045404E-01   0.00000000000000E+00  -7.59005232730296E-13
     -1.45357760983324E-22  -1.43961708243996E-10  -1.44720713476872E-10  -4.32009759279822E-18
      9.56079104328086E-07
      0.00000000000000E+00  -1.34919918957857E-13   0.00000000000000E+00   2.30205284631580E-16   1.09045020301855E-22
      1.34922029227185E-10   1.34922259432578E-10  -1.28605720534123E-18  -7.39103036418691E-03  -7.39103036420272E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58063558883341E-11   0.00000000000000E+00   1.58063558883341E-11
      5.63973456764567E-18  -5.29446525718317E-01  -5.29399045212142E-01   0.00000000000000E+00  -7.98511856039018E-13
     -1.48224937935140E-22  -1.49930103464725E-10  -1.50728615320912E-10  -4.35367736230444E-18
      9.58079104328085E-07
      0.00000000000000E+00  -1.42634876883289E-13   0.00000000000000E+00   2.63060325169225E-16   1.15800101738202E-22
      1.42633845517400E-10   1.42634108577841E-10  -1.28379652078292E-18  -7.64059940578073E-03  -7.64059940579543E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47066557477186E-11   0.00000000000000E+00   1.47066557477186E-11
      5.66914787914111E-18  -5.49919327677462E-01  -5.49869764942683E-01   0.00000000000000E+00  -8.30468424711687E-13
     -1.51066409032435E-22  -1.56510295900698E-10  -1.57340764325560E-10  -4.38535135835819E-18
      9.60079104328085E-07
      0.00000000000000E+00  -1.52829642713325E-13   0.00000000000000E+00   3.67166409888960E-16   1.22838122814755E-22
      1.52839780880543E-10   1.52840148047076E-10  -1.28051028350059E-18  -8.39340540697977E-03  -8.39340540699284E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30769520354028E-11   0.00000000000000E+00   1.30769520354028E-11
      5.69530178321191E-18  -5.69971736932042E-01  -5.69919473346653E-01   0.00000000000000E+00  -8.43237534111841E-13
     -1.53812166720226E-22  -1.65073862548213E-10  -1.65917100082479E-10  -4.41479149971132E-18
      9.62079104328085E-07
      0.00000000000000E+00  -1.80842287561620E-13   0.00000000000000E+00   1.07864250756198E-15   1.38938308079356E-22
      1.80832867586924E-10   1.80833946229570E-10  -1.27052671531738E-18  -1.22368616672603E-02  -1.22368616672671E-02
      0.00000000000000E+00   0.00000000000000E+00   6.83894647818015E-12   0.00000000000000E+00   6.83894647818015E-12
      5.70897967616827E-18  -5.89587394196997E-01  -5.89528278513292E-01   0.00000000000000E+00  -7.19409252053753E-13
     -1.56050488550081E-22  -1.86953483455540E-10  -1.87672892707750E-10  -4.43845296085089E-18
      9.64079104328085E-07
      0.00000000000000E+00  -3.54428840883846E-13   0.00000000000000E+00   7.82340830593543E-15   2.16831782124724E-22
      3.54462512020414E-10   3.54470335428937E-10  -1.22131091637912E-18  -3.34804780724989E-02  -3.34804780724725E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.64256011015234E-11   0.00000000000000E+00  -2.64256011015234E-11
      5.65612847396522E-18  -6.08545695916460E-01  -6.08442366094300E-01   0.00000000000000E+00   1.38473661591940E-13
     -1.55615173502942E-22  -3.28183207988850E-10  -3.28044734327413E-10  -4.43481755758611E-18
      9.66079104328085E-07
      0.00000000000000E+00  -7.76730942564054E-13   0.00000000000000E+00   1.25469384170659E-14   3.03854768029802E-22
      7.76725155887214E-10   7.76737702825935E-10  -1.14885295575827E-18  -6.30333240143131E-02  -6.30333240142644E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.88189204622104E-11   0.00000000000000E+00  -4.88189204622104E-11
      5.55849063304080E-18  -6.26357344356531E-01  -6.26128056721160E-01   0.00000000000000E+00   5.07871887581075E-13
     -1.54022456008093E-22  -7.28426654251152E-10  -7.27918782363725E-10  -4.40963767728254E-18
      9.68079104328085E-07
      0.00000000000000E+00  -1.59993532215512E-12   0.00000000000000E+00   2.20928831101178E-14   3.57044660243338E-22
      1.59987371709871E-09   1.59989580998218E-09  -1.07484499530584E-18  -9.26816177864962E-02  -9.26816177864374E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.87468202510656E-11   0.00000000000000E+00  -5.87468202510656E-11
      5.44099699253868E-18  -6.42244241493046E-01  -6.41758789807689E-01   0.00000000000000E+00   4.50870360399574E-13
     -1.52552855115327E-22  -1.54159986009136E-09  -1.54114898973111E-09  -4.36615199723283E-18
      9.70079104328085E-07
      0.00000000000000E+00  -3.08561579122407E-12   0.00000000000000E+00   3.81719578663809E-14   3.94832221225460E-22
      3.08559764586546E-09   3.08563581782373E-09  -1.00568999973725E-18  -1.21883914921991E-01  -1.21883914921921E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97873717317344E-11   0.00000000000000E+00  -6.97873717317344E-11
      5.30142224907520E-18  -6.54962710596445E-01  -6.54012732164585E-01   0.00000000000000E+00   3.59480659355727E-13
     -1.51320728151922E-22  -3.01620792675120E-09  -3.01584844609199E-09  -4.29573224933795E-18
      9.72079104328085E-07
      0.00000000000000E+00  -5.50324480873780E-12   0.00000000000000E+00   6.09479775711721E-14   4.25113035662595E-22
      5.50321616983708E-09   5.50327711781508E-09  -9.43793329805865E-19  -1.50536861224858E-01  -1.50536861224774E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.38330595453426E-11   0.00000000000000E+00  -8.38330595453426E-11
      5.13375612998452E-18  -6.62775097602391E-01  -6.61067988543545E-01   0.00000000000000E+00   2.66210811330226E-13
     -1.50341333433157E-22  -5.41971026908092E-09  -5.41944405826974E-09  -4.18996280017865E-18
      9.74079104328085E-07
      0.00000000000000E+00  -9.05910565446440E-12   0.00000000000000E+00   8.88563098881756E-14   4.46253274700737E-22
      9.05897807029199E-09   9.05906692660233E-09  -8.88620516308270E-19  -1.78609352028419E-01  -1.78609352028319E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97877074121435E-11   0.00000000000000E+00  -9.97877074121435E-11
      4.93418071516023E-18  -6.63575408198102E-01  -6.60753246284942E-01   0.00000000000000E+00   2.43710963722382E-13
     -1.49381313957127E-22  -8.95952293015376E-09  -8.95927921919019E-09  -4.04556019885196E-18
      9.76079104328085E-07
      0.00000000000000E+00  -1.39130081711450E-11   0.00000000000000E+00   1.20776877221120E-13   4.55761579088842E-22
      1.39128591713661E-08   1.39129799482438E-08  -8.38259944390610E-19  -2.06101342953132E-01  -2.06101342953017E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14847311768106E-10   0.00000000000000E+00  -1.14847311768106E-10
      4.70448609162402E-18  -6.54981976562748E-01  -6.50635546158806E-01   0.00000000000000E+00   4.00726181661117E-13
     -1.47808337744106E-22  -1.37985333626572E-08  -1.37981326364757E-08  -3.86622614723341E-18
      9.78079104328085E-07
      0.00000000000000E+00  -2.02767463227801E-11   0.00000000000000E+00   1.58015789504025E-13   4.53086998205016E-22
      2.02765720237623E-08   2.02767300395522E-08  -7.90737444076656E-19  -2.33025154818895E-01  -2.33025154818768E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26851842689900E-10   0.00000000000000E+00  -1.26851842689900E-10
      4.45078240624423E-18  -6.34242035382969E-01  -6.27894701528648E-01   0.00000000000000E+00   8.05907821982176E-13
     -1.44646903786304E-22  -2.01506841046841E-08  -2.01498781968623E-08  -3.66004496216757E-18
      9.80079104328085E-07
      0.00000000000000E+00  -2.84554283263731E-11   0.00000000000000E+00   2.02922046327851E-13   4.38866480480092E-22
      2.84552594166528E-08   2.84554623386995E-08  -7.44583661993617E-19  -2.59395642828361E-01  -2.59395642828225E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35733069892839E-10   0.00000000000000E+00  -1.35733069892839E-10
      4.17931626645854E-18  -5.98057899106769E-01  -5.89136788474523E-01   0.00000000000000E+00   1.40040159429589E-12
     -1.38840230602226E-22  -2.83211296704008E-08  -2.83197292688067E-08  -3.43473260446492E-18
      9.82079104328085E-07
      0.00000000000000E+00  -3.86996066250263E-11   0.00000000000000E+00   2.54212193308962E-13   4.11890330101032E-22
      3.86993794542378E-08   3.86996336664315E-08  -6.98979616501055E-19  -2.85224242044659E-01  -2.85224242044516E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43630629171245E-10   0.00000000000000E+00  -1.43630629171245E-10
      3.89205500811605E-18  -5.42696976968811E-01  -5.30550869158194E-01   0.00000000000000E+00   1.94713474889013E-12
     -1.29830510555671E-22  -3.85579501720090E-08  -3.85560030372602E-08  -3.19307539161500E-18
      9.84079104328085E-07
      0.00000000000000E+00  -5.07602901361698E-11   0.00000000000000E+00   2.99593790561800E-13   3.61803464736567E-22
      5.07599933248777E-08   5.07602929186686E-08  -6.53785464250530E-19  -3.10515808337351E-01  -3.10515808337197E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54068578973578E-10   0.00000000000000E+00  -1.54068578973578E-10
      3.58391785016890E-18  -4.64944288971762E-01  -4.49001432357248E-01   0.00000000000000E+00   2.11900043299716E-12
     -1.18638946250437E-22  -5.06083433401279E-08  -5.06062243396950E-08  -2.93013238591837E-18
      9.86079104328085E-07
      0.00000000000000E+00  -6.35729065108315E-11   0.00000000000000E+00   3.18809842651728E-13   2.86092776716778E-22
      6.35725868451757E-08   6.35729056550186E-08  -6.09101793073047E-19  -3.35275660029295E-01  -3.35275660029128E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66918618596212E-10   0.00000000000000E+00  -1.66918618596212E-10
      3.25008061297647E-18  -3.63655682525321E-01  -3.43679683962070E-01   0.00000000000000E+00   1.92437729583707E-12
     -1.06589801797132E-22  -6.34079114137181E-08  -6.34059870364224E-08  -2.64097881990342E-18
      9.88079104328085E-07
      0.00000000000000E+00  -7.45451380413286E-11   0.00000000000000E+00   2.73600377572333E-13   2.22858154754831E-22
      7.45448670354653E-08   7.45451406358431E-08  -5.65054288647022E-19  -3.59509390545048E-01  -3.59509390544866E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82082833817615E-10   0.00000000000000E+00  -1.82082833817615E-10
      2.88591494534124E-18  -2.42889144640737E-01  -2.19460396232655E-01   0.00000000000000E+00   1.49567407011557E-12
     -9.23154086796228E-23  -7.43645534760955E-08  -7.43630578020254E-08  -2.32086065669422E-18
      9.90079104328085E-07
      0.00000000000000E+00  -7.75547982348821E-11   0.00000000000000E+00   7.85062652930512E-14   1.20976832502693E-22
      7.75547031291152E-08   7.75547816353806E-08  -5.22215454279239E-19  -3.83205939399433E-01  -3.83205939399224E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08037225522133E-10   0.00000000000000E+00  -2.08037225522133E-10
      2.46984049429698E-18  -1.18569205909305E-01  -9.41999688280727E-02   0.00000000000000E+00   8.88647488968163E-13
     -7.70569183000459E-23  -7.73476330573474E-08  -7.73467444098585E-08  -1.94762504001774E-18
      9.92079104328084E-07
      0.00000000000000E+00  -5.32277908459873E-11   0.00000000000000E+00  -6.04492616928255E-13   3.38443360054274E-23
      5.32283969888041E-08   5.32277924961872E-08  -4.71795671756635E-19  -4.06484580756156E-01  -4.06484580755978E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.78349732380527E-10   0.00000000000000E+00  -1.78349732380527E-10
      2.11314102953592E-18  -4.40645400673086E-02  -2.73504108018555E-02   0.00000000000000E+00   9.32459476464071E-13
     -3.16356206144197E-23  -5.30503752232832E-08  -5.30494427638067E-08  -1.64134535777929E-18
      9.94079104328084E-07
      0.00000000000000E+00  -2.85869499900543E-11   0.00000000000000E+00  -6.09785103296093E-13   1.12307974998937E-23
      2.85875225829309E-08   2.85869127978276E-08  -4.14040548081159E-19  -4.29410232507644E-01  -4.29410232507525E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19631983633223E-10   0.00000000000000E+00  -1.19631983633223E-10
      1.87387706226948E-18  -1.90035447254903E-02  -1.00344232701326E-02   0.00000000000000E+00   7.08929022145274E-13
     -1.18743056592489E-23  -2.84679897432165E-08  -2.84672808141943E-08  -1.45983651418832E-18
      9.94329104328084E-07
      0.00000000000000E+00  -2.55126311015068E-11   0.00000000000000E+00  -6.07344705216507E-13   9.38174261938808E-24
      2.55132207978515E-08   2.55126134531463E-08  -4.06723688387943E-19  -4.32269954349104E-01  -4.32269954348990E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14273914918377E-10   0.00000000000000E+00  -1.14273914918377E-10
      1.84530858353988E-18  -1.66407076524668E-02  -8.63850885192841E-03   0.00000000000000E+00   6.80427614311121E-13
     -1.05162167362919E-23  -2.53990199658422E-08  -2.53983395382279E-08  -1.43858489515194E-18
      9.94666604328084E-07
      0.00000000000000E+00  -2.26200729478929E-11   0.00000000000000E+00  -4.23002933647498E-13   7.87220999250112E-24
      2.26204643611698E-08   2.26200413582362E-08  -3.96974262848421E-19  -4.36119368333790E-01  -4.36119368333682E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07984103405368E-10   0.00000000000000E+00  -1.07984103405368E-10
      1.80886394864057E-18  -1.44279805092088E-02  -7.33515450602749E-03   0.00000000000000E+00   4.86201924230167E-13
     -8.95557455770263E-24  -2.25125434567550E-08  -2.25120572548308E-08  -1.41188968579215E-18
      9.95122229328084E-07
      0.00000000000000E+00  -2.01924328540236E-11   0.00000000000000E+00  -2.62678994507519E-13   6.62508146259789E-24
      2.01926725544546E-08   2.01924098754601E-08  -3.84018111661200E-19  -4.41294074669594E-01  -4.41294074669491E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03168521647830E-10   0.00000000000000E+00  -1.03168521647830E-10
      1.76185779096478E-18  -1.25474272433006E-02  -6.21795085618504E-03   0.00000000000000E+00   3.17744044714226E-13
     -7.54696092578658E-24  -2.00895590978570E-08  -2.00892413538123E-08  -1.37783967930358E-18
      9.95737323078084E-07
      0.00000000000000E+00  -1.84155127232696E-11   0.00000000000000E+00  -1.42175318865561E-13   5.63904233212130E-24
      1.84156821799387E-08   1.84155400046198E-08  -3.66832212452425E-19  -4.48237938477176E-01  -4.48237938477076E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00166510774612E-10   0.00000000000000E+00  -1.00166510774612E-10
      1.70024599622801E-18  -1.11014655286609E-02  -5.33087611869514E-03   0.00000000000000E+00   1.90806837159468E-13
     -6.40752367907025E-24  -1.83155643006823E-08  -1.83153734938452E-08  -1.33341378377558E-18
      9.96567699640584E-07
      0.00000000000000E+00  -1.73017115951539E-11   0.00000000000000E+00  -6.58688884351263E-14   4.87965893616151E-24
      1.73017831185873E-08   1.73017172496989E-08  -3.44093416121542E-19  -4.57533871131388E-01  -4.57533871131289E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90197789834369E-11   0.00000000000000E+00  -9.90197789834369E-11
      1.61802229253623E-18  -1.00732175694464E-02  -4.65319464961288E-03   0.00000000000000E+00   1.09513317264851E-13
     -5.51999523887799E-24  -1.72028069840327E-08  -1.72026974707154E-08  -1.27392887641469E-18
      9.97688707999959E-07
      0.00000000000000E+00  -1.67041697348817E-11   0.00000000000000E+00  -2.68879238588049E-14   4.27624070590187E-24
      1.67042270747313E-08   1.67042001868074E-08  -3.14149750181285E-19  -4.69940131034718E-01  -4.69940131034619E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94279322295746E-11   0.00000000000000E+00  -9.94279322295746E-11
      1.50656274935151E-18  -9.35291708795362E-03  -4.12127861965549E-03   0.00000000000000E+00   6.63771827577350E-14
     -4.80147175411583E-24  -1.66048386317606E-08  -1.66047722545778E-08  -1.19241299917022E-18
      9.99202069285116E-07
      0.00000000000000E+00  -1.64170630863710E-11   0.00000000000000E+00  -1.84980485010619E-14   3.76145559282908E-24
      1.64169946896584E-08   1.64169761916099E-08  -2.75042851168498E-19  -4.86430001274116E-01  -4.86430001274015E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00927447922531E-10   0.00000000000000E+00  -1.00927447922531E-10
      1.35382305705592E-18  -8.81271573741680E-03  -3.67203932086187E-03   0.00000000000000E+00   5.40566497174614E-14
     -4.17043741052089E-24  -1.63161028003371E-08  -1.63160487436874E-08  -1.07878020588742E-18
      1.00000000000000E-06
      0.00000000000000E+00  -1.63248509702146E-11   0.00000000000000E+00  -5.63764914956043E-15   3.54720647430726E-24
      1.63248702325514E-08   1.63248645949022E-08  -2.54916728272463E-19  -4.95052141827765E-01  -4.95052141827663E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02930349278003E-10   0.00000000000000E+00  -1.02930349278003E-10
      1.27169176987323E-18  -8.60169810974616E-03  -3.49067572243483E-03   0.00000000000000E+00   3.86782984241477E-14
     -3.91931701215275E-24  -1.62219729239226E-08  -1.62219342456242E-08  -1.01677504160077E-18
}
